/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.activation.dialog.ActivationCloseConfirmationDialog;
import com.kms.katalon.activation.dialog.AdvancedSettingsDialog;
import com.kms.katalon.activation.dialog.AuthenRequestOptions;
import com.kms.katalon.activation.dialog.BaseModernDialog;
import com.kms.katalon.composer.components.controls.TextField;
import com.kms.katalon.composer.components.impl.overlay.OverlayShell;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.core.model.KatalonEdition;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.session.core.model.AuthenticationResponse;
import com.kms.katalon.session.core.model.RememberMeOption;
import com.kms.katalon.session.core.services.ISessionService;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.EventHandler;

public abstract class BaseModernActivationDialog
extends BaseModernDialog {
    private static final Pattern DOWNLOAD_FREE_PACKAGE = Pattern.compile(".*download the free package.*");
    @Inject
    IDiscoveryController discoveryController;
    @Inject
    ISessionService sessionService;
    @Inject
    private IEventBroker eventBroker;
    private final int SOCIAL_BUTTON_SIZE = 40;
    private final int LOGIN_GLOBE_ICON_SIZE = 24;
    private final int ERROR_ICON_SIZE = 40;
    private TextField usernameInput;
    private TextField passwordInput;
    private Canvas browserLoginBtn;
    private Canvas licenseServerLoginBtn;
    private Canvas offlineLicenseLoginInBtn;
    private Button rememberMeCheckbox;
    private Link statusLabel;
    private Link troubleshootLink;
    private Link downloadFreeEditionLink;
    protected AuthenRequestOptions options;
    private Shell realParentShell;
    private Set<Control> inputAndButtons = new HashSet<Control>();
    private Label errorIcon;
    private Composite messageContentComposite;
    private final EventHandler onSsoAuthResponseGrabbed = event -> this.handleSSOAuthenticationResponseGrabbed((AuthenticationResponse)event.getProperty("org.eclipse.e4.data"));

    public String getUsername() {
        return StringUtils.trim((String)this.usernameInput.getText());
    }

    public String getPassword() {
        return this.passwordInput.getText();
    }

    public BaseModernActivationDialog(Shell parentShell, AuthenRequestOptions options) {
        super(BaseModernActivationDialog.initBackdrop(parentShell));
        this.realParentShell = parentShell;
        this.options = options != null ? options : new AuthenRequestOptions();
    }

    protected static Shell initBackdrop(Shell parentShell) {
        if (SystemUtils.IS_OS_LINUX) {
            return parentShell;
        }
        OverlayShell backdrop = new OverlayShell((Control)parentShell, 32768);
        backdrop.setBackground(ColorUtil.themeColor((String)"#E3E3E3", (String)"#000"));
        backdrop.setAlpha(200);
        backdrop.open();
        return backdrop.getShell();
    }

    @Override
    protected Point getInitialSize() {
        return this.options.isSimpleMode() ? new Point(470, -1) : super.getInitialSize();
    }

    @Override
    public String getDialogTitle() {
        return this.options.isSimpleMode() ? "Katalon account" : "";
    }

    @Override
    protected boolean useButtonBar() {
        return !this.options.isSimpleMode();
    }

    @Override
    protected void createContent(Composite container) {
        Composite header = (Composite)ComponentBuilder.gridContainer((Composite)container).marginBottom(ComponentUtil.applyZoom((int)16)).fillHorizontal().build();
        ComponentBuilder.label((Composite)header).text(ApplicationEdition.get().equals((Object)KatalonEdition.ENTERPRISE) ? MessageConstants.ENTERPRISE_LOGIN_DIALOG_TITLE : MessageConstants.FREE_LOGIN_DIALOG_TITLE).fontSize(18).bold().textCenter().fillHorizontal().build();
        this.getShell().pack();
        Composite loginButtonsGroup = (Composite)ComponentBuilder.gridContainer((Composite)container).gridSpacing(this.applyZoom(6)).fillHorizontal().build();
        this.browserLoginBtn = (Canvas)ComponentBuilder.canvas((Composite)loginButtonsGroup).text("Log in from Browser").image("login_globe.png", 16384).imageSize(this.applyZoom(24), this.applyZoom(24)).applyPrimaryButtonStyle3WithCustomDisableColors(ColorUtil.getTextWhiteColor(), ColorUtil.getColor((String)"#2236E5"), ColorUtil.getColor((String)"#2133D1")).autoHeight(40).fontSize(14).bold().addTo(this.inputAndButtons).fillHorizontal().onClick(event -> {
            this.clearMessage();
            Trackings.trackLoginDialogAction((String)"sign-in-browser", Optional.of(RememberMeOption.isExplicitlyEnabled((RememberMeOption)this.sessionService.getRememberMeOption())));
            this.handleSignInWithSSO();
        }).build();
        this.createMessageContent(loginButtonsGroup);
        this.eventBroker.subscribe("AUTHENTICATION_RESPONSE_GRABBED", this.onSsoAuthResponseGrabbed);
        if (KatalonEdition.FREE != ApplicationEdition.get()) {
            Composite orWrapper = (Composite)ComponentBuilder.gridContainer((Composite)loginButtonsGroup, (int)3).marginVertical(this.applyZoom(10)).gridSpacing(0).fillHorizontal().build();
            ComponentBuilder.separator((Composite)orWrapper).gridSpacing(0).build();
            ComponentBuilder.label((Composite)orWrapper).text("or log in with").gridSpacing(0).color(ColorUtil.getColor((String)"#919299")).fontSize(12).marginBottom(4).textCenter().fillHorizontal().build();
            ComponentBuilder.separator((Composite)orWrapper).gridSpacing(0).build();
            Composite buttonBar = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2, (boolean)true).fillHorizontal().marginTop(this.options.isSimpleMode() ? this.applyZoom(10) : 0).marginBottom(this.applyZoom(10)).gridSpacing(this.applyZoom(10)).build();
            Color secondaryButtonDisabledColor = ColorUtil.themeColor((Color)ColorUtil.getColor((String)"#18181A"), (Color)ColorUtil.getTextWhiteColor());
            Color secondaryButtonDisabledBackgroundColor = ColorUtil.themeColor((Color)ColorUtil.getWhiteBackgroundColor(), (Color)ColorUtil.getColor((String)"#525658"));
            this.licenseServerLoginBtn = (Canvas)ComponentBuilder.canvas((Composite)buttonBar).text("License server").submitButton().applySecondaryButtonStyleWithCustomDisabledColor(secondaryButtonDisabledColor, secondaryButtonDisabledBackgroundColor).bold().fontSize(14).autoHeight(45).addTo(this.inputAndButtons).onClick(event -> {
                this.clearMessage();
                Trackings.trackLoginDialogAction((String)"license-server", Optional.of(RememberMeOption.isExplicitlyEnabled((RememberMeOption)this.sessionService.getRememberMeOption())));
                this.handleSignInWithLicenseServer();
            }).fillHorizontal().build();
            this.offlineLicenseLoginInBtn = (Canvas)ComponentBuilder.canvas((Composite)buttonBar).text("Offline license").submitButton().applySecondaryButtonStyleWithCustomDisabledColor(secondaryButtonDisabledColor, secondaryButtonDisabledBackgroundColor).bold().fontSize(14).autoHeight(45).addTo(this.inputAndButtons).onClick(event -> {
                this.clearMessage();
                Trackings.trackLoginDialogAction((String)"offline-activation", Optional.empty());
                this.handleOfflineActivation();
            }).fillHorizontal().build();
            this.rememberMeCheckbox = (Button)ComponentBuilder.checkBox((Composite)container).text(MessageConstants.LBL_REMEMBER_ME).onSelection(event -> this.saveRememberMeOptionFromCheckboxState()).build();
            RememberMeOption rememberMeOption = this.sessionService.getRememberMeOption();
            this.rememberMeCheckbox.setSelection(rememberMeOption == RememberMeOption.API_KEY || rememberMeOption == RememberMeOption.UNSET);
            if (rememberMeOption == RememberMeOption.UNSET) {
                this.saveRememberMeOptionFromCheckboxState();
            }
        } else {
            ComponentBuilder.gridContainer((Composite)loginButtonsGroup).marginVertical(this.applyZoom(3)).gridSpacing(0).fillHorizontal().build();
        }
        if (!this.discoveryController.isDiscovered()) {
            this.showUnableToConnectMessage();
        }
    }

    @Override
    protected void createButtons(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).marginBottom(this.applyZoom(4)).fillHorizontal().center().color(ColorUtil.GRAY_BADGE_COLOR).build();
        Composite wrapper1 = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().left().build();
        ComponentBuilder.label((Composite)wrapper1, (int)4).linkButtonWithCustomDisabledColor(ColorUtil.themeColor((Color)ColorUtil.getTextBlackColor(), (Color)ColorUtil.getTextWhiteColor())).text("Advanced settings").fontSize(10).addTo(this.inputAndButtons).cursorPointer().onClick(event -> {
            Trackings.trackLoginDialogAction((String)"proxy-settings", Optional.empty());
            AdvancedSettingsDialog advancedSettingDialog = new AdvancedSettingsDialog(this.getShell());
            IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
            ContextInjectionFactory.inject((Object)((Object)advancedSettingDialog), (IEclipseContext)context);
            if (advancedSettingDialog.open() == 0) {
                this.discoverEndpoints();
            }
        }).build();
    }

    private void createMessageContent(Composite parent) {
        this.messageContentComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).width(this.getInitialSize().x).fillHorizontal().center().marginTop(this.applyZoom(4)).hide().build();
        this.errorIcon = (Label)ComponentBuilder.label((Composite)this.messageContentComposite).image("error_icon.png", 128).imageSize(this.applyZoom(40), this.applyZoom(40)).hide().build();
        Composite statusComposite = (Composite)ComponentBuilder.gridContainer((Composite)this.messageContentComposite).fillHorizontal().marginLeft(this.applyZoom(8)).build();
        this.statusLabel = (Link)ComponentBuilder.link((Composite)statusComposite, (int)64).color(ColorUtil.getTextErrorColor()).fontSize(10).fillHorizontal().center().hide().build();
        this.troubleshootLink = (Link)ComponentBuilder.link((Composite)statusComposite).linkButtonText("Troubleshoot").fontSize(10).onSelection(event -> {
            UISynchronizeService.asyncExec(() -> {
                String email = StringUtils.trim((String)this.usernameInput.getText());
                String errorMessage = this.statusLabel.getText();
                Trackings.trackLoginDialogAction((String)"troubleshoot", Optional.empty());
                Trackings.trackTroubleshootFailedActivation((String)email, (String)errorMessage);
            });
            ComponentUtil.triggerLink((String)DocumentationMessageConstants.TROUBLESHOOT_ACTIVATION);
        }).fillHorizontal().hide().build();
        this.downloadFreeEditionLink = (Link)ComponentBuilder.link((Composite)statusComposite).linkButtonText("Download Free Edition").fontSize(10).onSelection(event -> {
            UISynchronizeService.asyncExec(() -> {
                String email = StringUtils.trim((String)this.usernameInput.getText());
                String errorMessage = this.statusLabel.getText();
                Trackings.trackLoginDialogAction((String)"download_free_edition", Optional.empty());
                Trackings.trackTroubleshootFailedActivation((String)email, (String)errorMessage);
            });
            ComponentUtil.triggerLink((String)DocumentationMessageConstants.DOWNLOAD_FREE_EDITION);
        }).fillHorizontal().hide().build();
    }

    public void setMessage(String message) {
        if (this.statusLabel.isDisposed()) {
            return;
        }
        ComponentUtil.show((Control)this.messageContentComposite);
        ComponentUtil.hide((Control)this.errorIcon);
        ComponentUtil.hide((Control)this.troubleshootLink);
        ComponentUtil.hide((Control)this.downloadFreeEditionLink);
        ComponentUtil.show((Control)this.statusLabel);
        ComponentUtil.showSuccess((Control)this.statusLabel, (String)ComponentUtil.autoWrapLinks((String)message), (boolean)true);
        this.messageContentComposite.getBounds().width = this.container.getBounds().width;
        this.getShell().pack();
    }

    public void setErrorMessage(String message) {
        if (this.statusLabel == null || this.statusLabel.isDisposed()) {
            return;
        }
        ComponentUtil.show((Control)this.messageContentComposite);
        ComponentUtil.show((Control)this.errorIcon);
        ComponentUtil.show((Control)this.statusLabel);
        if (DOWNLOAD_FREE_PACKAGE.matcher(message).matches()) {
            ComponentUtil.hide((Control)this.troubleshootLink);
            ComponentUtil.show((Control)this.downloadFreeEditionLink);
        } else {
            ComponentUtil.show((Control)this.troubleshootLink);
            ComponentUtil.hide((Control)this.downloadFreeEditionLink);
        }
        ComponentUtil.showError((Control)this.statusLabel, (String)ComponentUtil.autoWrapLinks((String)message), (boolean)true);
        this.getShell().pack();
    }

    public void clearMessage() {
        if (this.statusLabel.isDisposed()) {
            return;
        }
        ComponentUtil.hide((Control)this.messageContentComposite);
        ComponentUtil.hide((Control)this.statusLabel);
        ComponentUtil.hide((Control)this.errorIcon);
        ComponentUtil.setText((Widget)this.statusLabel, (String)"");
        this.getShell().pack();
    }

    public void blockUI() {
        this.blockUI(true);
    }

    public void blockUI(boolean blocked) {
        if (Objects.nonNull(this.licenseServerLoginBtn) && this.licenseServerLoginBtn.isDisposed() || Objects.nonNull(this.offlineLicenseLoginInBtn) && this.offlineLicenseLoginInBtn.isDisposed()) {
            return;
        }
        boolean enabled = !blocked;
        this.inputAndButtons.forEach(controlI -> {
            if (controlI instanceof Canvas) {
                ComponentUtil.setEnabledButton((Control)controlI, (boolean)enabled);
            } else {
                controlI.setEnabled(enabled);
            }
        });
    }

    protected boolean isOnline() {
        return this.discoveryController.isOnline();
    }

    @Override
    protected boolean canHandleShellCloseEvent() {
        return true;
    }

    @Override
    protected void handleShellCloseEvent() {
        if (this.options.isSimpleMode()) {
            super.handleShellCloseEvent();
            return;
        }
        ActivationCloseConfirmationDialog confirmDialog = new ActivationCloseConfirmationDialog(this.getShell());
        int result = confirmDialog.open();
        if (result == 0) {
            return;
        }
        super.handleShellCloseEvent();
    }

    @Override
    public boolean close() {
        if (!SystemUtils.IS_OS_LINUX) {
            this.getParentShell().close();
            this.realParentShell.forceActive();
        }
        this.eventBroker.unsubscribe(this.onSsoAuthResponseGrabbed);
        return super.close();
    }

    private void saveRememberMeOptionFromCheckboxState() {
        if (this.rememberMeCheckbox == null) {
            return;
        }
        if (this.rememberMeCheckbox.isDisposed()) {
            return;
        }
        RememberMeOption rememberOption = this.rememberMeCheckbox.getSelection() ? RememberMeOption.API_KEY : RememberMeOption.DO_NOT_REMEMBER;
        this.sessionService.setRememberMeOption(rememberOption);
    }

    protected abstract void handleOfflineActivation();

    @Override
    protected abstract void handleSignInWithSSO();

    protected abstract void handleSignInWithLicenseServer();

    protected abstract void handleSSOAuthenticationResponseGrabbed(AuthenticationResponse var1);

    private void discoverEndpoints() {
        new Thread(() -> {
            try {
                UISynchronizeService.syncExec(() -> this.blockUI(true));
                UISynchronizeService.syncExec(() -> this.setMessage(MessageConstants.MSG_CHECKING_SERVER_STATUS));
                if (!this.isOnline()) {
                    UISynchronizeService.syncExec(this::showUnableToConnectMessage);
                } else {
                    this.discoveryController.discover();
                    UISynchronizeService.syncExec(this::clearMessage);
                }
            }
            catch (Throwable throwable) {
                UISynchronizeService.syncExec(() -> this.blockUI(false));
                throw throwable;
            }
            UISynchronizeService.syncExec(() -> this.blockUI(false));
        }).start();
    }

    protected String getUnableToConnectMessage() {
        return MessageFormat.format(MessageConstants.MSG_UNABLE_TO_CONNECT_FORMAT, this.discoveryController.getDiscoveryServerUrl());
    }

    protected void showUnableToConnectMessage() {
        this.setErrorMessage(this.getUnableToConnectMessage());
    }
}

