/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.quickstart;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.FontUtil;
import com.kms.katalon.composer.quickstart.BaseQuickStartDialog;
import com.kms.katalon.composer.quickstart.BrowserSelect;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.tracking.service.Trackings;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class QuickCreateFirstWebUITestCase
extends BaseQuickStartDialog {
    private static final String DEFAULT_URL = "https://www.amazon.com";
    private static final String URL_INPUT_PLACEHOLDER = "E.g: https://www.amazon.com";
    private WebUIDriverType preferredBrowser = WebUIDriverType.CHROME_DRIVER;
    private String preferredSite = "https://www.amazon.com";
    private BrowserSelect browserSelect;
    private String scenario;
    private boolean isScenarioA;

    public QuickCreateFirstWebUITestCase(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected void createContent(Composite container) {
        UserProfile machineProfile = UserProfileHelper.getMachineProfile();
        this.scenario = machineProfile.getNextQuickCreateFirstTestCaseScenario();
        this.isScenarioA = StringUtils.equals((CharSequence)this.scenario, (CharSequence)"A");
        UserProfileHelper.saveProfile((UserProfile)machineProfile);
        Composite body = (Composite)ComponentBuilder.gridContainer((Composite)container).margin(50).gridVerticalSpacing(5).build();
        this.createTitle(body);
        this.createStartRecordComposite(body);
        Trackings.trackQuickStartRecordOpen((String)this.scenario);
    }

    private void createTitle(Composite parent) {
        ComponentBuilder.label((Composite)parent).text("Create your first automated test in a minute with Record").font(FontUtil.size((Font)FontUtil.BOLD, (int)14)).build();
    }

    private void createStartRecordComposite(Composite parent) {
        Composite startRecordComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent).marginTop(30).marginBottom(20).fillHorizontal().gridVerticalSpacing(10).build();
        String urlLabelA = this.isScenarioA ? "Enter your web application URL:" : "Enter your web application URL or try out amazon.com:";
        ComponentBuilder.label((Composite)startRecordComposite).text(urlLabelA).build();
        Composite configComposite = (Composite)ComponentBuilder.gridContainer((Composite)startRecordComposite, (int)3).gridHorizontalSpacing(10).build();
        String urlTextA = this.isScenarioA ? "" : DEFAULT_URL;
        Composite textWrapper = (Composite)ComponentBuilder.gridContainer((Composite)configComposite, (int)1, (int)2048).build();
        ComponentBuilder.text((Composite)textWrapper, (int)4).marginTop(5).marginLeft(5).autoSize(350, 22).text(urlTextA).placeholder(URL_INPUT_PLACEHOLDER).fontSize(10).onChange(event -> {
            Text txtUrl = (Text)event.widget;
            this.preferredSite = txtUrl.getText();
        }).build();
        this.browserSelect = new BrowserSelect(configComposite, 0);
        ComponentBuilder.canvas((Composite)configComposite).text("Start").autoSizeMD(100).primaryButton().onClick(event -> this.okPressed()).build();
        if (this.isScenarioA) {
            ComponentBuilder.label((Composite)startRecordComposite).text(URL_INPUT_PLACEHOLDER).fontStyle(2).fontSize(8).build();
        }
    }

    @Override
    protected String getMainButtonText() {
        return "";
    }

    @Override
    protected String getTipContent() {
        return "You can easily maintain your test scripts after Recording via Object Repository and Dual-script interface";
    }

    @Override
    protected void setInput() {
        super.setInput();
        this.browserSelect.setInput(this.preferredBrowser);
    }

    public WebUIDriverType getPreferredBrowser() {
        return this.browserSelect.getInput();
    }

    public String getPreferredSite() {
        return this.preferredSite;
    }

    protected void okPressed() {
        if (StringUtils.isBlank((CharSequence)this.preferredSite)) {
            return;
        }
        boolean useDefaultBrowser = StringUtils.equals((CharSequence)DEFAULT_URL, (CharSequence)this.getPreferredSite());
        Trackings.trackQuickStartStartRecord((String)this.browserSelect.getInput().name(), (String)this.scenario, (boolean)useDefaultBrowser);
        super.okPressed();
    }

    @Override
    protected boolean isClosable() {
        return false;
    }
}

