/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.helper;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.internal.preferences.InstancePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.util.PrefUtil;

public class DecompilerPreferencesHelper {
    public static final String SF_DECOMPILER_NODE_ID = "org.sf.feeling.decompiler";
    public static final String DECOMPILER_PREFS_DISPLAY_LINE_NUMBERS = "jd.ide.eclipse.prefs.DisplayLineNumbers";
    public static final String DECOMPILER_PREFS_REALIGN_LINE_NUMBERS = "jd.ide.eclipse.prefs.RealignLineNumbers";
    public static final String DECOMPILER_PREFS_IS_INITIALIZED = "jd.ide.eclipse.prefs.IsInitialized";
    public static final String DECOMPILER_PREFS_AUTO_SET_AS_DEFAULT = "org.sf.feeling.decompiler.default_editor";
    public static final String CLASS_FILE_EXTENSION = ".class";
    public static final String CLASS_NO_SOURCE_FILE_EXTENSION = ".class without source";
    public static final String DECOMPILER_EDITOR_ID = "org.sf.feeling.decompiler.ClassFileEditor";
    public static final String JAVA_CLASS_EDITOR_ID = "org.eclipse.jdt.ui.ClassFileEditor";
    public static final String JAVA_CLASS_EDITOR_NO_SOURCE_ID = "org.eclipse.jdt.ui.ClassFileEditorNoSource";
    public static final String KATALON_DECOMPILER_EDITOR_ID = "com.kms.katalon.composer.decompiler.ClassFileEditor";
    private static IEditorDescriptor cachedClassFileEditor;
    private static IEditorDescriptor cachedClassNoSourceFileEditor;

    public static InstancePreferences getPrefs() {
        return (InstancePreferences)InstanceScope.INSTANCE.getNode(SF_DECOMPILER_NODE_ID);
    }

    private static EditorRegistry getRegistry() {
        return (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
    }

    public static void toggleLineNumbers(boolean enable) {
        InstancePreferences decompilerPrefs = DecompilerPreferencesHelper.getPrefs();
        decompilerPrefs.putBoolean(DECOMPILER_PREFS_DISPLAY_LINE_NUMBERS, enable);
        decompilerPrefs.putBoolean(DECOMPILER_PREFS_REALIGN_LINE_NUMBERS, enable);
        decompilerPrefs.putBoolean(DECOMPILER_PREFS_AUTO_SET_AS_DEFAULT, false);
    }

    public static boolean isInitialized() {
        InstancePreferences decompilerPrefs = DecompilerPreferencesHelper.getPrefs();
        return decompilerPrefs.getBoolean(DECOMPILER_PREFS_IS_INITIALIZED, false);
    }

    public static void setInitialized(boolean isInitialized) {
        InstancePreferences decompilerPrefs = DecompilerPreferencesHelper.getPrefs();
        decompilerPrefs.putBoolean(DECOMPILER_PREFS_IS_INITIALIZED, isInitialized);
    }

    public static IEditorDescriptor getCurrentClassEditor() {
        return DecompilerPreferencesHelper.getRegistry().getDefaultEditor(CLASS_FILE_EXTENSION);
    }

    public static IEditorDescriptor getCurrentClassNoSourceEditor() {
        return DecompilerPreferencesHelper.getRegistry().getDefaultEditor(CLASS_NO_SOURCE_FILE_EXTENSION);
    }

    public static void cacheCurrentEditorAssociations() {
        cachedClassFileEditor = DecompilerPreferencesHelper.getCurrentClassEditor();
        cachedClassNoSourceFileEditor = DecompilerPreferencesHelper.getCurrentClassNoSourceEditor();
    }

    public static boolean checkEditorAssociations() {
        boolean hasChanged;
        IEditorDescriptor currentClassEditor = DecompilerPreferencesHelper.getCurrentClassEditor();
        IEditorDescriptor currentClassNoSourceEditor = DecompilerPreferencesHelper.getCurrentClassNoSourceEditor();
        boolean bl = hasChanged = currentClassEditor == null || cachedClassFileEditor == null || currentClassNoSourceEditor == null || cachedClassNoSourceFileEditor == null || !StringUtils.equals((CharSequence)currentClassEditor.getId(), (CharSequence)cachedClassFileEditor.getId()) || !StringUtils.equals((CharSequence)currentClassNoSourceEditor.getId(), (CharSequence)cachedClassNoSourceFileEditor.getId());
        if (hasChanged) {
            DecompilerPreferencesHelper.cacheCurrentEditorAssociations();
        }
        return hasChanged;
    }

    public static boolean isUseDefaultJavaClassEditor() {
        IEditorDescriptor currentEditor = DecompilerPreferencesHelper.getCurrentClassEditor();
        return currentEditor != null && StringUtils.equals((CharSequence)currentEditor.getId(), (CharSequence)JAVA_CLASS_EDITOR_ID);
    }

    public static boolean isUseDefaultJavaClassNoSourceEditor() {
        IEditorDescriptor currentEditor = DecompilerPreferencesHelper.getCurrentClassNoSourceEditor();
        return currentEditor != null && (StringUtils.equals((CharSequence)currentEditor.getId(), (CharSequence)JAVA_CLASS_EDITOR_NO_SOURCE_ID) || StringUtils.equals((CharSequence)currentEditor.getId(), (CharSequence)JAVA_CLASS_EDITOR_ID));
    }

    public static boolean isUseKatalonClassEditor() {
        IEditorDescriptor currentEditor = DecompilerPreferencesHelper.getCurrentClassEditor();
        return currentEditor != null && StringUtils.equals((CharSequence)currentEditor.getId(), (CharSequence)KATALON_DECOMPILER_EDITOR_ID);
    }

    public static boolean isUseKatalonClassNoSourceEditor() {
        IEditorDescriptor currentEditor = DecompilerPreferencesHelper.getCurrentClassNoSourceEditor();
        return currentEditor != null && StringUtils.equals((CharSequence)currentEditor.getId(), (CharSequence)KATALON_DECOMPILER_EDITOR_ID);
    }

    public static boolean isUseDecompilerClassEditor() {
        IEditorDescriptor currentEditor = DecompilerPreferencesHelper.getCurrentClassEditor();
        return currentEditor != null && StringUtils.equals((CharSequence)currentEditor.getId(), (CharSequence)DECOMPILER_EDITOR_ID);
    }

    public static boolean isUseDecompilerClassNoSourceEditor() {
        IEditorDescriptor currentEditor = DecompilerPreferencesHelper.getCurrentClassNoSourceEditor();
        return currentEditor != null && StringUtils.equals((CharSequence)currentEditor.getId(), (CharSequence)DECOMPILER_EDITOR_ID);
    }

    public static void useDefaultJavaEditor() {
        boolean isUseDefaultJavaClassNoSourceEditor;
        EditorRegistry registry = DecompilerPreferencesHelper.getRegistry();
        boolean isUseDefaultJavaClassEditor = DecompilerPreferencesHelper.isUseDefaultJavaClassEditor();
        if (!isUseDefaultJavaClassEditor) {
            registry.setDefaultEditor(CLASS_FILE_EXTENSION, JAVA_CLASS_EDITOR_ID);
        }
        if (!(isUseDefaultJavaClassNoSourceEditor = DecompilerPreferencesHelper.isUseDefaultJavaClassNoSourceEditor())) {
            registry.setDefaultEditor(CLASS_NO_SOURCE_FILE_EXTENSION, JAVA_CLASS_EDITOR_NO_SOURCE_ID);
        }
        if (!isUseDefaultJavaClassEditor || !isUseDefaultJavaClassNoSourceEditor) {
            DecompilerPreferencesHelper.savePrefs();
        }
    }

    public static void useKatalonClassEditor() {
        EditorRegistry registry = DecompilerPreferencesHelper.getRegistry();
        if (!DecompilerPreferencesHelper.isUseKatalonClassEditor()) {
            registry.setDefaultEditor(CLASS_FILE_EXTENSION, KATALON_DECOMPILER_EDITOR_ID);
            DecompilerPreferencesHelper.savePrefs();
        }
    }

    public static void useKatalonClassNoSourceEditor() {
        EditorRegistry registry = DecompilerPreferencesHelper.getRegistry();
        if (!DecompilerPreferencesHelper.isUseKatalonClassNoSourceEditor()) {
            registry.setDefaultEditor(CLASS_NO_SOURCE_FILE_EXTENSION, KATALON_DECOMPILER_EDITOR_ID);
            DecompilerPreferencesHelper.savePrefs();
        }
    }

    public static void savePrefs() {
        EditorRegistry registry = DecompilerPreferencesHelper.getRegistry();
        registry.saveAssociations();
        PrefUtil.savePrefs();
    }

    public static void checkDefaultClassEditor() {
        DecompilerPreferencesHelper.checkDefaultClassEditor(false);
    }

    public static void checkDefaultClassEditor(boolean force) {
        if (force) {
            DecompilerPreferencesHelper.useKatalonClassEditor();
            DecompilerPreferencesHelper.useKatalonClassNoSourceEditor();
            return;
        }
        if (!DecompilerPreferencesHelper.isUseKatalonClassEditor() && !DecompilerPreferencesHelper.isUseDefaultJavaClassEditor()) {
            DecompilerPreferencesHelper.useKatalonClassEditor();
        }
        if (!DecompilerPreferencesHelper.isUseKatalonClassNoSourceEditor() && !DecompilerPreferencesHelper.isUseDefaultJavaClassNoSourceEditor()) {
            DecompilerPreferencesHelper.useKatalonClassNoSourceEditor();
        }
    }
}

