/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.composer.dialog;

import com.equo.chromium.swt.Browser;
import com.katalon.composer.core.webview.browserfunction.BrowserFunctionUtil;
import com.katalon.recorder.web.application.event.IWebViewUpdateEventBus;
import com.katalon.recorder.web.application.event.WebViewUpdateEmptyEvent;
import com.katalon.recorder.web.constant.WebViewInteractionEventType;
import com.katalon.recorder.web.constant.WebViewUpdateEventType;
import com.katalon.recorder.web.domain.manager.IWebRecorderSettingManager;
import com.katalon.recorder.web.domain.model.IWebRecorderSetting;
import com.katalon.recorder.web.presentation.IWebRecorderDialog;
import com.katalon.recorder.web.presentation.IWebRecorderNavigator;
import com.katalon.recorder.web.presentation.event.IWebViewInteractionEventBus;
import com.katalon.recorder.web.presentation.event.RecorderDialogLayoutResizedEvent;
import com.katalon.recorder.web.presentation.event.WebViewInteractionEvent;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.constants.GlobalStringConstants;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class WebRecorderDialog
extends Dialog
implements IWebRecorderDialog {
    private static final Logger logger = LoggerFactory.getLogger(WebRecorderDialog.class);
    private static final int MIN_DIALOG_WIDTH = 480;
    private static final int MAX_DIALOG_WIDTH = 900;
    private static final int MIN_DIALOG_HEIGHT = 300;
    private static final int MAX_DIALOG_HEIGHT = 800;
    private static final int INITIAL_DIALOG_WIDTH = 500;
    private static final int INITIAL_DIALOG_HEIGHT = 360;
    private static final String DIALOG_TITLE = "Web Recorder";
    private static final String DIALOG_CONFIRM_CONTINUE_TESTCASE_RECORDING_TEXT = "Do you want to continue recording test case: ''{0}''?";
    private static final String DIALOG_CONFIRM_CONTINUE_TESTCASE_ACCEPT = "Yes";
    private static final String DIALOG_CONFIRM_CONTINUE_TESTCASE_DECLINE = "No, I want a clean session";
    private String testCaseId;
    private final AtomicReference<Browser> browser;
    private final IWebRecorderNavigator navigator;
    private final CompositeDisposable compositeDisposable;
    private final IWebViewInteractionEventBus webViewInteractionEventBus;
    private final IWebViewUpdateEventBus webViewUpdateEventBus;

    @Inject
    public WebRecorderDialog(Shell shell, IWebRecorderNavigator navigator, IWebViewInteractionEventBus webViewInteractionEventBus, IWebViewUpdateEventBus webViewUpdateEventBus, IWebRecorderSettingManager webRecorderSettingManager) {
        super(shell);
        this.navigator = navigator;
        this.webViewInteractionEventBus = webViewInteractionEventBus;
        this.compositeDisposable = new CompositeDisposable();
        this.browser = new AtomicReference();
        this.webViewUpdateEventBus = webViewUpdateEventBus;
        this.subscribeToWebViewInterationEvents();
        this.subscribeToWebViewUpdateEvents();
        boolean onTop = Optional.ofNullable(webRecorderSettingManager.getWebRecorderSetting()).map(IWebRecorderSetting::getPinRecorderWindow).orElse(false);
        if (onTop && !"linux".equals(Platform.getOS())) {
            this.setShellStyle(this.getShellStyle() | 0x4000 | 0x10 | 0x400 | 0x80);
        } else {
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x400 | 0x80);
        }
    }

    private void subscribeToWebViewUpdateEvents() {
        this.compositeDisposable.add(this.webViewUpdateEventBus.getWebViewUpdateObservableToSubscribe(WebViewUpdateEmptyEvent.class, WebViewUpdateEventType.CLOSE_RECORDER_DIALOG).subscribe(ignore -> {
            boolean bl = this.close();
        }));
    }

    private void subscribeToWebViewInterationEvents() {
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(RecorderDialogLayoutResizedEvent.class).subscribe(event -> {
            logger.debug("Received dialog resize event | event = {}", event);
            UISynchronizeService.asyncExec(() -> this.resizeDialog(event.getWidth(), event.getHeight(), event.getDevicePixelRatio().floatValue()));
        }, error -> logger.error("Error in dialog resize subscription", error)));
        this.compositeDisposable.add(this.webViewInteractionEventBus.getWebViewInteractionObservableToSubscribe(WebViewInteractionEvent.class, WebViewInteractionEventType.CONFIGURATION_CANCEL_RECORDING_CLICKED).subscribe(ignored -> {
            boolean bl = this.close();
        }));
    }

    protected Control createDialogArea(Composite parent) {
        try {
            Composite container;
            if (StringUtils.isNotBlank((CharSequence)this.testCaseId)) {
                String[] split = StringUtils.split((String)this.testCaseId, (char)File.separatorChar);
                MessageDialog dialog = new MessageDialog(this.getParentShell(), GlobalStringConstants.CONFIRMATION, null, MessageFormat.format(DIALOG_CONFIRM_CONTINUE_TESTCASE_RECORDING_TEXT, split[split.length - 1]), 5, 0, new String[]{DIALOG_CONFIRM_CONTINUE_TESTCASE_ACCEPT, DIALOG_CONFIRM_CONTINUE_TESTCASE_DECLINE});
                if (dialog.open() != 0) {
                    this.testCaseId = null;
                }
            }
            if ((container = (Composite)super.createDialogArea(parent)).getLayout() instanceof GridLayout) {
                GridLayout layout = (GridLayout)container.getLayout();
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.marginTop = 0;
                layout.marginBottom = 0;
                layout.marginLeft = 0;
                layout.marginRight = 0;
            }
            this.centerDialog();
            this.browser.set((Browser)ComponentBuilder.browser((Composite)container).defaultBrowserConfig().fill().build());
            BrowserFunctionUtil.bind((Browser)this.browser.get());
            this.initNavigator(this.browser.get());
            return container;
        }
        catch (IOException e) {
            logger.error("IOException when create web recorder dialog", (Throwable)e);
            return null;
        }
    }

    protected Point getInitialSize() {
        return new Point(500, 360);
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    public int open() {
        return super.open();
    }

    public int open(String testCaseId) {
        this.testCaseId = testCaseId;
        return super.open();
    }

    public void initNavigator(Browser browser) throws IOException {
        this.navigator.init(browser, this.testCaseId);
    }

    public boolean close() {
        try {
            try {
                this.navigator.close();
            }
            catch (Exception e) {
                logger.error("Error when close navigator", (Throwable)e);
            }
            this.compositeDisposable.dispose();
            boolean bl = super.close();
            return bl;
        }
        finally {
            logger.info("WebRecorderDialog closed");
        }
    }

    public void resizeDialog(int width, int height, float devicePixelRatio) {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            Monitor monitor = shell.getMonitor();
            Rectangle clientArea = monitor.getClientArea();
            int maxWidth = Math.min(clientArea.width, 900);
            int maxHeight = Math.min(clientArea.height, 800);
            Point currentSize = shell.getSize();
            Rectangle trim = shell.computeTrim(0, 0, width, height);
            boolean isMac = SWT.getPlatform().equals("cocoa");
            float ratio = isMac ? 1.0f : devicePixelRatio;
            int finalWidth = width > 0 ? (int)((float)trim.width * ratio) : currentSize.x;
            int finalHeight = height > 0 ? (int)((float)trim.height * ratio) : currentSize.y;
            finalWidth = Math.min(finalWidth, maxWidth);
            finalHeight = Math.min(finalHeight, maxHeight);
            finalWidth = Math.max(finalWidth, 480);
            finalHeight = Math.max(finalHeight, 300);
            shell.setSize(finalWidth, finalHeight);
            if (isMac) {
                shell.redraw();
                shell.update();
            }
        }
    }

    private void centerDialog() {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            Monitor monitor = shell.getMonitor();
            Rectangle clientArea = monitor.getClientArea();
            Point currentSize = shell.getSize();
            int x = clientArea.x + (clientArea.width - currentSize.x) / 2;
            int y = clientArea.y + (clientArea.height - currentSize.y) / 2;
            shell.setLocation(x, y);
        }
    }
}

