/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.infrastructure;

import com.katalon.recorder.core.constant.KeywordPlatform;
import com.katalon.recorder.core.domain.model.ArrayParameter;
import com.katalon.recorder.core.domain.model.BuiltinKeywordRef;
import com.katalon.recorder.core.domain.model.CustomKeywordRef;
import com.katalon.recorder.core.domain.model.IKeywordDefinition;
import com.katalon.recorder.core.domain.model.IKeywordRef;
import com.katalon.recorder.core.domain.model.IParameter;
import com.katalon.recorder.core.domain.model.KeywordDefinition;
import com.katalon.recorder.core.domain.model.ListParameter;
import com.katalon.recorder.core.domain.model.SingleParameter;
import com.katalon.recorder.core.infrastructure.IKeywordDefinitionProvider;
import com.katalon.recorder.util.ParameterTypeConverter;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.mobile.keyword.MobileBuiltInKeywords;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.webservice.keyword.WSBuiltInKeywords;
import com.kms.katalon.core.webui.keyword.WebUiBuiltInKeywords;
import com.kms.katalon.core.windows.keyword.WindowsBuiltinKeywords;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.custom.keyword.KeywordParameter;
import com.kms.katalon.entity.project.ProjectEntity;
import groovy.lang.GroovyObject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class KeywordDefinitionProvider
implements IKeywordDefinitionProvider {
    private final Logger logger = LoggerFactory.getLogger(KeywordDefinitionProvider.class);
    private final Map<KeywordPlatform, Supplier<List<IKeywordDefinition>>> loaders;
    private final Map<KeywordPlatform, List<IKeywordDefinition>> keywordMap = new EnumMap<KeywordPlatform, List<IKeywordDefinition>>(KeywordPlatform.class);

    public KeywordDefinitionProvider() {
        this.loaders = Map.of(KeywordPlatform.MOBILE, () -> this.parseBuiltinClass(MobileBuiltInKeywords.class), KeywordPlatform.WEB, () -> this.parseBuiltinClass(WebUiBuiltInKeywords.class), KeywordPlatform.API, () -> this.parseBuiltinClass(WSBuiltInKeywords.class), KeywordPlatform.DESKTOP, () -> this.parseBuiltinClass(WindowsBuiltinKeywords.class), KeywordPlatform.CUSTOM, () -> this.getCustomKeywords());
    }

    public List<IKeywordDefinition> getBuiltInKeywordDefinitions() {
        return Stream.of(KeywordPlatform.WEB, KeywordPlatform.MOBILE, KeywordPlatform.API, KeywordPlatform.DESKTOP).flatMap(platform -> this.getKeywordDefinitions((KeywordPlatform)platform).stream()).toList();
    }

    private List<IKeywordDefinition> getCustomKeywords() {
        ArrayList<IKeywordDefinition> keywordDefinitions = new ArrayList<IKeywordDefinition>();
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        List methodNodes = KeywordController.getInstance().getCustomKeywords(projectEntity);
        for (MethodNode methodNode : methodNodes) {
            if (methodNode == null) continue;
            try {
                Parameter[] parameters;
                KeywordDefinition keywordDefinition = new KeywordDefinition();
                CustomKeywordRef customKeywordRef = new CustomKeywordRef();
                customKeywordRef.setPlatform(KeywordPlatform.CUSTOM);
                customKeywordRef.setName(methodNode.getName());
                keywordDefinition.setKeywordRef((IKeywordRef)customKeywordRef);
                Parameter[] parameterArray = parameters = methodNode.getParameters();
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameter kp = parameterArray[n2];
                    ArrayParameter parameter = null;
                    ClassNode classNode = kp.getType();
                    if (classNode.isArray()) {
                        ArrayParameter arrayParam = new ArrayParameter();
                        arrayParam.setName(kp.getName());
                        ClassNode componentClassNode = classNode.getComponentType();
                        arrayParam.setItemType(ParameterTypeConverter.convertClassNameToParameterType(componentClassNode.getNameWithoutPackage()));
                        parameter = arrayParam;
                    } else if (classNode.getName().equals("List")) {
                        ListParameter listParam = new ListParameter();
                        listParam.setName(kp.getName());
                        listParam.setItemType(ParameterTypeConverter.toParameterType(Object.class));
                        parameter = listParam;
                    } else {
                        SingleParameter singleParam = new SingleParameter();
                        singleParam.setName(kp.getName());
                        singleParam.setType(ParameterTypeConverter.convertClassNameToParameterType(classNode.getNameWithoutPackage()));
                        parameter = singleParam;
                    }
                    if (parameter != null) {
                        keywordDefinition.addParameter((IParameter)parameter);
                    }
                    ++n2;
                }
                ClassNode returnType = methodNode.getReturnType();
                customKeywordRef.setReturnType(ParameterTypeConverter.convertClassNameToParameterType(returnType.getNameWithoutPackage()));
                keywordDefinitions.add((IKeywordDefinition)keywordDefinition);
            }
            catch (Exception e) {
                this.logger.warn(String.format("Failed to convert custom keyword: %s. ", methodNode.getName()), (Throwable)e);
            }
        }
        return keywordDefinitions;
    }

    public List<IKeywordDefinition> getKeywordDefinitions(KeywordPlatform platform) {
        return this.keywordMap.computeIfAbsent(platform, p -> {
            Supplier<List<IKeywordDefinition>> loader = this.loaders.get(p);
            if (loader == null) {
                this.logger.warn("No loader found for platform {}", p);
                return Collections.emptyList();
            }
            this.logger.info("Loading keyword definitions for platform {}", p);
            try {
                return Collections.unmodifiableList(loader.get());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return new ArrayList();
            }
        });
    }

    public List<IKeywordDefinition> getCustomKeywordDefinitions() {
        List<IKeywordDefinition> keywordDefinitions = this.getCustomKeywords();
        this.keywordMap.put(KeywordPlatform.CUSTOM, keywordDefinitions);
        return keywordDefinitions;
    }

    public IKeywordDefinition lookup(KeywordPlatform platform, String name) {
        List<IKeywordDefinition> definitions = this.getKeywordDefinitions(platform);
        if (definitions == null || definitions.isEmpty()) {
            return null;
        }
        return this.lookupInList(definitions, name);
    }

    public IKeywordDefinition lookup(KeywordPlatform platform, String name, int argCount) {
        List<IKeywordDefinition> definitions = this.getKeywordDefinitions(platform);
        if (definitions == null || definitions.isEmpty()) {
            return null;
        }
        return this.lookupInList(definitions, name, argCount);
    }

    private IKeywordDefinition lookupInList(List<IKeywordDefinition> keywordDefinitions, String name) {
        return keywordDefinitions.stream().filter(kd -> {
            IKeywordRef ref = kd.getKeywordRef();
            return ref != null && name.equalsIgnoreCase(ref.getName());
        }).findFirst().orElse(null);
    }

    private IKeywordDefinition lookupInList(List<IKeywordDefinition> keywordDefinitions, String name, int argCount) {
        return keywordDefinitions.stream().filter(kd -> {
            IKeywordRef ref = kd.getKeywordRef();
            return ref != null && name.equals(ref.getName()) && kd.getParameters().size() == argCount;
        }).findFirst().orElse(null);
    }

    private List<IKeywordDefinition> parseBuiltinClass(Class<?> clazz) {
        ArrayList<IKeywordDefinition> keywordDefinitions = new ArrayList<IKeywordDefinition>();
        Class<?> current = clazz;
        while (current != null && current != Object.class && current != GroovyObject.class) {
            try {
                String simpleName = current.getSimpleName();
                List keywordMethods = KeywordController.getInstance().getBuiltInKeywords(simpleName);
                if (keywordMethods == null || keywordMethods.isEmpty()) {
                    this.logger.warn("No keyword methods found for class: {}", (Object)simpleName);
                    continue;
                }
                for (KeywordMethod keywordMethod : keywordMethods) {
                    KeywordDefinition keywordDefinition = new KeywordDefinition();
                    BuiltinKeywordRef builtinKeywordRef = new BuiltinKeywordRef();
                    builtinKeywordRef.setName(keywordMethod.getName());
                    if (MobileBuiltInKeywords.class.isAssignableFrom(clazz)) {
                        builtinKeywordRef.setPlatform(KeywordPlatform.MOBILE);
                    } else if (WebUiBuiltInKeywords.class.isAssignableFrom(clazz)) {
                        builtinKeywordRef.setPlatform(KeywordPlatform.WEB);
                    } else if (WSBuiltInKeywords.class.isAssignableFrom(clazz)) {
                        builtinKeywordRef.setPlatform(KeywordPlatform.API);
                    } else if (WindowsBuiltinKeywords.class.isAssignableFrom(clazz)) {
                        builtinKeywordRef.setPlatform(KeywordPlatform.DESKTOP);
                    } else {
                        builtinKeywordRef.setPlatform(KeywordPlatform.CUSTOM);
                    }
                    keywordDefinition.setKeywordRef((IKeywordRef)builtinKeywordRef);
                    KeywordParameter[] keywordParameters = keywordMethod.getParameters();
                    if (keywordParameters != null) {
                        KeywordParameter kp;
                        if (keywordParameters.length == 1 && (kp = keywordParameters[0]).getType() == FailureHandling.class) continue;
                        KeywordParameter[] keywordParameterArray = keywordParameters;
                        int n = keywordParameters.length;
                        int n2 = 0;
                        while (n2 < n) {
                            kp = keywordParameterArray[n2];
                            ArrayParameter parameter = null;
                            Class rawType = kp.getType();
                            if (rawType.isArray()) {
                                ArrayParameter arrayParam = new ArrayParameter();
                                arrayParam.setName(kp.getName());
                                arrayParam.setItemType(ParameterTypeConverter.toParameterType(rawType.getComponentType()));
                                parameter = arrayParam;
                            } else if (List.class.isAssignableFrom(rawType)) {
                                ListParameter listParam = new ListParameter();
                                listParam.setName(kp.getName());
                                listParam.setItemType(ParameterTypeConverter.toParameterType(Object.class));
                                parameter = listParam;
                            } else {
                                SingleParameter singleParam = new SingleParameter();
                                singleParam.setName(kp.getName());
                                singleParam.setType(ParameterTypeConverter.toParameterType(rawType));
                                parameter = singleParam;
                            }
                            if (parameter != null) {
                                keywordDefinition.addParameter((IParameter)parameter);
                            }
                            ++n2;
                        }
                    }
                    Class returnType = keywordMethod.getReturnType();
                    try {
                        builtinKeywordRef.setReturnType(ParameterTypeConverter.toParameterType(returnType));
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.error("Unsupported return type for keyword: {}.{}: {}", new Object[]{simpleName, keywordMethod.getName(), returnType.getName(), e});
                    }
                    keywordDefinitions.add((IKeywordDefinition)keywordDefinition);
                }
            }
            catch (Exception e) {
                this.logger.error("Error while parsing built-in class: {}", (Object)clazz.getSimpleName(), (Object)e);
            }
            current = current.getSuperclass();
        }
        return keywordDefinitions;
    }
}

