/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.util;

import com.katalon.recorder.core.constant.SingleVariableType;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BinaryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BooleanExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.CastExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClassExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstructorCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.DeclarationExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.PropertyExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.RangeExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.VariableExpressionWrapper;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import java.util.HashMap;
import org.apache.commons.lang3.Strings;
import org.openqa.selenium.Keys;

public class VariableTypeProvider {
    private static HashMap<String, IVariableTypeProvider<? extends ASTNodeWrapper>> inputClasses;
    private static final IVariableTypeProvider<ClassNodeWrapper> classNodeValueTypeProvider;
    private static final IVariableTypeProvider<ConstantExpressionWrapper> constantValueTypeProvider;
    private static final IVariableTypeProvider<VariableExpressionWrapper> variableValueTypeProvider;
    private static final IVariableTypeProvider<BinaryExpressionWrapper> binaryValueTypeProvider;
    private static final IVariableTypeProvider<MethodCallExpressionWrapper> methodValueTypeProvider;
    private static final IVariableTypeProvider<BooleanExpressionWrapper> booleanValueTypeProvider;
    private static final IVariableTypeProvider<ClosureExpressionWrapper> closureValueTypeProvider;
    private static final IVariableTypeProvider<ClosureListExpressionWrapper> closureListValueTypeProvider;
    private static final IVariableTypeProvider<RangeExpressionWrapper> rangeValueTypeProvider;
    private static final IVariableTypeProvider<PropertyExpressionWrapper> propertyValueTypeProvider;
    private static final IVariableTypeProvider<ClassExpressionWrapper> classValueTypeProvider;
    private static final IVariableTypeProvider<ConstructorCallExpressionWrapper> constructorCallValueTypeProvider;
    private static final IVariableTypeProvider<CastExpressionWrapper> castExpressionValueTypeProvider;

    static {
        classNodeValueTypeProvider = new IVariableTypeProvider<ClassNodeWrapper>(){

            @Override
            public SingleVariableType getVariableType(ClassNodeWrapper classNode) {
                return SingleVariableType.CLASS;
            }
        };
        constantValueTypeProvider = new IVariableTypeProvider<ConstantExpressionWrapper>(){

            @Override
            public SingleVariableType getVariableType(ConstantExpressionWrapper constantExpression) {
                if (constantExpression.isFalseExpression() || constantExpression.isTrueExpression()) {
                    return SingleVariableType.BOOLEAN;
                }
                if (constantExpression.isNumberExpression()) {
                    return SingleVariableType.NUMBER;
                }
                if (constantExpression.isNullExpression()) {
                    return SingleVariableType.NULL;
                }
                return SingleVariableType.STRING;
            }
        };
        variableValueTypeProvider = new IVariableTypeProvider<VariableExpressionWrapper>(){

            @Override
            public SingleVariableType getVariableType(VariableExpressionWrapper variableExpression) {
                if (variableExpression.getText().equals("this")) {
                    return SingleVariableType.THIS;
                }
                Class type = AstKeywordsInputUtil.loadType((String)variableExpression.getText(), (ClassNodeWrapper)variableExpression.getScriptClass());
                if (type != null) {
                    return SingleVariableType.CLASS;
                }
                return SingleVariableType.VARIABLE;
            }
        };
        binaryValueTypeProvider = new IVariableTypeProvider<BinaryExpressionWrapper>(){

            @Override
            public SingleVariableType getVariableType(BinaryExpressionWrapper variableExpression) {
                return SingleVariableType.BINARY;
            }
        };
        methodValueTypeProvider = new IVariableTypeProvider<MethodCallExpressionWrapper>(){

            @Override
            public SingleVariableType getVariableType(MethodCallExpressionWrapper methodCallExpression) {
                if (methodCallExpression.isFindTestCaseMethodCall()) {
                    return SingleVariableType.TEST_CASE;
                }
                if (methodCallExpression.isFindTestObjectMethodCall()) {
                    return SingleVariableType.TEST_OBJECT;
                }
                if (methodCallExpression.isFindWindowsObjectMethodCall()) {
                    return SingleVariableType.WINDOWS_OBJECT;
                }
                if (methodCallExpression.isFindTestDataMethodCall()) {
                    return SingleVariableType.TEST_DATA;
                }
                if (methodCallExpression.isGetTestDataValueMethodCall()) {
                    return SingleVariableType.TEST_DATA_VALUE;
                }
                if (methodCallExpression.isKeysArgumentExpression()) {
                    return SingleVariableType.KEYS;
                }
                return SingleVariableType.METHOD_CALL;
            }
        };
        booleanValueTypeProvider = new IVariableTypeProvider<BooleanExpressionWrapper>(){

            @Override
            public SingleVariableType getVariableType(BooleanExpressionWrapper booleanExpression) {
                return SingleVariableType.CONDITION;
            }
        };
        closureValueTypeProvider = new IVariableTypeProvider<ClosureExpressionWrapper>(){

            @Override
            public SingleVariableType getVariableType(ClosureExpressionWrapper closureExpression) {
                return SingleVariableType.CLOSURE;
            }
        };
        closureListValueTypeProvider = new IVariableTypeProvider<ClosureListExpressionWrapper>(){

            @Override
            public SingleVariableType getVariableType(ClosureListExpressionWrapper closureListExpression) {
                return SingleVariableType.CLOSURE_LIST;
            }
        };
        rangeValueTypeProvider = new IVariableTypeProvider<RangeExpressionWrapper>(){

            @Override
            public SingleVariableType getVariableType(RangeExpressionWrapper rangeExpression) {
                return SingleVariableType.RANGE;
            }
        };
        propertyValueTypeProvider = new IVariableTypeProvider<PropertyExpressionWrapper>(){

            @Override
            public SingleVariableType getVariableType(PropertyExpressionWrapper propertyExpression) {
                if (Strings.CS.equals(propertyExpression.getObjectExpressionAsString(), "GlobalVariable")) {
                    return SingleVariableType.GLOBAL_VARIABLE;
                }
                if (propertyExpression.isObjectExpressionOfClass(Keys.class)) {
                    return SingleVariableType.KEY;
                }
                Class type = AstKeywordsInputUtil.loadType((String)propertyExpression.getText(), (ClassNodeWrapper)propertyExpression.getScriptClass());
                if (type != null) {
                    return SingleVariableType.CLASS;
                }
                return SingleVariableType.PROPERTY;
            }
        };
        classValueTypeProvider = new IVariableTypeProvider<ClassExpressionWrapper>(){

            @Override
            public SingleVariableType getVariableType(ClassExpressionWrapper classExpression) {
                return SingleVariableType.CLASS;
            }
        };
        constructorCallValueTypeProvider = new IVariableTypeProvider<ConstructorCallExpressionWrapper>(){

            @Override
            public SingleVariableType getVariableType(ConstructorCallExpressionWrapper constructorCallExpression) {
                Class throwableClass = AstKeywordsInputUtil.loadType((String)constructorCallExpression.getType().getName(), (ClassNodeWrapper)constructorCallExpression.getScriptClass());
                if (throwableClass != null && Throwable.class.isAssignableFrom(throwableClass)) {
                    return SingleVariableType.THROWABLE;
                }
                return SingleVariableType.NULL;
            }
        };
        castExpressionValueTypeProvider = new IVariableTypeProvider<CastExpressionWrapper>(){

            @Override
            public SingleVariableType getVariableType(CastExpressionWrapper castExpression) {
                if (castExpression.getExpression() instanceof ListExpressionWrapper) {
                    return null;
                }
                return SingleVariableType.NULL;
            }
        };
        inputClasses = new HashMap();
        inputClasses.put(ClassNodeWrapper.class.getSimpleName(), classNodeValueTypeProvider);
        inputClasses.put(ConstantExpressionWrapper.class.getSimpleName(), constantValueTypeProvider);
        inputClasses.put(VariableExpressionWrapper.class.getSimpleName(), variableValueTypeProvider);
        inputClasses.put(BinaryExpressionWrapper.class.getSimpleName(), binaryValueTypeProvider);
        inputClasses.put(MethodCallExpressionWrapper.class.getSimpleName(), methodValueTypeProvider);
        inputClasses.put(BooleanExpressionWrapper.class.getSimpleName(), booleanValueTypeProvider);
        inputClasses.put(ClosureExpressionWrapper.class.getSimpleName(), closureValueTypeProvider);
        inputClasses.put(ClosureListExpressionWrapper.class.getSimpleName(), closureListValueTypeProvider);
        inputClasses.put(RangeExpressionWrapper.class.getSimpleName(), rangeValueTypeProvider);
        inputClasses.put(PropertyExpressionWrapper.class.getSimpleName(), propertyValueTypeProvider);
        inputClasses.put(ClassExpressionWrapper.class.getSimpleName(), classValueTypeProvider);
        inputClasses.put(ConstructorCallExpressionWrapper.class.getSimpleName(), constructorCallValueTypeProvider);
        inputClasses.put(DeclarationExpressionWrapper.class.getSimpleName(), binaryValueTypeProvider);
        inputClasses.put(CastExpressionWrapper.class.getSimpleName(), castExpressionValueTypeProvider);
    }

    public static <T extends ASTNodeWrapper> SingleVariableType getVariableTypeForASTNode(T astNode) {
        IVariableTypeProvider<? extends ASTNodeWrapper> provider = inputClasses.get(astNode.getClass().getSimpleName());
        if (provider != null) {
            return provider.getVariableType(astNode);
        }
        return null;
    }

    static interface IVariableTypeProvider<T extends ASTNodeWrapper> {
        public SingleVariableType getVariableType(T var1);
    }
}

