/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.SpeechGenerationResponseFormat;
import com.azure.ai.openai.models.SpeechVoice;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SpeechGenerationOptions
implements JsonSerializable<SpeechGenerationOptions> {
    private final String input;
    private final SpeechVoice voice;
    private SpeechGenerationResponseFormat responseFormat;
    private Double speed;
    private String model;

    public SpeechGenerationOptions(String input, SpeechVoice voice) {
        this.input = input;
        this.voice = voice;
    }

    public String getInput() {
        return this.input;
    }

    public SpeechVoice getVoice() {
        return this.voice;
    }

    public SpeechGenerationResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public SpeechGenerationOptions setResponseFormat(SpeechGenerationResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public SpeechGenerationOptions setSpeed(Double speed) {
        this.speed = speed;
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public SpeechGenerationOptions setModel(String model) {
        this.model = model;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("input", this.input);
        jsonWriter.writeStringField("voice", this.voice == null ? null : this.voice.toString());
        jsonWriter.writeStringField("response_format", this.responseFormat == null ? null : this.responseFormat.toString());
        jsonWriter.writeNumberField("speed", (Number)this.speed);
        jsonWriter.writeStringField("model", this.model);
        return jsonWriter.writeEndObject();
    }

    public static SpeechGenerationOptions fromJson(JsonReader jsonReader) throws IOException {
        return (SpeechGenerationOptions)jsonReader.readObject(reader -> {
            String input = null;
            SpeechVoice voice = null;
            SpeechGenerationResponseFormat responseFormat = null;
            Double speed = null;
            String model = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("input".equals(fieldName)) {
                    input = reader.getString();
                    continue;
                }
                if ("voice".equals(fieldName)) {
                    voice = SpeechVoice.fromString(reader.getString());
                    continue;
                }
                if ("response_format".equals(fieldName)) {
                    responseFormat = SpeechGenerationResponseFormat.fromString(reader.getString());
                    continue;
                }
                if ("speed".equals(fieldName)) {
                    speed = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            SpeechGenerationOptions deserializedSpeechGenerationOptions = new SpeechGenerationOptions(input, voice);
            deserializedSpeechGenerationOptions.responseFormat = responseFormat;
            deserializedSpeechGenerationOptions.speed = speed;
            deserializedSpeechGenerationOptions.model = model;
            return deserializedSpeechGenerationOptions;
        });
    }
}

