/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.ReportCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.handlers.deletion.IDeleteEntityHandler;
import com.kms.katalon.composer.report.constants.StringConstants;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import jakarta.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;

public class DeleteReportCollectionHandler
implements IDeleteEntityHandler {
    @Inject
    private UISynchronize sync;
    @Inject
    private IEventBroker eventBroker;

    public Class<? extends ITreeEntity> entityType() {
        return ReportCollectionTreeEntity.class;
    }

    public boolean execute(ITreeEntity treeEntity, IProgressMonitor monitor) {
        try {
            if (!(treeEntity instanceof ReportCollectionTreeEntity)) {
                return false;
            }
            String taskName = "Deleting " + treeEntity.getTypeName() + " '" + treeEntity.getText() + "'...";
            monitor.beginTask(taskName, 1);
            ReportCollectionEntity reportCollection = (ReportCollectionEntity)treeEntity.getObject();
            if (reportCollection == null) {
                return false;
            }
            EntityPartUtil.closePart((IEntity)reportCollection);
            String reportId = reportCollection.getId();
            ReportController.getInstance().deleteReportCollection(reportCollection);
            this.eventBroker.send("REPORT/DELETED", (Object)reportId);
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            this.sync.syncExec(new Runnable(){

                @Override
                public void run() {
                    MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_DELETE_REPORT, (String)e.getMessage());
                }
            });
            return false;
        }
        finally {
            monitor.done();
        }
    }
}

