/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.menu;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestOpsFolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestOpsTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.menu.MenuFactory;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.constants.helper.ConstantsHelper;
import com.kms.katalon.entity.folder.FolderEntity;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;

public class EmptyPopupMenuContribution {
    @Inject
    private ECommandService commandService;
    @Inject
    private ESelectionService selectionService;

    @Inject
    public void init() {
        this.selectionService.addSelectionListener(new ISelectionListener(){

            public void selectionChanged(MPart part, Object selection) {
                if (part.getElementId().equals("com.kms.katalon.composer.part.explorer")) {
                    EmptyPopupMenuContribution.this.selectionService.setSelection(null);
                    EmptyPopupMenuContribution.this.selectionService.setSelection(selection);
                }
            }
        });
    }

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        try {
            MHandledMenuItem newFolderPopupMenuItem;
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            if (this.canExecute(selectedObjects) && (newFolderPopupMenuItem = MenuFactory.createPopupMenuItem((ParameterizedCommand)this.commandService.createCommand("com.kms.katalon.composer.report.command.empty", null), (String)"(empty)", (String)ConstantsHelper.getApplicationURI())) != null) {
                menuItems.add((MMenuElement)newFolderPopupMenuItem);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private boolean canExecute(Object[] selectedObjects) throws Exception {
        if (selectedObjects != null && selectedObjects.length > 0 && selectedObjects[0] instanceof ITreeEntity) {
            ITreeEntity parentTreeEntity = (ITreeEntity)selectedObjects[0];
            if (parentTreeEntity instanceof FolderTreeEntity) {
                FolderEntity parentFolder = (FolderEntity)parentTreeEntity.getObject();
                if (parentFolder.getFolderType() == FolderEntity.FolderType.REPORT) {
                    return true;
                }
            } else {
                return parentTreeEntity instanceof ReportTreeEntity || parentTreeEntity instanceof TestOpsFolderTreeEntity || parentTreeEntity instanceof TestOpsTreeEntity;
            }
        }
        return false;
    }
}

