/*
 * Decompiled with CFR 0.152.
 */
package atu.testrecorder.media.avi;

import atu.testrecorder.media.Buffer;
import atu.testrecorder.media.Codec;
import atu.testrecorder.media.VideoFormat;
import atu.testrecorder.media.avi.DataChunkOutputStream;
import atu.testrecorder.media.io.ImageOutputStreamAdapter;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.imageio.stream.ImageOutputStream;

public abstract class AbstractAVIStream {
    protected ImageOutputStream out;
    protected long streamOffset;
    protected ArrayList<Track> tracks = new ArrayList();

    protected long getRelativeStreamPosition() throws IOException {
        return this.out.getStreamPosition() - this.streamOffset;
    }

    protected void seekRelative(long newPosition) throws IOException {
        this.out.seek(newPosition + this.streamOffset);
    }

    protected abstract class Chunk {
        protected String chunkType;
        protected long offset;

        public Chunk(String chunkType) throws IOException {
            this.chunkType = chunkType;
            this.offset = AbstractAVIStream.this.getRelativeStreamPosition();
        }

        public abstract void finish() throws IOException;

        public abstract long size();
    }

    protected class CompositeChunk
    extends Chunk {
        protected String compositeType;
        protected LinkedList<Chunk> children;
        protected boolean finished;

        public CompositeChunk(String compositeType, String chunkType) throws IOException {
            super(chunkType);
            this.compositeType = compositeType;
            AbstractAVIStream.this.out.writeLong(0L);
            AbstractAVIStream.this.out.writeInt(0);
            this.children = new LinkedList();
        }

        public void add(Chunk child) throws IOException {
            if (this.children.size() > 0) {
                this.children.getLast().finish();
            }
            this.children.add(child);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("CompositeChunk \"" + this.chunkType + "\" is too large: " + this.size());
                }
                long pointer = AbstractAVIStream.this.getRelativeStreamPosition();
                AbstractAVIStream.this.seekRelative(this.offset);
                DataChunkOutputStream headerData = new DataChunkOutputStream(new ImageOutputStreamAdapter(AbstractAVIStream.this.out), false);
                headerData.writeType(this.compositeType);
                headerData.writeUInt(this.size() - 8L);
                headerData.writeType(this.chunkType);
                for (Chunk child : this.children) {
                    child.finish();
                }
                AbstractAVIStream.this.seekRelative(pointer);
                if (this.size() % 2L == 1L) {
                    AbstractAVIStream.this.out.writeByte(0);
                }
                this.finished = true;
            }
        }

        @Override
        public long size() {
            long length = 12L;
            for (Chunk child : this.children) {
                length += child.size() + child.size() % 2L;
            }
            return length;
        }
    }

    protected class DataChunk
    extends Chunk {
        protected DataChunkOutputStream data;
        protected boolean finished;

        public DataChunk(String name) throws IOException {
            super(name);
            AbstractAVIStream.this.out.writeLong(0L);
            this.data = new DataChunkOutputStream(new ImageOutputStreamAdapter(AbstractAVIStream.this.out), false);
        }

        public DataChunkOutputStream getOutputStream() {
            if (this.finished) {
                throw new IllegalStateException("DataChunk is finished");
            }
            return this.data;
        }

        public long getOffset() {
            return this.offset;
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                long sizeBefore = this.size();
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("DataChunk \"" + this.chunkType + "\" is too large: " + this.size());
                }
                long pointer = AbstractAVIStream.this.getRelativeStreamPosition();
                AbstractAVIStream.this.seekRelative(this.offset);
                DataChunkOutputStream headerData = new DataChunkOutputStream(new ImageOutputStreamAdapter(AbstractAVIStream.this.out), false);
                headerData.writeType(this.chunkType);
                headerData.writeUInt(this.size() - 8L);
                AbstractAVIStream.this.seekRelative(pointer);
                if (this.size() % 2L == 1L) {
                    AbstractAVIStream.this.out.writeByte(0);
                }
                this.finished = true;
                long sizeAfter = this.size();
                if (sizeBefore != sizeAfter) {
                    System.err.println("size mismatch " + sizeBefore + ".." + sizeAfter);
                }
            }
        }

        @Override
        public long size() {
            return 8L + this.data.size();
        }
    }

    protected class FixedSizeDataChunk
    extends Chunk {
        protected DataChunkOutputStream data;
        protected boolean finished;
        protected long fixedSize;

        public FixedSizeDataChunk(String chunkType, long fixedSize) throws IOException {
            super(chunkType);
            this.fixedSize = fixedSize;
            this.data = new DataChunkOutputStream(new ImageOutputStreamAdapter(AbstractAVIStream.this.out), false);
            this.data.writeType(chunkType);
            this.data.writeUInt(fixedSize);
            this.data.clearCount();
            byte[] buf = new byte[(int)Math.min(512L, fixedSize)];
            long written = 0L;
            while (written < fixedSize) {
                this.data.write(buf, 0, (int)Math.min((long)buf.length, fixedSize - written));
                written += Math.min((long)buf.length, fixedSize - written);
            }
            if (fixedSize % 2L == 1L) {
                AbstractAVIStream.this.out.writeByte(0);
            }
            this.seekToStartOfData();
        }

        public DataChunkOutputStream getOutputStream() {
            return this.data;
        }

        public long getOffset() {
            return this.offset;
        }

        public void seekToStartOfData() throws IOException {
            AbstractAVIStream.this.seekRelative(this.offset + 8L);
            this.data.clearCount();
        }

        public void seekToEndOfChunk() throws IOException {
            AbstractAVIStream.this.seekRelative(this.offset + 8L + this.fixedSize + this.fixedSize % 2L);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                this.finished = true;
            }
        }

        @Override
        public long size() {
            return 8L + this.fixedSize;
        }
    }

    protected static enum MediaType {
        AUDIO("auds"),
        MIDI("mids"),
        TEXT("txts"),
        VIDEO("vids");

        protected String fccType;

        private MediaType(String fourCC) {
            this.fccType = fourCC;
        }
    }

    protected static class Sample {
        String chunkType;
        long offset;
        long length;
        int duration;
        boolean isSync;

        public Sample(String chunkId, int duration, long offset, long length, boolean isSync) {
            this.chunkType = chunkId;
            this.duration = duration;
            this.offset = offset;
            this.length = length;
            this.isSync = isSync;
        }
    }

    protected abstract class Track {
        final MediaType mediaType;
        protected long timeScale = 1L;
        protected long frameRate = 30L;
        protected LinkedList<Sample> samples;
        protected int syncInterval = 30;
        protected String twoCC;
        protected String fourCC;
        FixedSizeDataChunk strhChunk;
        FixedSizeDataChunk strfChunk;

        public Track(int trackIndex, MediaType mediaType, String fourCC) {
            this.mediaType = mediaType;
            this.twoCC = "00" + Integer.toString(trackIndex);
            this.twoCC = this.twoCC.substring(this.twoCC.length() - 2);
            this.fourCC = fourCC;
        }
    }

    protected class VideoTrack
    extends Track {
        protected VideoFormat videoFormat;
        protected float videoQuality;
        protected IndexColorModel palette;
        protected IndexColorModel previousPalette;
        protected Object previousData;
        protected Codec codec;
        protected Buffer outputBuffer;
        protected Rectangle rcFrame;

        public VideoTrack(int trackIndex, String fourCC) {
            super(trackIndex, MediaType.VIDEO, fourCC);
            this.videoQuality = 0.97f;
        }
    }
}

