/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.mobile.application;

import com.katalon.mobile.core.enums.MobileDevicePlatform;
import com.katalon.mobile.core.enums.MobileProvider;
import com.katalon.mobile.core.interfaces.IMobileDevice;
import com.katalon.recorder.core.domain.model.IKeywordDefinition;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.infrastructure.IKeywordDefinitionProvider;
import com.katalon.recorder.mobile.core.application.IMobileRecorderController;
import com.katalon.recorder.mobile.core.domain.IMobileRecorderManager;
import com.katalon.recorder.mobile.core.interfaces.IMobileActionRequest;
import com.katalon.recorder.mobile.core.interfaces.IMobileActionResult;
import com.katalon.recorder.mobile.core.interfaces.IMobileStartRecordingRequest;
import com.katalon.recorder.mobile.core.interfaces.IMobileStartRecordingResponse;
import com.katalon.recorder.mobile.core.models.MobileDeviceScreenInfo;
import com.katalon.recorder.mobile.core.models.MobileStartCustomRecordingRequest;
import com.katalon.recorder.mobile.core.models.MobileStartLocalRecordingRequest;
import com.katalon.recorder.mobile.core.models.MobileStartRemoteRecordingRequest;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class MobileRecorderController
implements IMobileRecorderController {
    private Logger logger = LoggerFactory.getLogger(MobileRecorderController.class);
    @Inject
    IMobileRecorderManager manager;
    @Inject
    IKeywordDefinitionProvider keywordDefinitionProvider;

    public CompletableFuture<String> captureDevicePageSourceAsync() {
        return this.manager.captureDevicePageSourceAsync();
    }

    public CompletableFuture<MobileDeviceScreenInfo> captureDeviceScreenInfoAsync() {
        return this.manager.captureDeviceScreenInfoAsync();
    }

    public CompletableFuture<String> captureDeviceScreenshotAsync() {
        return this.manager.captureDeviceScreenshotAsync();
    }

    public CompletableFuture<Void> cleanupAsync() {
        return this.manager.cleanupAsync();
    }

    public CompletableFuture<IMobileActionResult> executeActionAsync(IMobileActionRequest request) {
        return this.manager.executeActionAsync(request);
    }

    public CompletableFuture<List<String>> getApplicationContextsAsync() {
        return this.manager.getApplicationContextsAsync();
    }

    public CompletableFuture<List<IMobileDevice>> getDevicesAsync(MobileProvider provider, MobileDevicePlatform platform) {
        return this.manager.getDevicesAsync(provider, platform);
    }

    public CompletableFuture<List<IKeywordDefinition>> getMobileKeywordDefinitionsAsync() {
        return this.manager.getMobileKeywordDefinitionsAsync();
    }

    public CompletableFuture<List<MobileProvider>> getSupportedProvidersAsync() {
        return this.manager.getSupportedProvidersAsync();
    }

    public void openCustomCapabilitySetting() {
        this.manager.openCustomCapabilitySetting();
    }

    public void openRemoteCapabilitySetting() {
        this.manager.openRemoteCapabilitySetting();
    }

    public CompletableFuture<IMobileStartRecordingResponse> startRecordingAsync(IMobileStartRecordingRequest request) {
        if (request instanceof MobileStartLocalRecordingRequest) {
            MobileStartLocalRecordingRequest localRequest = (MobileStartLocalRecordingRequest)request;
            return this.manager.startLocalRecordingAsync(localRequest.getDevicePlatform(), localRequest.getDeviceId(), localRequest.getApplicationPath(), localRequest.getApplicationId());
        }
        if (request instanceof MobileStartRemoteRecordingRequest) {
            MobileStartRemoteRecordingRequest remoteRequest = (MobileStartRemoteRecordingRequest)request;
            return this.manager.startRemoteRecordingAsync(remoteRequest.getApplicationPath(), remoteRequest.getApplicationId());
        }
        if (request instanceof MobileStartCustomRecordingRequest) {
            MobileStartCustomRecordingRequest customRequest = (MobileStartCustomRecordingRequest)request;
            return this.manager.startCustomRecordingAsync(customRequest.getProfileName(), customRequest.getApplicationPath(), customRequest.getApplicationId());
        }
        return null;
    }

    public CompletableFuture<IStep> stopRecordingAsync() {
        return this.manager.stopRecordingAsync();
    }

    public CompletableFuture<Void> validateApplicationId(MobileProvider provider, MobileDevicePlatform platform, String id) {
        return this.manager.validateApplicationId(provider, platform, id);
    }

    public CompletableFuture<Void> validateApplicationPath(MobileProvider provider, MobileDevicePlatform platform, String path) {
        return this.manager.validateApplicationPath(provider, platform, path);
    }

    public CompletableFuture<Void> validateScreenshotFilePath(String filePath) {
        return this.manager.validateScreenshotFilePath(filePath);
    }
}

