/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.mobile.infrastructure;

import com.katalon.recorder.core.domain.exception.DriverServiceException;
import com.katalon.recorder.mobile.core.infrastructure.IMobileDriverService;
import com.kms.katalon.core.appium.driver.AppiumDriverManager;
import com.kms.katalon.core.appium.exception.MobileDriverInitializeException;
import com.kms.katalon.core.driver.IDriverType;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;

public class MobileDriverService
implements IMobileDriverService {
    public WebDriver createDriver(Capabilities capabilities) throws DriverServiceException {
        String appiumServerUrl = AppiumDriverManager.getAppiumServerUrl();
        return this.createDriver(capabilities, appiumServerUrl);
    }

    public WebDriver createDriver(Capabilities capabilities, String serverUrl) throws DriverServiceException {
        Platform platformName = capabilities.getPlatformName();
        MobileDriverType mobileDriverType = null;
        if (Platform.ANDROID.equals((Object)platformName)) {
            mobileDriverType = MobileDriverType.ANDROID_DRIVER;
        } else if (Platform.IOS.equals((Object)platformName)) {
            mobileDriverType = MobileDriverType.IOS_DRIVER;
        }
        try {
            return AppiumDriverManager.createMobileDriver((IDriverType)mobileDriverType, (MutableCapabilities)((MutableCapabilities)capabilities), (URL)new URL(serverUrl));
        }
        catch (MobileDriverInitializeException | MalformedURLException e) {
            throw new DriverServiceException(e);
        }
    }
}

