/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.mobile.utils;

import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.core.domain.model.ICapturedObject;
import com.katalon.recorder.core.domain.model.ICapturedObjectAttribute;
import com.katalon.recorder.mobile.core.models.IMobileCapturedObject;
import com.katalon.recorder.mobile.utils.ConditionTypeConverter;
import com.katalon.recorder.mobile.utils.LocatorStrategyConverter;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.testobject.TestObjectXpath;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CapturedObjectConverter {
    public static MobileTestObject toMobileTestObject(ICapturedObject capturedObject) {
        if (capturedObject == null) {
            throw new IllegalArgumentException("capturedObject cannot be null");
        }
        MobileTestObject mobileTestObject = new MobileTestObject(capturedObject.getName());
        mobileTestObject.setPlatform(MobilePlatform.valueOf((String)((IMobileCapturedObject)capturedObject).getDevicePlatform().toString()));
        mobileTestObject.setLocatorStrategy(LocatorStrategyConverter.toStrategy(capturedObject.getLocatorType()));
        Map locatorCollection = capturedObject.getLocators();
        for (Map.Entry entry : locatorCollection.entrySet()) {
            LocatorStrategy strategy = LocatorStrategyConverter.toStrategy((LocatorType)entry.getKey());
            if (strategy == null) continue;
            mobileTestObject.setLocatorValue(strategy, (String)entry.getValue());
        }
        List props = capturedObject.getAttributes().stream().map(p -> new TestObjectProperty(p.getName(), ConditionTypeConverter.toConditionType(p.getOperator()), p.getValue(), p.getEnabled())).collect(Collectors.toList());
        mobileTestObject.setProperties(props);
        List xpaths = capturedObject.getXPaths().stream().map(ro -> new TestObjectXpath(ro.getName(), ConditionType.EQUALS, ro.getValue(), Boolean.TRUE.equals(ro.getEnabled()))).collect(Collectors.toList());
        mobileTestObject.setXpaths(xpaths);
        return mobileTestObject;
    }

    public static MobileElementEntity toMobileElementEntity(ICapturedObject capturedObject) {
        if (capturedObject == null) {
            throw new IllegalArgumentException("capturedObject cannot be null");
        }
        MobileElementEntity entity = new MobileElementEntity();
        entity.setId(capturedObject.getId());
        entity.setName(capturedObject.getName());
        entity.setPlatform(MobilePlatform.valueOf((String)((IMobileCapturedObject)capturedObject).getDevicePlatform().toString()));
        entity.setLocatorStrategy(LocatorStrategy.valueOf((String)capturedObject.getLocatorType().toString()));
        HashMap<LocatorStrategy, String> locatorCollection = new HashMap<LocatorStrategy, String>();
        for (Map.Entry entry : capturedObject.getLocators().entrySet()) {
            LocatorStrategy strategy = LocatorStrategy.valueOf((String)entry.getKey().toString());
            locatorCollection.put(strategy, (String)entry.getValue());
        }
        entity.setLocatorCollection(locatorCollection);
        List props = capturedObject.getAttributes().stream().map(p -> new WebElementPropertyEntity(p.getName(), p.getValue(), p.getEnabled())).collect(Collectors.toList());
        entity.setWebElementProperties(props);
        List xpath = capturedObject.getXPaths().stream().map(ro -> {
            WebElementXpathEntity xpathEntity = new WebElementXpathEntity();
            xpathEntity.setName(ro.getName());
            xpathEntity.setValue(ro.getValue());
            xpathEntity.setIsSelected(Boolean.TRUE.equals(ro.getEnabled()));
            xpathEntity.setMatchCondition("equals");
            return xpathEntity;
        }).collect(Collectors.toList());
        entity.setWebElementXpaths(xpath);
        return entity;
    }

    public static CapturedMobileElement toCapturedMobileElement(ICapturedObject capturedObject) {
        if (capturedObject == null) {
            throw new IllegalArgumentException("capturedObject cannot be null");
        }
        CapturedMobileElement mobileElement = new CapturedMobileElement();
        mobileElement.setScriptId(capturedObject.getId());
        mobileElement.setName(capturedObject.getName());
        mobileElement.setPlatform(MobilePlatform.valueOf((String)((IMobileCapturedObject)capturedObject).getDevicePlatform().toString()));
        mobileElement.setLocatorStrategy(LocatorStrategy.valueOf((String)capturedObject.getLocatorType().toString()));
        HashMap<LocatorStrategy, String> locatorCollection = new HashMap<LocatorStrategy, String>();
        for (Map.Entry entry : capturedObject.getLocators().entrySet()) {
            LocatorStrategy strategy = LocatorStrategy.valueOf((String)entry.getKey().toString());
            locatorCollection.put(strategy, (String)entry.getValue());
        }
        mobileElement.setLocatorCollection(locatorCollection);
        Map<String, String> attributes = capturedObject.getAttributes().stream().collect(Collectors.toMap(ICapturedObjectAttribute::getName, ICapturedObjectAttribute::getValue));
        mobileElement.setAttributes(attributes);
        return mobileElement;
    }
}

