/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.eclipse.codeassist.creators.CategoryProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.creators.FieldProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.creators.IProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.creators.MethodProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.processors.IGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MemberProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public abstract class AbstractGroovyCompletionProcessor
implements IGroovyCompletionProcessor {
    private final ContentAssistContext context;
    private final SearchableEnvironment nameEnvironment;
    private final JavaContentAssistInvocationContext javaContext;

    public AbstractGroovyCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        this.context = context;
        this.javaContext = javaContext;
        this.nameEnvironment = nameEnvironment;
    }

    public final ContentAssistContext getContext() {
        return this.context;
    }

    public final SearchableEnvironment getNameEnvironment() {
        return this.nameEnvironment;
    }

    public final JavaContentAssistInvocationContext getJavaContext() {
        return this.javaContext;
    }

    protected IProposalCreator[] getProposalCreators() {
        return new IProposalCreator[]{new FieldProposalCreator(), new MethodProposalCreator(), new CategoryProposalCreator()};
    }

    protected int getReplacementStartOffset() {
        int replacementStart;
        switch (this.context.location) {
            case ANNOTATION: 
            case CONSTRUCTOR: {
                replacementStart = this.context.completionNode.getStart();
                if (!(this.context.completionNode instanceof ClassNode) || ((ClassNode)this.context.completionNode).getNameEnd() <= 0) break;
                replacementStart = ((ClassNode)this.context.completionNode).getNameStart();
                break;
            }
            case METHOD_CONTEXT: {
                replacementStart = ((Expression)this.context.completionNode).getNameStart();
                break;
            }
            default: {
                replacementStart = this.context.completionLocation - this.context.fullCompletionExpression.replaceFirst("^\\s+", "").length();
            }
        }
        return replacementStart;
    }

    protected final GroovyCompletionProposal createProposal(int kind, int completionOffset) {
        GroovyCompletionProposal proposal = new GroovyCompletionProposal(kind, completionOffset);
        proposal.setNameLookup(this.nameEnvironment.nameLookup);
        return proposal;
    }

    protected static CompletionProposal extractProposal(ICompletionProposal javaProposal) {
        ProposalInfo proposalInfo;
        if (javaProposal instanceof AbstractJavaCompletionProposal && (proposalInfo = (ProposalInfo)ReflectionUtils.executePrivateMethod(AbstractJavaCompletionProposal.class, (String)"getProposalInfo", (Object)javaProposal)) instanceof MemberProposalInfo) {
            CompletionProposal completionProposal = (CompletionProposal)ReflectionUtils.getPrivateField(MemberProposalInfo.class, (String)"fProposal", (Object)proposalInfo);
            return completionProposal;
        }
        return null;
    }
}

