/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.handlers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.git.constants.GitStringConstants;
import com.kms.katalon.composer.integration.git.handlers.AbstractGitProjectHandler;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.ui.internal.commands.ShareSingleProjectCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.widgets.Shell;

public class ShareProjectHandler
extends AbstractGitProjectHandler {
    private static final String GITIGNORE_FILE_NAME = ".gitignore";
    private static final String[] DEFAULT_IGNORE_RESOURCES = new String[]{"/bin/", "/Libs/", "/.settings/", "/.classpath", ".svn/", ".cache/"};
    private static final String SHARE_PROJECT_COMMAND_ID = "org.eclipse.egit.ui.command.shareProject";

    @Override
    @CanExecute
    public boolean canExecute() {
        return this.getCurrentProject() != null && this.getRepository() == null;
    }

    @Execute
    public void execute(final Shell shell) {
        try {
            final ProjectEntity currentProject = this.getCurrentProject();
            final IProject groovyProject = this.getCurrentIProject();
            new ProgressMonitorDialog(shell).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        File repo = ShareProjectHandler.this.createRepo(currentProject.getFolderLocation(), groovyProject);
                        ConnectProviderOperation op = new ConnectProviderOperation(groovyProject, repo);
                        op.execute(monitor);
                        ShareProjectHandler.addDefaultIgnores(currentProject.getFolderLocation());
                        UISynchronizeService.syncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation((Shell)shell, (String)GitStringConstants.INFO, (String)GitStringConstants.HAND_SUCCESS_MSG_SHARE_PROJECT);
                            }
                        });
                    }
                    catch (IOException | CoreException ce) {
                        throw new InvocationTargetException(ce);
                    }
                }
            });
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            MessageDialog.openError((Shell)shell, (String)GitStringConstants.ERROR, (String)GitStringConstants.HAND_ERROR_MSG_UNABLE_TO_SHARE_PROJ);
        }
    }

    private File createRepo(String projectFolder, IProject project) throws IOException, CoreException {
        File gitDir = new File(projectFolder, ".git");
        FileRepositoryBuilder.create((File)gitDir).create();
        if (!gitDir.toString().contains("..")) {
            project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        RepositoryUtil.INSTANCE.addConfiguredRepository(gitDir);
        return gitDir;
    }

    @Override
    public String getEgitCommandId() {
        return SHARE_PROJECT_COMMAND_ID;
    }

    @Override
    public AbstractHandler getHandler() {
        return new ShareSingleProjectCommand();
    }

    public static void addDefaultIgnores(String projectFolder) throws IOException {
        File gitIgnoreFile = new File(projectFolder, GITIGNORE_FILE_NAME);
        if (!gitIgnoreFile.exists()) {
            gitIgnoreFile.createNewFile();
        }
        String[] ignoreResources = FileUtils.readFileToString((File)gitIgnoreFile).split("\n");
        ArrayList<String> ignoreResourcesList = new ArrayList<String>(Arrays.asList(ignoreResources));
        String[] stringArray = DEFAULT_IGNORE_RESOURCES;
        int n = DEFAULT_IGNORE_RESOURCES.length;
        int n2 = 0;
        while (n2 < n) {
            String ignoreResource = stringArray[n2];
            if (!ignoreResourcesList.contains(ignoreResource)) {
                ignoreResourcesList.add(ignoreResource);
            }
            ++n2;
        }
        FileUtils.writeStringToFile((File)gitIgnoreFile, (String)StringUtils.join(ignoreResourcesList, (String)"\n"));
    }
}

