/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.groovy.reference;

import com.kms.katalon.util.ExecutionTimeTracker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;

public class EntityReferenceIndexService {
    private EntityReferenceIndexData indexData = new EntityReferenceIndexData();
    private String indexFilePath;
    private boolean isReady;
    private final Object readyLock = new Object();
    private final String regexForGroovyScript = "(findTestObject|findWindowsObject|findTestData|findTestCase|findCheckpoint)\\(\"([^\"]*)\"|'([^']*)'\\)";
    private Pattern patternForGroovyScript = Pattern.compile("(findTestObject|findWindowsObject|findTestData|findTestCase|findCheckpoint)\\(\"([^\"]*)\"|'([^']*)'\\)");
    private final String regexForTestSuiteXml = "<testCaseId>(.*?)</testCaseId>";
    private Pattern patternForTestSuiteXml = Pattern.compile("<testCaseId>(.*?)</testCaseId>");
    public static final EntityReferenceIndexService singleton = new EntityReferenceIndexService();

    public static EntityReferenceIndexService getInstance() {
        return singleton;
    }

    private EntityReferenceIndexService() {
    }

    public void switchProject(String newIndexFilePath) {
        this.indexData.clear();
        this.indexFilePath = newIndexFilePath;
        this.setReady(false);
    }

    public synchronized void prepareIndexForNewlyOpenedProject(List<File> dataFiles) {
        this.setReady(false);
        this.loadIndexFile();
        this.reindexFilesIfLastModifiedTimeChanged(dataFiles);
        this.setReady(true);
        this.saveIndexFile();
    }

    private void processDataFile(File file) {
        Charset charset = Charset.forName("UTF-8");
        String path = file.getAbsolutePath();
        Path nioPath = file.toPath();
        for (Map.Entry<String, HashSet<String>> entry : this.indexData.entityReferenceMap.entrySet()) {
            entry.getValue().remove(path);
        }
        try {
            String scriptContent = Files.readString(nioPath, charset);
            List<Object> referencedEntityIds = List.of();
            if (path.endsWith(".groovy")) {
                referencedEntityIds = this.extractReferencedEntityIdsFromGroovyScript(scriptContent);
            } else if (path.endsWith(".ts")) {
                referencedEntityIds = this.extractReferencedTestCaseIdsFromTestSuiteXml(scriptContent);
            }
            for (String string : referencedEntityIds) {
                this.indexData.entityReferenceMap.computeIfAbsent(string, k -> new HashSet()).add(path);
            }
            Long l = this.extractLastModifiedTime(nioPath);
            if (l != null) {
                this.indexData.fileLastModifiedTimeMap.put(path, l);
            }
        }
        catch (Exception exception) {}
    }

    public List<IFile> searchIFilesReferencingEntityId(String entityId, List<IFile> allFiles) {
        String taskName = "Search files referencing given entityId to rename";
        ExecutionTimeTracker.getInstance().start(taskName);
        this.reindexFilesIfLastModifiedTimeChanged(allFiles.stream().map(iFile -> iFile.getLocation().toFile()).collect(Collectors.toList()));
        ExecutionTimeTracker.getInstance().stop(taskName);
        HashSet<String> filteredPaths = this.indexData.entityReferenceMap.get(entityId);
        if (filteredPaths == null || filteredPaths.isEmpty()) {
            return List.of();
        }
        List<IFile> filteredFiles = allFiles.stream().filter(file -> filteredPaths.contains(file.getLocation().toOSString())).toList();
        return filteredFiles;
    }

    public List<IFile> searchIFilesReferencingEntityIdPrefix(String entityIdPrefix, List<IFile> allFiles) {
        String taskName = "Search files referencing entityId prefix to rename";
        ExecutionTimeTracker.getInstance().start(taskName);
        this.reindexFilesIfLastModifiedTimeChanged(allFiles.stream().map(iFile -> iFile.getLocation().toFile()).collect(Collectors.toList()));
        ExecutionTimeTracker.getInstance().stop(taskName);
        HashSet filteredPaths = new HashSet();
        for (String key : this.indexData.entityReferenceMap.keySet()) {
            if (key == null || !key.startsWith(entityIdPrefix)) continue;
            filteredPaths.addAll(this.indexData.entityReferenceMap.get(key));
        }
        if (filteredPaths.isEmpty()) {
            return List.of();
        }
        return allFiles.stream().filter(file -> filteredPaths.contains(file.getLocation().toOSString())).toList();
    }

    public List<File> searchFilesReferencingEntityId(String entityId, List<File> allFiles) {
        String taskName = "Search files referencing given entityId to rename";
        ExecutionTimeTracker.getInstance().start(taskName);
        this.reindexFilesIfLastModifiedTimeChanged(allFiles);
        ExecutionTimeTracker.getInstance().stop(taskName);
        HashSet<String> filteredPaths = this.indexData.entityReferenceMap.get(entityId);
        if (filteredPaths == null || filteredPaths.isEmpty()) {
            return List.of();
        }
        return allFiles.stream().filter(file -> filteredPaths.contains(file.getAbsolutePath())).toList();
    }

    public void reindexFilesIfLastModifiedTimeChanged(List<File> files) {
        for (File file : files) {
            String path = file.getAbsolutePath();
            Long cachedLastModifiedTime = this.indexData.fileLastModifiedTimeMap.get(path);
            if (cachedLastModifiedTime != null && cachedLastModifiedTime >= file.lastModified()) continue;
            this.processDataFile(file);
        }
    }

    private List<String> extractReferencedEntityIdsFromGroovyScript(String content) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = this.patternForGroovyScript.matcher(content);
        while (matcher.find()) {
            String foundText;
            String string = foundText = matcher.group(2) != null ? matcher.group(2) : matcher.group(3);
            if (!StringUtils.isNotBlank((String)foundText)) continue;
            result.add(foundText.trim());
        }
        return result;
    }

    private List<String> extractReferencedTestCaseIdsFromTestSuiteXml(String content) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = this.patternForTestSuiteXml.matcher(content);
        while (matcher.find()) {
            String foundText = matcher.group(1);
            if (!StringUtils.isNotBlank((String)foundText)) continue;
            result.add(foundText.trim());
        }
        return result;
    }

    private Long extractLastModifiedTime(Path path) {
        BasicFileAttributeView basicView = Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]);
        try {
            return basicView.readAttributes().lastModifiedTime().toMillis();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void printForDebug() {
        for (Map.Entry<String, HashSet<String>> entry : this.indexData.entityReferenceMap.entrySet()) {
            System.out.println(entry.getKey() + " -> " + String.valueOf(entry.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        Object object = this.readyLock;
        synchronized (object) {
            return this.isReady;
        }
    }

    public synchronized void setReady(boolean isReady) {
        this.isReady = isReady;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void saveIndexFile() {
        String path = this.indexFilePath;
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                        oos.writeObject(this.indexData);
                        oos.flush();
                        byte[] data = baos.toByteArray();
                        Files.write(Paths.get(path, new String[0]), data, new OpenOption[0]);
                    }
                    if (baos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (baos == null) throw throwable;
                    baos.close();
                    throw throwable;
                }
                baos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadIndexFile() {
        String path = this.indexFilePath;
        try {
            byte[] data = Files.readAllBytes(Paths.get(path, new String[0]));
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                try {
                    try (ObjectInputStream ois = new ObjectInputStream(bais);){
                        this.indexData = (EntityReferenceIndexData)ois.readObject();
                    }
                    if (bais == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bais == null) throw throwable;
                    bais.close();
                    throw throwable;
                }
                bais.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    private static class EntityReferenceIndexData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public ConcurrentHashMap<String, HashSet<String>> entityReferenceMap = new ConcurrentHashMap();
        public ConcurrentHashMap<String, Long> fileLastModifiedTimeMap = new ConcurrentHashMap();

        private EntityReferenceIndexData() {
        }

        public void clear() {
            this.entityReferenceMap.clear();
            this.fileLastModifiedTimeMap.clear();
        }
    }
}

