/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.contributions;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.contributions.ContributionGroup;
import org.codehaus.groovy.eclipse.dsl.contributions.EmptyContributionElement;
import org.codehaus.groovy.eclipse.dsl.contributions.IContributionElement;
import org.codehaus.groovy.eclipse.dsl.contributions.MethodContributionElement;
import org.codehaus.groovy.eclipse.dsl.contributions.ParameterContribution;
import org.codehaus.groovy.eclipse.dsl.contributions.PropertyContributionElement;
import org.codehaus.groovy.eclipse.dsl.lookup.ResolverCache;
import org.codehaus.groovy.eclipse.dsl.pointcuts.BindingSet;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.VariableScope;

public class DSLContributionGroup
extends ContributionGroup {
    private static final String NO_NAME = "";
    private static final String NO_TYPE = "java.lang.Object";
    private static final ParameterContribution[] NO_PARAMS = new ParameterContribution[0];
    private final Closure<?> contributionClosure;
    private VariableScope scope;
    private String provider;
    private IJavaProject project;
    private ResolverCache resolver;
    private Map<String, Collection<Object>> bindings;
    private ClassNode currentType;
    private Map<String, Object> wormhole;
    private boolean staticScope;
    private boolean isPrimaryExpression;

    public DSLContributionGroup(Closure<?> contributionClosure) {
        this.contributionClosure = contributionClosure;
        if (contributionClosure != null) {
            contributionClosure.setDelegate((Object)this);
            contributionClosure.setResolveStrategy(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IContributionElement> getContributions(GroovyDSLDContext pattern, BindingSet matches) {
        DSLContributionGroup dSLContributionGroup = this;
        synchronized (dSLContributionGroup) {
            List result;
            block11: {
                try {
                    try {
                        this.contributions = new ArrayList();
                        this.scope = pattern.getCurrentScope();
                        this.project = pattern.getCurrentProject();
                        this.bindings = matches.getBindings();
                        this.resolver = pattern.getResolverCache();
                        this.wormhole = this.scope.getWormhole();
                        this.currentType = pattern.getCurrentType();
                        this.staticScope = pattern.isStatic();
                        this.isPrimaryExpression = pattern.isPrimaryNode();
                        this.contributionClosure.call();
                    }
                    catch (Exception e) {
                        GroovyLogManager.manager.logException(TraceCategory.DSL, (Throwable)e);
                        if (!this.currentType.equals((Object)pattern.getCurrentType())) {
                            pattern.setTargetType(this.currentType);
                        }
                        result = this.contributions;
                        this.contributions = null;
                        this.scope = null;
                        this.project = null;
                        this.bindings = null;
                        this.resolver = null;
                        this.wormhole = null;
                        this.currentType = null;
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    if (!this.currentType.equals((Object)pattern.getCurrentType())) {
                        pattern.setTargetType(this.currentType);
                    }
                    List result2 = this.contributions;
                    this.contributions = null;
                    this.scope = null;
                    this.project = null;
                    this.bindings = null;
                    this.resolver = null;
                    this.wormhole = null;
                    this.currentType = null;
                    throw throwable;
                }
                if (!this.currentType.equals((Object)pattern.getCurrentType())) {
                    pattern.setTargetType(this.currentType);
                }
                result = this.contributions;
                this.contributions = null;
                this.scope = null;
                this.project = null;
                this.bindings = null;
                this.resolver = null;
                this.wormhole = null;
                this.currentType = null;
            }
            return result;
        }
    }

    public Object getProperty(String property) {
        switch (property) {
            case "resolver": {
                return this.resolver;
            }
            case "wormhole": {
                return this.wormhole;
            }
            case "currentType": {
                return this.currentType;
            }
            case "currentNode": {
                return this.scope.getCurrentNode();
            }
            case "enclosingNode": {
                return this.scope.getEnclosingNode();
            }
        }
        if (this.bindings.containsKey(property)) {
            return this.bindings.get(property);
        }
        throw new MissingPropertyException(property, this.getClass());
    }

    private ParameterContribution[] extractParams(Map<String, Object> args, String paramKind) {
        Map paramsMap = (Map)args.get(paramKind);
        ParameterContribution[] params = NO_PARAMS;
        if (paramsMap != null && !paramsMap.isEmpty()) {
            params = new ParameterContribution[paramsMap.size()];
            int i = 0;
            for (Map.Entry entry : paramsMap.entrySet()) {
                String name = this.asString(entry.getKey());
                String type = this.asString(entry.getValue());
                params[i++] = new ParameterContribution(name != null ? name : NO_NAME, type != null ? type : NO_TYPE);
            }
        }
        return params;
    }

    static String getTypeName(ClassNode clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append(clazz.getName());
        if (clazz.getGenericsTypes() != null && clazz.getGenericsTypes().length > 0) {
            sb.append('<');
            GenericsType[] genericsTypeArray = clazz.getGenericsTypes();
            int n = genericsTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType gt = genericsTypeArray[n2];
                sb.append(DSLContributionGroup.getTypeName(gt.getType()));
                sb.append(',');
                ++n2;
            }
            sb.replace(sb.length() - 1, sb.length(), ">");
        }
        return sb.toString();
    }

    private void internalDelegatesTo(AnnotatedNode node, boolean useNamedArgs, boolean isStatic, boolean asCategory, boolean isDeprecated, Set<?> exceptions, boolean noParens) {
        ClassNode type;
        if (this.staticScope && !isStatic && !VariableScope.CLASS_CLASS_NODE.equals((Object)this.currentType)) {
            return;
        }
        if (node instanceof ClassNode) {
            type = (ClassNode)node;
        } else if (node instanceof FieldNode) {
            type = ((FieldNode)node).getType();
        } else if (node instanceof MethodNode) {
            type = ((MethodNode)node).getReturnType();
        } else if (node instanceof ClassExpression) {
            type = ((ClassExpression)node).getType();
        } else {
            if (GroovyLogManager.manager.hasLoggers()) {
                GroovyLogManager.manager.log(TraceCategory.DSL, "Cannot invoke delegatesTo() on an invalid object: " + String.valueOf(node));
            }
            return;
        }
        if (!VariableScope.OBJECT_CLASS_NODE.equals((Object)type)) {
            GenericsMapper mapper = GenericsMapper.gatherGenerics((ClassNode)type);
            Map methods = this.currentType.getDeclaredMethodsMap();
            ArrayList<PropertyContributionElement> accessorContribs = new ArrayList<PropertyContributionElement>(1);
            for (MethodNode method : type.getDeclaredMethodsMap().values()) {
                ClassNode selfType;
                MethodNode mn;
                String name = method.getName();
                if (!method.isPublic() || method.isStatic() && !asCategory || GroovyUtils.isSynthetic((MethodNode)method) || name.endsWith("init>") || name.contains("$") || exceptions != null && exceptions.contains(name) || (mn = (MethodNode)methods.get((method = VariableScope.resolveTypeParameterization((GenericsMapper)mapper, (MethodNode)method)).getTypeDescriptor())) != null && (mn.getEnd() > 1 || mn.getDeclaringClass().equals((Object)VariableScope.OBJECT_CLASS_NODE)) || ("getMetaClass".equals(name) ? GroovyUtils.getParameterTypes((Parameter[])method.getParameters()).isEmpty() : ("setMetaClass".equals(name) ? GroovyUtils.getParameterTypes((Parameter[])method.getParameters()).equals(List.of(ClassHelper.METACLASS_TYPE)) : ("getProperty".equals(name) ? GroovyUtils.getParameterTypes((Parameter[])method.getParameters()).equals(List.of(VariableScope.STRING_CLASS_NODE)) : ("setProperty".equals(name) || "invokeMethod".equals(name)) && GroovyUtils.getParameterTypes((Parameter[])method.getParameters()).equals(List.of(VariableScope.STRING_CLASS_NODE, VariableScope.OBJECT_CLASS_NODE)))))) continue;
                ParameterContribution[] params = null;
                if (!asCategory) {
                    params = this.toParameterContribution(method.getParameters());
                } else if (method.getParameters() != null && method.getParameters().length > 0 && (this.currentType.isDerivedFrom(selfType = method.getParameters()[0].getType()) || this.currentType.implementsInterface(selfType))) {
                    params = this.toParameterContributionRemoveFirst(method.getParameters());
                }
                if (params == null) continue;
                String declaringType = DSLContributionGroup.getTypeName(type);
                String returnType = DSLContributionGroup.getTypeName(method.getReturnType());
                boolean myDeprecated = isDeprecated || GroovyUtils.isDeprecated((ASTNode)method);
                boolean staticMethod = isStatic || !asCategory && method.isStatic();
                this.contributions.add(new MethodContributionElement(name, params, NO_PARAMS, NO_PARAMS, returnType, declaringType, staticMethod, this.provider, null, useNamedArgs, noParens, myDeprecated, 11));
                name = DSLContributionGroup.isAccessor(method, name, asCategory);
                if (name == null || name.equals("empty") && GeneralUtils.isOrImplements((ClassNode)type, (ClassNode)VariableScope.MAP_CLASS_NODE)) continue;
                int modifiers = 0;
                if (staticMethod) {
                    modifiers |= 8;
                }
                if (type.getMethods(GeneralUtils.getSetterName((String)name)).isEmpty()) {
                    modifiers |= 0x10;
                }
                accessorContribs.add(new PropertyContributionElement(name, returnType, declaringType, modifiers, this.provider, null, myDeprecated, 11));
            }
            this.contributions.addAll(accessorContribs);
        }
    }

    private ParameterContribution[] toParameterContribution(Parameter[] params) {
        if (params != null && params.length > 0) {
            ParameterContribution[] contribs = new ParameterContribution[params.length];
            int i = 0;
            int n = params.length;
            while (i < n) {
                contribs[i] = new ParameterContribution(params[i]);
                ++i;
            }
            return contribs;
        }
        return NO_PARAMS;
    }

    private ParameterContribution[] toParameterContributionRemoveFirst(Parameter[] params) {
        if (params != null && params.length > 1) {
            ParameterContribution[] contribs = new ParameterContribution[params.length - 1];
            int i = 1;
            int n = params.length;
            while (i < n) {
                contribs[i - 1] = new ParameterContribution(params[i]);
                ++i;
            }
            return contribs;
        }
        return NO_PARAMS;
    }

    private static String isAccessor(MethodNode method, String name, boolean isCategory) {
        if (method.getParameters() == null || method.getParameters().length == (isCategory ? 1 : 0)) {
            if (name.length() > 3 && name.startsWith("get")) {
                return Introspector.decapitalize(name.substring(3));
            }
            if (name.length() > 2 && name.startsWith("is")) {
                return Introspector.decapitalize(name.substring(2));
            }
        }
        return null;
    }

    private static boolean isDeprecated(Map<?, ?> args) {
        return DSLContributionGroup.asBoolean(args.get("isDeprecated"));
    }

    private static boolean isFinal(Map<?, ?> args) {
        Object modifier = args.get("readOnly");
        if (modifier == null) {
            modifier = args.get("isFinal");
        }
        return DSLContributionGroup.asBoolean(modifier);
    }

    private static boolean isStatic(Map<?, ?> args) {
        return DSLContributionGroup.asBoolean(args.get("isStatic"));
    }

    private static boolean asBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String string = value.toString();
        return "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string);
    }

    private ClassNode asClassNode(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ClassNode) {
            return (ClassNode)value;
        }
        if (value instanceof String) {
            return this.resolver.resolve((String)value);
        }
        if (value instanceof Class) {
            return this.resolver.resolve(((Class)value).getCanonicalName());
        }
        return this.resolver.resolve(value.toString());
    }

    private String asString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Class) {
            return ((Class)value).getCanonicalName();
        }
        if (value instanceof ClassNode) {
            return DSLContributionGroup.getTypeName((ClassNode)value);
        }
        if (value instanceof FieldNode) {
            return DSLContributionGroup.getTypeName(((FieldNode)value).getDeclaringClass()) + "." + ((FieldNode)value).getName();
        }
        if (value instanceof MethodNode) {
            return DSLContributionGroup.getTypeName(((MethodNode)value).getDeclaringClass()) + "." + ((MethodNode)value).getName();
        }
        if (value instanceof ConstantExpression) {
            return ((ConstantExpression)value).getText();
        }
        if (value instanceof Variable) {
            return ((Variable)value).getName();
        }
        if (value instanceof AnnotationNode) {
            return ((AnnotationNode)value).getClassNode().getName();
        }
        if (value instanceof Collection && ((Collection)value).size() == 1) {
            return this.asString(((Collection)value).iterator().next());
        }
        return value.toString();
    }

    public void method(Map<String, Object> args) {
        boolean isStatic = DSLContributionGroup.isStatic(args);
        if (!this.staticScope || this.staticScope && isStatic) {
            String theProvider;
            String declaringType;
            String returnType;
            String name = this.asString(args.get("name"));
            if (name == null) {
                name = NO_NAME;
            }
            if ((returnType = this.asString(args.get("type"))) == null) {
                returnType = NO_TYPE;
            }
            if ((declaringType = this.asString(args.get("declaringType"))) == null) {
                declaringType = DSLContributionGroup.getTypeName(this.currentType);
            }
            if ((theProvider = this.asString(args.get("provider"))) == null) {
                theProvider = this.provider;
            }
            String doc = this.asString(args.get("doc"));
            boolean isDeprecated = DSLContributionGroup.isDeprecated(args);
            boolean noParens = DSLContributionGroup.asBoolean(args.get("noParens"));
            boolean useNamedArgs = DSLContributionGroup.asBoolean(args.get("useNamedArgs"));
            ParameterContribution[] params = this.extractParams(args, "params");
            ParameterContribution[] namedParams = this.extractParams(args, "namedParams");
            ParameterContribution[] optionalParams = this.extractParams(args, "optionalParams");
            this.contributions.add(new MethodContributionElement(name, params, namedParams, optionalParams, returnType, declaringType, isStatic, theProvider, doc, useNamedArgs, noParens, isDeprecated, 11));
        }
    }

    public void property(Map<String, Object> args) {
        boolean isStatic = DSLContributionGroup.isStatic(args);
        if (!this.staticScope || this.staticScope && isStatic) {
            String theProvider;
            String declaringType;
            String type;
            String name = this.asString(args.get("name"));
            if (name == null) {
                name = NO_NAME;
            }
            if ((type = this.asString(args.get("type"))) == null) {
                type = NO_TYPE;
            }
            if ((declaringType = this.asString(args.get("declaringType"))) == null) {
                declaringType = DSLContributionGroup.getTypeName(this.currentType);
            }
            int mods = 0;
            if (isStatic) {
                mods |= 8;
            }
            if (DSLContributionGroup.isFinal(args)) {
                mods |= 0x10;
            }
            if ((theProvider = this.asString(args.get("provider"))) == null) {
                theProvider = this.provider;
            }
            String doc = this.asString(args.get("doc"));
            boolean isDeprecated = DSLContributionGroup.isDeprecated(args);
            this.contributions.add(new PropertyContributionElement(name, type, declaringType, mods, theProvider, doc, isDeprecated, 11));
        }
    }

    public void template(Map<String, String> args) {
    }

    public void delegatesTo(Map<String, Object> args) {
        this.internalDelegatesTo((AnnotatedNode)this.asClassNode(args.get("type")), DSLContributionGroup.asBoolean(args.get("useNamed")), DSLContributionGroup.isStatic(args), DSLContributionGroup.asBoolean(args.get("asCategory")), DSLContributionGroup.isDeprecated(args), (Set)DefaultGroovyMethods.asType((Object)args.get("except"), Set.class), DSLContributionGroup.asBoolean(args.get("noParens")));
    }

    public void delegatesTo(AnnotatedNode node) {
        this.internalDelegatesTo(node, false, false, false, false, null, false);
    }

    public void delegatesTo(Class<?> clazz) {
        ClassNode resolved = this.asClassNode(clazz);
        if (resolved == VariableScope.OBJECT_CLASS_NODE && !clazz.getCanonicalName().equals(NO_TYPE)) {
            try {
                resolved = ClassHelper.make(clazz);
            }
            catch (Exception e) {
                GroovyDSLCoreActivator.logException(e);
            }
        }
        this.delegatesTo((AnnotatedNode)resolved);
    }

    public void delegatesTo(String type) {
        this.delegatesTo((AnnotatedNode)this.asClassNode(type));
    }

    public void delegatesToUseNamedArgs(AnnotatedNode node) {
        this.internalDelegatesTo(node, true, false, false, false, null, false);
    }

    public void delegatesToUseNamedArgs(Class<?> clazz) {
        this.delegatesToUseNamedArgs((AnnotatedNode)this.asClassNode(clazz));
    }

    public void delegatesToUseNamedArgs(String type) {
        this.delegatesToUseNamedArgs((AnnotatedNode)this.asClassNode(type));
    }

    public void delegatesToCategory(AnnotatedNode node) {
        this.internalDelegatesTo(node, false, false, true, false, null, false);
    }

    public void delegatesToCategory(Class<?> clazz) {
        this.delegatesToCategory((AnnotatedNode)this.asClassNode(clazz));
    }

    public void delegatesToCategory(String type) {
        this.delegatesToCategory((AnnotatedNode)this.asClassNode(type));
    }

    public void setDelegateType(Object value) {
        ClassNode delegate = this.asClassNode(value);
        if (delegate != null) {
            this.contributions.add(new EmptyContributionElement(this.currentType));
            this.scope.addVariable("delegate", delegate, VariableScope.CLOSURE_CLASS_NODE);
            this.scope.addVariable("getDelegate", delegate, VariableScope.CLOSURE_CLASS_NODE);
            if (this.isPrimaryExpression) {
                this.currentType = delegate;
            }
        }
    }

    public void setProvider(String value) {
        this.provider = value;
    }

    @Deprecated(since="5.1.0")
    public void provider(Object value) {
        this.setProvider(this.asString(value));
    }

    public Object log(Object value) {
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.DSL, "======== " + String.valueOf(value));
        }
        return value;
    }

    public Map<String, ClassNode> params(MethodNode node) {
        ClassNode declaringClass;
        Parameter[] parameters = node.getParameters();
        if (parameters == null || parameters.length < 1) {
            return Collections.emptyMap();
        }
        String[] names = null;
        if ("arg0".equals(parameters[0].getName()) && (declaringClass = node.getDeclaringClass()) instanceof JDTClassNode) {
            try {
                IType declaringType = this.project.findType(declaringClass.getName());
                if (declaringType != null && declaringType.exists()) {
                    String[] parameterTypeSignatures = new String[parameters.length];
                    int i = 0;
                    while (i < parameters.length) {
                        parameterTypeSignatures[i] = declaringType.isBinary() ? String.valueOf(ProposalUtils.createTypeSignature((ClassNode)parameters[i].getType())) : String.valueOf(ProposalUtils.createUnresolvedTypeSignature((ClassNode)parameters[i].getType()));
                        ++i;
                    }
                    String name = !node.getName().equals("<init>") ? node.getName() : declaringClass.getNameWithoutPackage();
                    IMethod declaredMethod = declaringType.getMethod(name, parameterTypeSignatures);
                    if (declaredMethod != null && declaredMethod.exists()) {
                        names = declaredMethod.getParameterNames();
                    }
                }
            }
            catch (Exception e) {
                GroovyDSLCoreActivator.logException(e);
            }
        }
        LinkedHashMap<String, ClassNode> params = new LinkedHashMap<String, ClassNode>();
        int i = 0;
        while (i < parameters.length) {
            params.put((String)(names != null ? names[i] : parameters[i].getName()), parameters[i].getType());
            ++i;
        }
        return params;
    }
}

