/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.azure.model;

import com.kms.katalon.constants.HttpMethod;
import com.kms.katalon.integration.azure.model.AzureOperation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AzureUpdateWorkItemsBatchReqBodyItem {
    private String workItemId;
    private HttpMethod method;
    private String uri;
    private Map<String, String> headers;
    private List<AzureOperation> body;

    public AzureUpdateWorkItemsBatchReqBodyItem(String workItemId, HttpMethod method, String uri, Map<String, String> headers, List<AzureOperation> body) {
        this.workItemId = workItemId;
        this.method = method;
        this.uri = uri;
        this.headers = headers;
        this.body = body;
    }

    public String getWorkItemId() {
        return this.workItemId;
    }

    public void setWorkItemId(String workItemId) {
        this.workItemId = workItemId;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public List<AzureOperation> getBody() {
        return this.body;
    }

    public void setBody(List<AzureOperation> body) {
        this.body = body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String workItemId;
        private HttpMethod method;
        private String uri;
        private Map<String, String> headers;
        private Map<String, AzureOperation> bodyAzureOperationMap;

        public Builder workItemId(String workItemId) {
            this.workItemId = workItemId;
            return this;
        }

        public String getWorkItemId() {
            return this.workItemId;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder addBodyOperation(String azureTestCaseField, AzureOperation operation) {
            if (this.bodyAzureOperationMap == null) {
                this.bodyAzureOperationMap = new HashMap<String, AzureOperation>();
            }
            this.bodyAzureOperationMap.put(azureTestCaseField, operation);
            return this;
        }

        public Builder removeBodyOperation(String azureTestCaseField) {
            if (this.bodyAzureOperationMap == null) {
                return this;
            }
            this.bodyAzureOperationMap.remove(azureTestCaseField);
            return this;
        }

        public AzureUpdateWorkItemsBatchReqBodyItem build() {
            List<AzureOperation> body = this.bodyAzureOperationMap == null ? Collections.emptyList() : this.bodyAzureOperationMap.values().stream().collect(Collectors.toList());
            return new AzureUpdateWorkItemsBatchReqBodyItem(this.workItemId, this.method, this.uri, this.headers, body);
        }
    }
}

