/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.plugins;

import io.cucumber.eclipse.java.plugins.Jackson;
import io.cucumber.messages.MessageToNdjsonWriter;
import io.cucumber.messages.types.Envelope;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class CucumberEclipsePlugin
implements ConcurrentEventListener {
    private Consumer<Envelope> consumer;
    public static final int HANDLED_MESSAGE = 1;
    public static final int GOOD_BY_MESSAGE = 0;

    public CucumberEclipsePlugin(String port) throws IOException {
        this(new SocketConsumer(port));
    }

    public CucumberEclipsePlugin(Consumer<Envelope> consumer) {
        this.consumer = consumer;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Envelope.class, this::writeMessage);
    }

    private void writeMessage(Envelope envelope) {
        this.consumer.accept(envelope);
    }

    private static final class SocketConsumer
    implements Consumer<Envelope> {
        private final Socket socket;
        private final DataOutputStream output;
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(0xA00000);
        private AtomicInteger written = new AtomicInteger();
        private InputStream input;

        public SocketConsumer(String port) throws NumberFormatException, UnknownHostException, IOException {
            try {
                this.socket = new Socket(null, Integer.parseInt(port));
                this.output = new DataOutputStream(this.socket.getOutputStream());
                this.input = this.socket.getInputStream();
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!socket.isClosed()) {
                                output.writeInt(0);
                                socket.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("can't parse port number", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Envelope env) {
            Socket socket = this.socket;
            synchronized (socket) {
                if (this.socket.isClosed()) {
                    return;
                }
                try {
                    this.buffer.reset();
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (MessageToNdjsonWriter writer = new MessageToNdjsonWriter((OutputStream)this.buffer, (MessageToNdjsonWriter.Serializer)new Jackson());){
                        writer.write(env);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    this.output.writeInt(this.buffer.size());
                    this.buffer.writeTo(this.output);
                    this.output.flush();
                    int read = this.input.read() & 0xFF;
                    this.written.incrementAndGet();
                    if (env.getTestRunFinished().isPresent() || read == 0) {
                        this.finish();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void finish() throws IOException {
            this.output.writeInt(0);
            this.output.flush();
            this.input.read();
            this.socket.close();
        }
    }
}

