/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.expressions;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BooleanExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.TernaryExpression;

public class TernaryExpressionWrapper
extends ExpressionWrapper {
    private BooleanExpressionWrapper booleanExpression;
    private ExpressionWrapper trueExpression;
    private ExpressionWrapper falseExpression;

    public TernaryExpressionWrapper(BooleanExpressionWrapper booleanExpression, ExpressionWrapper trueExpression, ExpressionWrapper falseExpression, ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.booleanExpression = booleanExpression;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    public TernaryExpressionWrapper(TernaryExpression ternaryExpression, ASTNodeWrapper parentNodeWrapper) {
        super((Expression)ternaryExpression, parentNodeWrapper);
        this.booleanExpression = new BooleanExpressionWrapper(ternaryExpression.getBooleanExpression(), (ASTNodeWrapper)this);
        this.trueExpression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(ternaryExpression.getTrueExpression(), this);
        this.falseExpression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(ternaryExpression.getFalseExpression(), this);
    }

    public TernaryExpressionWrapper(TernaryExpressionWrapper ternaryExpressionWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(ternaryExpressionWrapper, parentNodeWrapper);
        this.booleanExpression = new BooleanExpressionWrapper(ternaryExpressionWrapper.getBooleanExpression(), (ASTNodeWrapper)this);
        this.trueExpression = ternaryExpressionWrapper.getTrueExpression().copy(this);
        this.falseExpression = ternaryExpressionWrapper.getFalseExpression().copy(this);
    }

    public BooleanExpressionWrapper getBooleanExpression() {
        return this.booleanExpression;
    }

    public ExpressionWrapper getTrueExpression() {
        return this.trueExpression;
    }

    public ExpressionWrapper getFalseExpression() {
        return this.falseExpression;
    }

    @Override
    public String getText() {
        return "(" + this.booleanExpression.getText() + ") ? " + this.trueExpression.getText() + " : " + this.falseExpression.getText();
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    public List<ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.booleanExpression);
        astNodeWrappers.add(this.trueExpression);
        astNodeWrappers.add(this.falseExpression);
        return astNodeWrappers;
    }

    @Override
    public TernaryExpressionWrapper clone() {
        return new TernaryExpressionWrapper(this, this.getParent());
    }
}

