/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.statements;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapHelper;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BooleanExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class AssertStatementWrapper
extends StatementWrapper {
    private BooleanExpressionWrapper booleanExpression;
    private ExpressionWrapper messageExpression;

    public AssertStatementWrapper() {
        this(null);
    }

    public AssertStatementWrapper(ASTNodeWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.booleanExpression = new BooleanExpressionWrapper(this);
    }

    public AssertStatementWrapper(AssertStatement assertStatement, ASTNodeWrapper parentNodeWrapper) {
        super((Statement)assertStatement, parentNodeWrapper);
        this.booleanExpression = new BooleanExpressionWrapper(assertStatement.getBooleanExpression(), (ASTNodeWrapper)this);
        this.messageExpression = ASTNodeWrapHelper.getExpressionNodeWrapperFromExpression(assertStatement.getMessageExpression(), this);
    }

    public AssertStatementWrapper(AssertStatementWrapper assertStatementWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(assertStatementWrapper, parentNodeWrapper);
        this.booleanExpression = new BooleanExpressionWrapper(assertStatementWrapper.getBooleanExpression(), (ASTNodeWrapper)this);
        ExpressionWrapper sourceMessageExpression = assertStatementWrapper.getMessageExpression();
        this.messageExpression = sourceMessageExpression != null ? sourceMessageExpression.copy(this) : null;
    }

    public BooleanExpressionWrapper getBooleanExpression() {
        return this.booleanExpression;
    }

    public void setBooleanExpression(BooleanExpressionWrapper booleanExpression) {
        if (booleanExpression == null) {
            return;
        }
        booleanExpression.setParent(this);
        this.booleanExpression = booleanExpression;
    }

    public ExpressionWrapper getMessageExpression() {
        return this.messageExpression;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("assert ");
        stringBuilder.append(this.getBooleanExpression().getText());
        if (this.getMessageExpression() instanceof ConstantExpressionWrapper && ((ConstantExpressionWrapper)this.getMessageExpression()).getValue() != null) {
            stringBuilder.append(" : ");
            stringBuilder.append(this.getMessageExpression().getText());
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    public List<ASTNodeWrapper> getAstChildren() {
        ArrayList<ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.booleanExpression);
        astNodeWrappers.add(this.messageExpression);
        return astNodeWrappers;
    }

    @Override
    public AssertStatementWrapper clone() {
        return new AssertStatementWrapper(this, this.getParent());
    }

    @Override
    public ASTNodeWrapper getInput() {
        return this.getBooleanExpression();
    }

    @Override
    public String getInputText() {
        if (this.getBooleanExpression() != null) {
            return this.getBooleanExpression().getText();
        }
        return "";
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (input instanceof BooleanExpressionWrapper && !this.getBooleanExpression().isEqualsTo(input)) {
            this.setBooleanExpression((BooleanExpressionWrapper)input);
            return true;
        }
        return false;
    }

    @Override
    public boolean isInputEditatble() {
        return true;
    }
}

