/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.handlers;

import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.handlers.deletion.AbstractDeleteReferredEntityHandler;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.dialogs.TestCaseReferencesDialog;
import com.kms.katalon.composer.testcase.util.TestCaseEntityUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;

public class DeleteTestCaseHandler
extends AbstractDeleteReferredEntityHandler {
    public Class<? extends ITreeEntity> entityType() {
        return TestCaseTreeEntity.class;
    }

    public boolean execute(ITreeEntity entity, IProgressMonitor monitor) {
        try {
            if (entity == null || !(entity instanceof TestCaseTreeEntity)) {
                return false;
            }
            TestCaseEntity testCase = (TestCaseEntity)entity.getObject();
            String testCaseId = testCase.getIdForDisplay();
            monitor.subTask(MessageFormat.format(ComposerTestcaseMessageConstants.HAND_JOB_DELETING, testCaseId));
            GroovyUtil.getTestCaseScriptSourceFolder((ProjectEntity)testCase.getProject()).refreshLocal(2, null);
            if (this.performDeleteTestCase(testCase, TestArtifactScriptRefactor.createForTestCaseEntity((String)testCaseId).findReferrersInTestCaseScripts(ProjectController.getInstance().getCurrentProject()))) {
                this.eventBroker.post("EXPLORER/DELETED_SELECTED_ITEM", (Object)testCaseId);
                this.eventBroker.post("TESTCASE/DELETE", (Object)testCase.getId());
                return true;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)GlobalMessageConstants.ERROR, (String)ComposerTestcaseMessageConstants.HAND_ERROR_MSG_UNABLE_TO_DEL_TEST_CASE);
        }
        finally {
            monitor.done();
        }
        return false;
    }

    protected boolean performDeleteTestCase(final TestCaseEntity testCase, final List<IFile> affectedTestCaseScripts) {
        this.isDeleted = false;
        this.sync.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<FileEntity> affectedObjects = new ArrayList<FileEntity>();
                    TestCaseController tcController = TestCaseController.getInstance();
                    List affectedTestSuites = tcController.getTestCaseReferences(testCase);
                    affectedObjects.addAll(affectedTestSuites);
                    affectedObjects.addAll(TestCaseEntityUtil.getTestCaseEntities(affectedTestCaseScripts));
                    if (!affectedObjects.isEmpty()) {
                        if (DeleteTestCaseHandler.this.isDefaultResponse()) {
                            TestCaseReferencesDialog dialog = new TestCaseReferencesDialog(null, testCase.getIdForDisplay(), affectedObjects, DeleteTestCaseHandler.this.needYesNoToAllButtons());
                            DeleteTestCaseHandler.this.setResponse(dialog.open());
                        }
                        if (DeleteTestCaseHandler.this.isCancelResponse()) {
                            return;
                        }
                        if (DeleteTestCaseHandler.this.isYesResponse()) {
                            DeleteTestCaseHandler.this.removeReferencesInTestSuite(testCase, affectedTestSuites);
                            TestArtifactScriptRefactor.createForTestCaseEntity((String)testCase.getIdForDisplay()).removeReferences(affectedTestCaseScripts);
                        }
                    }
                    EntityPartUtil.closePart((IEntity)testCase);
                    tcController.deleteTestCase(testCase);
                    if (!DeleteTestCaseHandler.this.isYesNoToAllResponse()) {
                        DeleteTestCaseHandler.this.resetResponse();
                    }
                    DeleteTestCaseHandler.this.isDeleted = true;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
        return this.isDeleted;
    }

    private void removeReferencesInTestSuite(TestCaseEntity testCase, List<TestSuiteEntity> affectedTestSuites) throws Exception {
        TestSuiteController tsController = TestSuiteController.getInstance();
        for (TestSuiteEntity testSuite : affectedTestSuites) {
            List testCaseLinks = tsController.getTestCaseLink(testCase.getIdForDisplay(), testSuite);
            testSuite.getTestSuiteTestCaseLinks().removeAll(testCaseLinks);
            tsController.updateTestSuite(testSuite);
            this.eventBroker.post("TESTSUITE/UPDATED", (Object)new Object[]{testSuite.getId(), testSuite});
        }
    }
}

