/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.global.dialog;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.dialogs.TitleAreaDialog;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExecutionProfileNameDialog
extends TitleAreaDialog {
    private Text txtName;
    private String newName;
    private List<ExecutionProfileEntity> siblingProfiles;
    private String title;

    public ExecutionProfileNameDialog(Shell parentShell, String newName, List<ExecutionProfileEntity> siblingProfiles, String title) {
        super(parentShell);
        this.newName = newName;
        this.siblingProfiles = siblingProfiles;
        this.title = title;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 15;
        container.setLayout((Layout)layout);
        Label lblName = new Label(container, 0);
        lblName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblName.setText(GlobalStringConstants.NAME);
        this.txtName = new Text(container, 2048);
        this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setInput();
        this.registerControlModifyListeners();
        return container;
    }

    private void setInput() {
        this.txtName.setText(this.newName);
        this.txtName.setFocus();
        this.txtName.selectAll();
        this.setMessage(this.title, 1);
    }

    private void registerControlModifyListeners() {
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ExecutionProfileNameDialog.this.newName = ExecutionProfileNameDialog.this.txtName.getText();
                ExecutionProfileNameDialog.this.checkNewName(ExecutionProfileNameDialog.this.newName);
            }
        });
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(400, -1, true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected int getShellStyle() {
        return 1264;
    }

    protected void okPressed() {
        this.newName = this.txtName.getText();
        super.okPressed();
    }

    public String getNewName() {
        return this.newName;
    }

    private boolean checkNewName(String newName) {
        boolean dupplicated;
        Button button = this.getButton(0);
        if (StringUtils.isEmpty((CharSequence)newName)) {
            button.setEnabled(false);
            return false;
        }
        boolean bl = dupplicated = this.siblingProfiles.stream().filter(p -> p.getName().equals(newName)).count() > 0L;
        if (dupplicated) {
            this.setMessage(StringConstants.DIA_NAME_EXISTED, 3);
        } else {
            this.setMessage(this.title, 1);
        }
        button.setEnabled(!dupplicated);
        return !dupplicated;
    }
}

