/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.global.handler;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.ProfileRootTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ProfileTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.global.constants.ComposerGlobalMessageConstants;
import com.kms.katalon.composer.global.dialog.ExecutionProfileNameDialog;
import com.kms.katalon.composer.global.handler.ExecutionProfileTreeRootCatcher;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Display;

public class NewExecutionProfileHandler
extends ExecutionProfileTreeRootCatcher {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ESelectionService selectionService;

    @Execute
    private void execute() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        try {
            ProfileRootTreeEntity profileTreeFolder = this.getProfileTreeFolder(this.selectionService);
            List sibblingProfiles = GlobalVariableController.getInstance().getAllGlobalVariableCollections(project);
            String suggestedName = EntityNameController.getInstance().getAvailableName("New Profile", profileTreeFolder.getObject(), false);
            ExecutionProfileNameDialog dialog = new ExecutionProfileNameDialog(Display.getCurrent().getActiveShell(), suggestedName, sibblingProfiles, ComposerGlobalMessageConstants.DIA_TITLE_NEW_EXECUTION_PROFILE);
            if (dialog.open() != 0) {
                return;
            }
            String newName = dialog.getNewName();
            ExecutionProfileEntity newProfile = GlobalVariableController.getInstance().newExecutionProfile(newName, project);
            this.eventBroker.post("EXECUTION_PROFILE/CREATED", (Object)newName);
            Trackings.trackCreatingObject((String)"profile", (Object[])new Object[0]);
            ProfileTreeEntity newProfileTree = new ProfileTreeEntity(newProfile, (ITreeEntity)profileTreeFolder);
            this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)profileTreeFolder);
            this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)newProfileTree);
            this.eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", (Object)newProfile);
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((String)"Unable to create execution profile", (String)e.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }
}

