/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.global.part;

import com.kms.katalon.composer.components.impl.constants.TextContentType;
import com.kms.katalon.composer.components.impl.editors.MirrorEditor;
import com.kms.katalon.composer.components.impl.handler.DocumentReadyHandler;
import com.kms.katalon.composer.components.part.SavableCompositePart;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.global.constants.StringConstants;
import com.kms.katalon.composer.global.part.ExecutionProfileCompositePart;
import com.kms.katalon.composer.parts.CPart;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.global.GlobalVariableEntity;
import com.kms.katalon.groovy.constant.GroovyConstants;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class GlobalVariableEditorPart
extends CPart
implements SavableCompositePart {
    MirrorEditor mirrorEditor;
    Composite composite;
    ExecutionProfileEntity executionProfileEntity;
    ExecutionProfileCompositePart parentExecutionProfileCompositePart;
    String contentScript = "";
    boolean contentChanged = false;
    @Inject
    private EPartService partService;
    MPart mpart;

    @PostConstruct
    public void init(Composite parent, MPart mpart) {
        MCompositePart compositePart;
        this.mpart = mpart;
        this.executionProfileEntity = (ExecutionProfileEntity)mpart.getObject();
        if (mpart.getParent().getParent() instanceof MGenericTile && (MGenericTile)mpart.getParent().getParent() instanceof MCompositePart && (compositePart = (MCompositePart)((MGenericTile)mpart.getParent().getParent())).getObject() instanceof ExecutionProfileCompositePart) {
            this.parentExecutionProfileCompositePart = (ExecutionProfileCompositePart)compositePart.getObject();
        }
        this.initialize(mpart, this.partService);
        this.createComposite(parent);
    }

    private void createComposite(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.composite.setBackground(ColorUtil.getExtraLightGrayBackgroundColor());
        this.mirrorEditor = new MirrorEditor(this.composite, 0);
        this.mirrorEditor.setEditable(true);
        this.mirrorEditor.registerDocumentHandler(new DocumentReadyHandler(){

            public void onDocumentReady() {
                GlobalVariableEditorPart.this.mirrorEditor.changeMode(TextContentType.XML.getText());
            }
        });
        this.mirrorEditor.addListener(24, event -> {
            if (!this.contentChanged) {
                this.contentChanged = true;
            } else {
                this.setDirty(true);
            }
        });
    }

    public void setDirty(boolean isDirty) {
        this.parentExecutionProfileCompositePart.setDirty(isDirty);
    }

    public void updateProfileEntityFrom(ExecutionProfileEntity entity) throws Exception {
        if (entity != null) {
            this.executionProfileEntity = entity;
        }
        this.updateScriptContent();
    }

    private void updateScriptContent() throws Exception {
        String incomingContentScript = GlobalVariableController.toXmlString((Object)this.executionProfileEntity);
        if (this.contentScript != null) {
            this.contentChanged = true;
            if (!this.contentScript.equals(incomingContentScript)) {
                this.contentScript = incomingContentScript;
            }
        }
        this.mirrorEditor.setText(incomingContentScript);
    }

    public MPart getMPart() {
        return this.mpart;
    }

    @Persist
    public void save() {
    }

    @PreDestroy
    public void dispose() {
        super.dispose();
        this.partService.hidePart(this.mpart);
    }

    public MirrorEditor getEditor() {
        return this.mirrorEditor;
    }

    public List<MPart> getChildParts() {
        ArrayList<MPart> res = new ArrayList<MPart>();
        res.add(this.getMPart());
        return res;
    }

    private boolean isExecutionProfileEntityValid() {
        List<String> globalVariableNames = this.executionProfileEntity.getGlobalVariableEntities().stream().map(var -> var.getName()).collect(Collectors.toList());
        for (GlobalVariableEntity var2 : this.executionProfileEntity.getGlobalVariableEntities()) {
            if (this.validate(var2, globalVariableNames)) continue;
            return false;
        }
        return true;
    }

    private boolean validate(GlobalVariableEntity fVariableEntity, List<String> globalVariableNames) {
        String newVariableName = fVariableEntity.getName();
        if (!GroovyConstants.VARIABLE_NAME_REGEX.matcher(newVariableName).find()) {
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.DIA_ERROR_MSG_INVALID_VAR_NAME);
            return false;
        }
        if (globalVariableNames.indexOf(newVariableName) != globalVariableNames.lastIndexOf(newVariableName)) {
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.PA_WARN_MSG_DUPLICATE_VAR_NAME);
            return false;
        }
        return true;
    }

    public void setScriptContentFrom(ExecutionProfileEntity execProfEntity) throws Exception {
        String incomingContentScript = this.getScriptContentFromExecutionProfileEntity(execProfEntity);
        if (!this.contentScript.equals(incomingContentScript)) {
            if (!this.contentScript.equals("")) {
                this.contentChanged = true;
            }
            this.contentScript = incomingContentScript;
        }
        this.mirrorEditor.setText(incomingContentScript);
    }

    public String getScriptContentFromExecutionProfileEntity(ExecutionProfileEntity execProfEntity) throws Exception {
        String content = "";
        ExecutionProfileEntity incomingEntity = execProfEntity;
        content = GlobalVariableController.toXmlString((Object)incomingEntity);
        return content;
    }

    public String getScriptContent() {
        return this.mirrorEditor.getText();
    }

    public boolean isDirty() {
        return this.mpart.isDirty();
    }
}

