/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.application.controller;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.onboarding.core.application.controller.IKnowledgeController;
import com.kms.katalon.onboarding.core.application.controller.IKnowledgeHubNavigationController;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.core.domain.model.BaseItem;
import com.kms.katalon.onboarding.core.domain.model.KnowledgeItem;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTour;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTourItem;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTourProgress;
import com.kms.katalon.onboarding.core.domain.repository.IKnowledgeRepository;
import com.kms.katalon.onboarding.core.domain.repository.ITourRepository;
import com.kms.katalon.onboarding.core.presentation.part.KnowledgeHubPart;
import com.kms.katalon.onboarding.domain.event.OnboardingStepCompletedEvent;
import com.kms.katalon.onboarding.domain.event.OnboardingTourCompletedEvent;
import com.kms.katalon.onboarding.domain.event.OnboardingTourStartedEvent;
import com.kms.katalon.onboarding.domain.event.OnboardingTourTerminatedEvent;
import com.kms.katalon.onboarding.presentation.dialog.RatingOnboardingDialog;
import com.kms.katalon.onboarding.presentation.dialog.TestSuiteExecutorStartTourDialog;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Creatable
@Singleton
public class KnowledgeHubNavigationController
implements IKnowledgeHubNavigationController,
EventHandler {
    private final Deque<String> navigationHistory = new ArrayDeque<String>();
    @Inject
    private IKnowledgeController knowledgeController;
    @Inject
    private IKnowledgeRepository knowledgeRepository;
    @Inject
    private ITourRepository tourRepository;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IEclipseContext context;
    private KnowledgeHubPart part;

    @PostConstruct
    private void subscribeEvent() {
        this.eventBroker.subscribe("ONBOARDING/TOUR_STARTED", (EventHandler)this);
        this.eventBroker.subscribe("ONBOARDING/TOUR_COMPLETED", (EventHandler)this);
        this.eventBroker.subscribe("ONBOARDING/STEP_COMPLETED", (EventHandler)this);
        this.eventBroker.subscribe("ONBOARDING/TOUR_TERMINATED", (EventHandler)this);
    }

    public void handleEvent(Event event) {
        Object dataObject = event.getProperty("org.eclipse.e4.data");
        try {
            switch (event.getTopic()) {
                case "ONBOARDING/TOUR_STARTED": {
                    if (dataObject instanceof OnboardingTourStartedEvent) {
                        this.tourStartedHandler((OnboardingTourStartedEvent)dataObject);
                    }
                    break;
                }
                case "ONBOARDING/TOUR_COMPLETED": {
                    if (dataObject instanceof OnboardingTourCompletedEvent) {
                        this.tourCompletedHandler((OnboardingTourCompletedEvent)dataObject);
                    }
                    break;
                }
                case "ONBOARDING/STEP_COMPLETED": {
                    if (dataObject instanceof OnboardingStepCompletedEvent) {
                        this.stepCompletedHandler((OnboardingStepCompletedEvent)dataObject);
                    }
                    break;
                }
                case "ONBOARDING/TOUR_TERMINATED": {
                    if (dataObject instanceof OnboardingTourTerminatedEvent) {
                        this.tourTerminatedHandler((OnboardingTourTerminatedEvent)dataObject);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, MessageFormat.format(OnboardingMessageConstants.ERROR_HANDLING_ONBOARDING_EVENT, event.getTopic()));
        }
    }

    public void onTourItemClicked(String id) {
        try {
            this.pushToHistory();
            OnboardingTourProgress progress = this.tourRepository.getProgressById(id);
            OnboardingTour tour = this.getTour(id);
            if (progress.getPercentage() != 0) {
                this.updateProgress(tour, progress, false);
            } else {
                this.handleOnboardingTourItem(tour);
            }
            Trackings.trackNavigateToTour((String)id);
        }
        catch (Exception e) {
            this.handleException(e, OnboardingMessageConstants.ERROR_ACCESSING_TOUR_ITEM);
        }
    }

    public void onReplayClicked(String id) {
        try {
            this.knowledgeController.startTour(this.getTour(id));
        }
        catch (Exception e) {
            this.handleException(e, OnboardingMessageConstants.ERROR_REPLAYING_ONBOARDING_TOUR);
        }
    }

    public void onKnowledgeItemClicked(String id) {
        block5: {
            try {
                this.pushToHistory();
                BaseItem item = this.knowledgeRepository.getItemById(id);
                if (item == null) {
                    throw new Exception(MessageFormat.format(OnboardingMessageConstants.ERROR_ITEM_IS_NOT_FOUND, id));
                }
                if (item instanceof KnowledgeItem) {
                    KnowledgeItem knowledgeItem = (KnowledgeItem)item;
                    this.knowledgeController.startKnowledgeItem(knowledgeItem);
                    break block5;
                }
                if (item instanceof OnboardingTour) {
                    OnboardingTour onboardingItem = (OnboardingTour)item;
                    this.handleOnboardingTourItem(onboardingItem);
                    Trackings.trackNavigateToTour((String)id);
                    break block5;
                }
                throw new Exception(MessageFormat.format(OnboardingMessageConstants.ERROR_ITEM_IS_NOT_A_TOUR, id));
            }
            catch (Exception e) {
                this.handleException(e, OnboardingMessageConstants.ERROR_ACCESSING_KNOWLEDGE_ITEM);
            }
        }
    }

    public void onRated(String id, int rating) {
        try {
            OnboardingTourProgress progress = this.tourRepository.getProgressById(id);
            progress.setRating(rating);
            OnboardingTour tour = this.getTour(id);
            RatingOnboardingDialog ratingDialog = new RatingOnboardingDialog(ShellManager.getMainShell(), tour, progress);
            int returnCode = ratingDialog.open();
            if (returnCode == 0) {
                this.knowledgeController.rateTour(tour, progress, ratingDialog.getFeedback());
            }
        }
        catch (Exception e) {
            this.handleException(e, OnboardingMessageConstants.ERROR_RATING_ONBOARDING_TOUR);
        }
    }

    public void setPart(KnowledgeHubPart part) {
        this.part = part;
    }

    public void openOverviewPage() {
        try {
            this.openOverviewHandler();
        }
        catch (Exception e) {
            this.handleException(e, OnboardingMessageConstants.ERROR_FAILED_TO_OPEN_OVERVIEW_PAGE);
        }
    }

    public void navigateBack() {
        if (this.navigationHistory.isEmpty()) {
            this.openOverviewPage();
            return;
        }
        try {
            String previousUrl = this.navigationHistory.pollLast();
            if (previousUrl != null && !previousUrl.isEmpty()) {
                this.part.updateBrowser(previousUrl);
            } else {
                this.openOverviewPage();
            }
        }
        catch (Exception e) {
            this.handleException(e, OnboardingMessageConstants.ERROR_NAVIGATING_BACK_TO_PREVIOUS_PAGE);
            this.openOverviewPage();
        }
    }

    public void switchTab(String tab) {
        String currentUrl = this.part.getCurrentUrl();
        if (currentUrl.contains("tab=")) {
            String updatedUrl = currentUrl.replaceAll("([?&])tab=[^&]*", "$1tab=" + tab);
            this.part.updateBrowser(updatedUrl);
        } else {
            this.part.updateBrowser(currentUrl + "&tab=" + tab);
        }
    }

    @PreDestroy
    public void dispose() {
        if (this.eventBroker != null) {
            this.eventBroker.unsubscribe((EventHandler)this);
        }
        this.navigationHistory.clear();
    }

    private OnboardingTour getTour(String id) {
        BaseItem item = this.knowledgeRepository.loadHub().getItemById(id);
        if (item == null) {
            throw new IllegalArgumentException(MessageFormat.format(OnboardingMessageConstants.ERROR_TOUR_NOT_FOUND_BY_ID, id));
        }
        if (!(item instanceof OnboardingTour)) {
            throw new IllegalArgumentException(MessageFormat.format(OnboardingMessageConstants.ERROR_ITEM_IS_NOT_A_TOUR, id));
        }
        return (OnboardingTour)item;
    }

    private void handleException(Exception e, String description) {
        LoggerSingleton.logError((Throwable)e);
        this.knowledgeController.showErrorDialog((Throwable)e, description);
    }

    private void tourCompletedHandler(OnboardingTourCompletedEvent event) throws UnsupportedEncodingException {
        OnboardingTour tour = event.getTour();
        OnboardingTourProgress progress = event.getProgress();
        this.updateProgress(tour, progress, false);
    }

    private void tourStartedHandler(OnboardingTourStartedEvent event) throws UnsupportedEncodingException {
        OnboardingTour tour = event.getTour();
        OnboardingTourProgress progress = new OnboardingTourProgress(tour.getId(), 0, 0, new ArrayList());
        this.updateProgress(tour, progress, true);
    }

    private void stepCompletedHandler(OnboardingStepCompletedEvent event) throws UnsupportedEncodingException {
        OnboardingTour tour = event.getTour();
        OnboardingTourProgress progress = event.getProgress();
        this.updateProgress(tour, progress, true);
    }

    private void navigateBackHandler(String id) throws UnsupportedEncodingException {
        OnboardingTourItem tourItem = OnboardingTourItem.fromTourId((String)id);
        if (tourItem == null) {
            return;
        }
        switch (tourItem) {
            case WEB_RECORDING_TOUR: {
                this.openOverviewHandler();
                break;
            }
            case TEST_SUITE_EXECUTOR_TOUR: {
                OnboardingTourProgress previousTourProgress = this.tourRepository.getProgressById(OnboardingTourItem.WEB_RECORDING_TOUR.getTourId());
                OnboardingTour previousTour = this.getTour(OnboardingTourItem.WEB_RECORDING_TOUR.getTourId());
                this.updateProgress(previousTour, previousTourProgress, false);
                break;
            }
        }
    }

    private void openOverviewHandler() throws UnsupportedEncodingException {
        this.navigationHistory.clear();
        String knowledgeHubJson = this.knowledgeRepository.loadHub().toJson();
        String progressJson = this.tourRepository.getAllProgressAsJson();
        this.part.openOverview(knowledgeHubJson, progressJson);
    }

    private void tourTerminatedHandler(OnboardingTourTerminatedEvent event) throws UnsupportedEncodingException {
        OnboardingTour tour = event.getTour();
        OnboardingTourProgress progress = this.tourRepository.getProgressById(tour.getId());
        this.updateProgress(tour, progress, false);
    }

    private void updateProgress(OnboardingTour tour, OnboardingTourProgress progress, boolean isRunning) throws UnsupportedEncodingException {
        this.part.updateProgress(tour, progress, isRunning);
    }

    private void handleOnboardingTourItem(OnboardingTour tour) throws UnsupportedEncodingException {
        OnboardingTourProgress progress = this.tourRepository.getProgressById(tour.getId());
        OnboardingTourItem tourItem = OnboardingTourItem.fromTourId((String)tour.getId());
        if (tourItem == null) {
            return;
        }
        switch (tourItem) {
            case TEST_SUITE_EXECUTOR_TOUR: {
                if (progress.getPercentage() != 0) {
                    this.updateProgress(tour, progress, false);
                    break;
                }
                TestSuiteExecutorStartTourDialog dialog = (TestSuiteExecutorStartTourDialog)((Object)ContextInjectionFactory.make(TestSuiteExecutorStartTourDialog.class, (IEclipseContext)this.context));
                dialog.setTour(tour);
                dialog.open();
                break;
            }
            case WEB_RECORDING_TOUR: {
                this.knowledgeController.startTour(tour);
                break;
            }
        }
    }

    private void pushToHistory() {
        String currentUrl = this.part.getCurrentUrl();
        if (currentUrl != null && !currentUrl.isEmpty()) {
            this.navigationHistory.offerLast(currentUrl);
        }
    }
}

