/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.domain.repository;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.core.domain.repository.IOnboardingPreferencesRepository;
import com.kms.katalon.onboarding.core.domain.repository.entity.OnboardingPreferences;
import jakarta.inject.Singleton;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class OnboardingPreferencesRepository
implements IOnboardingPreferencesRepository {
    private static final String ONBOARDING_PREFERENCES_FILE = GlobalStringConstants.ONBOARDING_FOLDER_PATH + File.separator + "onboardingPreferences.json";
    private OnboardingPreferences currentUserPreferences;

    public OnboardingPreferencesRepository() {
        this.initialize();
    }

    private void initialize() {
        this.loadPreferences();
    }

    public OnboardingPreferences getPreferences() {
        String currentUserEmail = ApplicationContext.getInstance().getUserId();
        if (currentUserEmail == null || currentUserEmail.isEmpty()) {
            return this.createDefaultPreferences();
        }
        this.loadPreferences();
        if (this.currentUserPreferences == null) {
            return this.createDefaultPreferences();
        }
        return this.currentUserPreferences;
    }

    public void savePreferences(OnboardingPreferences preferences) {
        if (preferences == null) {
            return;
        }
        this.currentUserPreferences = preferences;
        this.savePreferencesToFile();
    }

    private void loadPreferences() {
        try {
            OnboardingPreferences preferences;
            JsonNode preferencesNode;
            String currentUserEmail;
            File preferencesFile = new File(ONBOARDING_PREFERENCES_FILE);
            this.currentUserPreferences = this.createDefaultPreferences();
            if (!preferencesFile.exists()) {
                return;
            }
            ObjectMapper mapper = OnboardingPreferencesRepository.createObjectMapper();
            JsonNode rootNode = mapper.readTree(preferencesFile);
            if (rootNode.has(currentUserEmail = ApplicationContext.getInstance().getUserId()) && (preferencesNode = rootNode.get(currentUserEmail)).isObject() && (preferences = (OnboardingPreferences)mapper.readValue(preferencesNode.toString(), OnboardingPreferences.class)) != null) {
                this.currentUserPreferences = preferences;
            }
        }
        catch (Exception exception) {
            this.currentUserPreferences = this.createDefaultPreferences();
            LoggerSingleton.logWarn((String)MessageFormat.format(OnboardingMessageConstants.ERROR_FAILED_TO_LOAD_TOUR_PROGRESS, "onboarding preferences"));
        }
    }

    private void savePreferencesToFile() {
        try {
            JsonNode existingNode;
            if (this.currentUserPreferences == null) {
                return;
            }
            File preferencesFile = new File(ONBOARDING_PREFERENCES_FILE);
            File parentDir = preferencesFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            ObjectMapper mapper = OnboardingPreferencesRepository.createObjectMapper();
            ObjectNode rootNode = mapper.createObjectNode();
            if (preferencesFile.exists() && (existingNode = mapper.readTree(preferencesFile)).isObject()) {
                rootNode = (ObjectNode)existingNode;
            }
            String currentUserEmail = ApplicationContext.getInstance().getUserId();
            ObjectNode preferencesNode = (ObjectNode)mapper.valueToTree((Object)this.currentUserPreferences);
            rootNode.set(currentUserEmail, (JsonNode)preferencesNode);
            mapper.writerWithDefaultPrettyPrinter().writeValue(preferencesFile, (Object)rootNode);
        }
        catch (Exception e) {
            LoggerSingleton.logError((String)MessageFormat.format(OnboardingMessageConstants.ERROR_FAILED_TO_SAVE_TOUR_PROGRESS, "onboarding preferences: " + e.getMessage()));
        }
    }

    private OnboardingPreferences createDefaultPreferences() {
        return new OnboardingPreferences();
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        return mapper;
    }
}

