/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.domain.repository;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTourProgress;
import com.kms.katalon.onboarding.core.domain.repository.ITourRepository;
import jakarta.inject.Singleton;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class TourRepository
implements ITourRepository {
    private static final String TOUR_PROGRESS_FILE = GlobalStringConstants.ONBOARDING_FOLDER_PATH + File.separator + "tourProgress.json";
    private List<OnboardingTourProgress> currentUserProgressList;

    public TourRepository() {
        this.initialize();
    }

    private void initialize() {
        this.loadTourProgress();
    }

    public List<OnboardingTourProgress> getAllTourProgress() {
        this.loadTourProgress();
        if (this.currentUserProgressList == null) {
            return new ArrayList<OnboardingTourProgress>();
        }
        return new ArrayList<OnboardingTourProgress>(this.currentUserProgressList);
    }

    public OnboardingTourProgress getProgressById(String tourId) {
        if (tourId == null || tourId.isEmpty()) {
            return null;
        }
        List<OnboardingTourProgress> progressList = this.getAllTourProgress();
        for (OnboardingTourProgress progress : progressList) {
            if (!tourId.equals(progress.getTourId())) continue;
            return progress;
        }
        return this.createDefaultOnBoardingProgress(tourId);
    }

    public void updateProgress(OnboardingTourProgress progress) {
        this.loadTourProgress();
        if (this.currentUserProgressList == null) {
            this.currentUserProgressList = new ArrayList<OnboardingTourProgress>();
        }
        boolean found = false;
        int i = 0;
        while (i < this.currentUserProgressList.size()) {
            OnboardingTourProgress existingProgress = this.currentUserProgressList.get(i);
            if (existingProgress.getTourId().equals(progress.getTourId())) {
                this.currentUserProgressList.set(i, progress);
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            this.currentUserProgressList.add(progress);
        }
        this.saveTourProgress();
    }

    public List<OnboardingTourProgress> getAllProgress() {
        return this.getAllTourProgress();
    }

    public String getAllProgressAsJson() {
        List<OnboardingTourProgress> progressList = this.getAllTourProgress();
        return this.progressListToJson(progressList);
    }

    public String progressListToJson(List<OnboardingTourProgress> progressList) {
        try {
            return TourRepository.createObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(progressList);
        }
        catch (Exception e) {
            LoggerSingleton.logError((String)("Failed to serialize progress list: " + e.getMessage()));
            return "[]";
        }
    }

    private void loadTourProgress() {
        try {
            List progressList;
            JsonNode progressArray;
            String currentUserEmail;
            File progressFile = new File(TOUR_PROGRESS_FILE);
            this.currentUserProgressList = new ArrayList<OnboardingTourProgress>();
            if (!progressFile.exists()) {
                return;
            }
            ObjectMapper mapper = TourRepository.createObjectMapper();
            JsonNode rootNode = mapper.readTree(progressFile);
            if (rootNode.has(currentUserEmail = ApplicationContext.getInstance().getUserId()) && (progressArray = rootNode.get(currentUserEmail)).isArray() && (progressList = (List)mapper.readValue(progressArray.toString(), (TypeReference)new TypeReference<List<OnboardingTourProgress>>(){})) != null) {
                this.currentUserProgressList = progressList;
            }
        }
        catch (Exception exception) {
            this.currentUserProgressList = new ArrayList<OnboardingTourProgress>();
            LoggerSingleton.logWarn((String)OnboardingMessageConstants.ERROR_FAILED_TO_LOAD_TOUR_PROGRESS);
        }
    }

    private void saveTourProgress() {
        try {
            JsonNode existingNode;
            if (this.currentUserProgressList == null) {
                return;
            }
            File progressFile = new File(TOUR_PROGRESS_FILE);
            File parentDir = progressFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            ObjectMapper mapper = TourRepository.createObjectMapper();
            ObjectNode rootNode = mapper.createObjectNode();
            if (progressFile.exists() && (existingNode = mapper.readTree(progressFile)).isObject()) {
                rootNode = (ObjectNode)existingNode;
            }
            String currentUserEmail = ApplicationContext.getInstance().getUserId();
            ArrayNode progressArrayNode = (ArrayNode)mapper.valueToTree(this.currentUserProgressList);
            rootNode.set(currentUserEmail, (JsonNode)progressArrayNode);
            mapper.writerWithDefaultPrettyPrinter().writeValue(progressFile, (Object)rootNode);
        }
        catch (Exception e) {
            LoggerSingleton.logError((String)MessageFormat.format(OnboardingMessageConstants.ERROR_FAILED_TO_SAVE_TOUR_PROGRESS, e));
        }
    }

    private OnboardingTourProgress createDefaultOnBoardingProgress(String tourId) {
        return new OnboardingTourProgress(tourId, 0, 0, new ArrayList());
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        return mapper;
    }
}

