/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.onboardingtour;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.helpers.KatalonPartHelper;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTour;
import com.kms.katalon.onboarding.domain.tour.NativeStepHandler;
import com.kms.katalon.onboarding.domain.tour.OverlayManager;
import com.kms.katalon.onboarding.domain.tour.StepGroupHandler;
import com.kms.katalon.onboarding.domain.tour.StepHandler;
import com.kms.katalon.onboarding.domain.tour.TourHandler;
import com.kms.katalon.onboarding.presentation.popover.NativePopoverHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.openqa.selenium.Platform;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteExecutorTour
extends TourHandler {
    private volatile boolean isProjectLoadClass;
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteExecutorTour.class);
    private static final int REQUIRED_TEST_CASES_SELECTION = 2;
    private static final int DIALOG_POSITION_Y_OFFSET = 20;
    private static final long LAUNCHER_START_DELAY_MS = 5000L;
    private static final long LAUNCHER_STATUS_CHECK_INTERVAL_MS = 1000L;
    private static final long FIRST_STEP_DELAY_MS = 30000L;
    private static final long WAIT_FOR_EXECUTION_COMPLETE_TIMEOUT = 0L;
    private final IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    private OverlayManager overlayManager = new OverlayManager(this::cleanup);

    public TestSuiteExecutorTour(OnboardingTour tour) {
        super(tour);
        this.create();
        this.subscribeProjectOpenedEvent();
    }

    private void subscribeProjectOpenedEvent() {
        this.eventBroker.subscribe("PROJECT/LOAD_CLASS", new EventHandler(){

            public void handleEvent(Event event) {
                TestSuiteExecutorTour.this.expandTestCaseFolder();
                TestSuiteExecutorTour.this.isProjectLoadClass = true;
                TestSuiteExecutorTour.this.eventBroker.unsubscribe((EventHandler)this);
            }
        });
    }

    private void expandTestCaseFolder() {
        try {
            ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
            FolderTreeEntity testCaseFolder = TreeEntityUtil.getTestCaseFolderTreeEntity((ProjectEntity)projectEntity);
            this.eventBroker.post("EXPLORER/EXPAND_TREE_ENTITY", (Object)testCaseFolder);
        }
        catch (Exception e) {
            logger.error("Failed to expand test case folder", (Throwable)e);
        }
    }

    private void create() {
        StepGroupHandler firstStepGroup = new StepGroupHandler(this, "create-test-suite-and-add-test-case");
        firstStepGroup.addStepHandler(this.getTestCaseOnExplorerStep());
        firstStepGroup.addStepHandler(this.getTestSuiteOnExplorerStep());
        firstStepGroup.addStepHandler(this.getCreateNewTestSuiteStep());
        firstStepGroup.addStepHandler(this.getAddTestCasesStep());
        firstStepGroup.addStepHandler(this.getSelectTestCasesStep());
        firstStepGroup.addStepHandler(this.getSaveTestSuiteStep());
        StepGroupHandler secondStepGroup = new StepGroupHandler(this, "run-test-suite-and-view-result");
        secondStepGroup.addStepHandler(this.getRunTestCaseStep());
        secondStepGroup.addStepHandler(this.getWaitForExecutionStep());
        secondStepGroup.addStepHandler(this.getIntroduceLogViewerStep());
        StepGroupHandler thirdStepGroup = new StepGroupHandler(this, "review-test-report");
        thirdStepGroup.addStepHandler(this.getIntroduceTestSuiteResultStep());
        thirdStepGroup.addStepHandler(this.getIntroduceExportReportStep());
        thirdStepGroup.addStepHandler(this.getReportOnExplorerStep());
        this.addStepGroupHandler(firstStepGroup);
        this.addStepGroupHandler(secondStepGroup);
        this.addStepGroupHandler(thirdStepGroup);
    }

    private StepHandler getTestCaseOnExplorerStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("introduce_test_case_on_explorer");
        stepInfo.description = OnboardingMessageConstants.TEST_SUITE_TOUR_INTRODUCE_TEST_CASE_ON_EXPLORER_DESCRIPTION;
        stepInfo.beforeStep = () -> {
            if (this.overlayManager.isOverlayDisposed()) {
                this.overlayManager.getOrCreateOverlay();
                this.overlayManager.openOverlay();
            }
            nativeStepHandler.overlay = this.overlayManager.getCurrentOverlay();
            nativeStepHandler.parentOverlay = this.overlayManager.getCurrentOverlay();
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> {
            Tree explorerTreeView;
            block3: {
                try {
                    Composite explorerWidget = (Composite)KatalonPartHelper.getExplorerPartStack().getWidget();
                    explorerTreeView = (Tree)ComponentFinder.findByType((Widget)explorerWidget, Tree.class);
                    if (explorerTreeView != null) break block3;
                    return null;
                }
                catch (Exception e) {
                    logger.error(OnboardingMessageConstants.TEST_SUITE_TOUR_FAILED_TO_FIND_TEST_CASE_MENU, (Throwable)e);
                    stepInfo.error(e);
                    return null;
                }
            }
            return ComponentFinder.findByTypeAndText((Widget)explorerTreeView, TreeItem.class, (String)StringConstants.ROOT_FOLDER_NAME_TEST_CASE);
        };
        stepInfo.nextable = true;
        stepInfo.keepTarget = true;
        stepInfo.findElementTimeoutMs = 30000L;
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.waitToStart = args -> this.isProjectLoadClass;
        stepInfo.keepOverlay = true;
        stepInfo.position = 16384;
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle targetArea = (Rectangle)args[1];
            return new Point(targetArea.x + targetArea.width + 10, targetArea.y + ComponentUtil.getTabNavHeight() - 20);
        };
        return stepInfo;
    }

    private StepHandler getTestSuiteOnExplorerStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("introduce_test_suite_on_explorer");
        stepInfo.description = OnboardingMessageConstants.TEST_SUITE_TOUR_INTRODUCE_TEST_SUITE_ON_EXPLORER_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.beforeStep = () -> {
            nativeStepHandler.overlay = this.overlayManager.getCurrentOverlay();
            nativeStepHandler.parentOverlay = this.overlayManager.getCurrentOverlay();
        };
        stepInfo.targetFinder = mainShell -> {
            Tree explorerTreeView;
            block3: {
                try {
                    Composite explorerWidget = (Composite)KatalonPartHelper.getExplorerPartStack().getWidget();
                    explorerTreeView = (Tree)ComponentFinder.findByType((Widget)explorerWidget, Tree.class);
                    if (explorerTreeView != null) break block3;
                    return null;
                }
                catch (Exception e) {
                    logger.error(OnboardingMessageConstants.TEST_SUITE_TOUR_FAILED_TO_FIND_TEST_SUITE_MENU, (Throwable)e);
                    stepInfo.error(e);
                    return null;
                }
            }
            return ComponentFinder.findByTypeAndText((Widget)explorerTreeView, TreeItem.class, (String)StringConstants.ROOT_FOLDER_NAME_TEST_SUITE);
        };
        stepInfo.keepTarget = true;
        stepInfo.position = 16384;
        stepInfo.keepOverlay = true;
        stepInfo.onTargetInteractionObserver = () -> this.waitForNewTestSuiteDialog(stepInfo);
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle targetArea = (Rectangle)args[1];
            return new Point(targetArea.x + targetArea.width + 10, targetArea.y + ComponentUtil.getTabNavHeight() - 30);
        };
        return stepInfo;
    }

    private void waitForNewTestSuiteDialog(NativeStepHandler stepInfo) {
        AtomicReference newDialogRef = new AtomicReference();
        UITimeUtil.waitFor(timer -> {
            Shell dialog = ShellManager.getNewDialog();
            newDialogRef.set(dialog);
            return dialog != null && !dialog.isDisposed();
        }, () -> {
            Shell newDialog = (Shell)newDialogRef.get();
            if ((newDialog == null || newDialog.isDisposed() || ComponentFinder.findByTypeAndText((Widget)newDialog, Text.class, (String)"Create Test Suite") == null) && NativePopoverHandler.stepInfoPopover != null && !NativePopoverHandler.stepInfoPopover.isDisposed()) {
                NativePopoverHandler.stepInfoPopover.setReturnCode(12);
                if (NativePopoverHandler.stepInfoPopover.getBeforeClose() != null) {
                    boolean shouldContinueTour;
                    boolean bl = shouldContinueTour = !NativePopoverHandler.stepInfoPopover.getBeforeClose().call();
                    if (shouldContinueTour) {
                        if (newDialog != null && !newDialog.isDisposed()) {
                            newDialog.close();
                        }
                        this.waitForNewTestSuiteDialog(stepInfo);
                        return;
                    }
                    NativePopoverHandler.stepInfoPopover.close();
                    return;
                }
            }
            if (!nativeStepHandler.isDisposed) {
                stepInfo.cleanup();
            }
        }, () -> stepInfo.error(new Exception()), (long)0L, (long)300L);
    }

    private StepHandler getCreateNewTestSuiteStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("create_new_test_suite");
        stepInfo.description = OnboardingMessageConstants.TEST_SUITE_TOUR_CREATE_NEW_TEST_SUITE_DESCRIPTION;
        stepInfo.beforeStep = () -> {
            nativeStepHandler.parentOverlay = this.overlayManager.getCurrentOverlay();
        };
        stepInfo.keepOverlay = false;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.dialogFinder = timer -> ShellManager.getTestSuiteSavingDialog();
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)GlobalMessageConstants.DIA_OK);
        return stepInfo;
    }

    private StepHandler getAddTestCasesStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("add_test_cases");
        stepInfo.description = OnboardingMessageConstants.TEST_SUITE_TOUR_ADD_TEST_CASES_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> {
            Composite editorWidget = (Composite)KatalonPartHelper.getEditorPartStack().getWidget();
            return ComponentFinder.findByTypeAndText((Widget)editorWidget, ToolItem.class, (String)"Add");
        };
        stepInfo.beforeStep = () -> {
            nativeStepHandler.overlay = this.overlayManager.getCurrentOverlay();
            nativeStepHandler.parentOverlay = this.overlayManager.getCurrentOverlay();
        };
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.position = 17408;
        stepInfo.keepOverlay = true;
        stepInfo.onTargetInteractionObserver = () -> UITimeUtil.waitFor(timer -> {
            Shell testCaseBrowserDialog = ShellManager.getTestCaseBrowserDialog();
            return testCaseBrowserDialog != null && !testCaseBrowserDialog.isDisposed();
        }, () -> {
            if (!nativeStepHandler.isDisposed) {
                stepInfo.cleanup();
            }
        }, () -> stepInfo.error(new Exception()), (long)0L, (long)300L);
        return stepInfo;
    }

    private StepHandler getSelectTestCasesStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("select_test_cases");
        stepInfo.description = OnboardingMessageConstants.TEST_SUITE_TOUR_SELECT_TEST_CASES_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getTestCaseBrowserDialog();
        stepInfo.targetFinder = dialog -> ComponentFinder.findByType((Widget)dialog, Tree.class);
        stepInfo.beforeStep = () -> {
            nativeStepHandler.parentOverlay = this.overlayManager.getCurrentOverlay();
        };
        stepInfo.onTargetInteractionObserver = () -> UITimeUtil.waitFor(timer -> {
            Shell testCaseBrowserDialog = ShellManager.getTestCaseBrowserDialog();
            if (testCaseBrowserDialog == null || testCaseBrowserDialog.isDisposed()) {
                return false;
            }
            Tree testCaseTreeView = (Tree)ComponentFinder.findByType((Widget)testCaseBrowserDialog, Tree.class);
            if (testCaseTreeView == null) {
                return false;
            }
            List testCaseItems = ComponentFinder.findAllByType((Widget)testCaseTreeView, TreeItem.class);
            int selectedTestCases = 0;
            for (TreeItem testCase : testCaseItems) {
                if (!testCase.getChecked()) continue;
                ++selectedTestCases;
            }
            return selectedTestCases == 2;
        }, () -> {
            if (!nativeStepHandler.isDisposed) {
                stepInfo.cleanup();
            }
        }, () -> stepInfo.error(new Exception()), (long)0L, (long)300L);
        stepInfo.marginLeftXButton = 10;
        stepInfo.keepOverlay = false;
        stepInfo.position = 131072;
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle targetArea = (Rectangle)args[1];
            return new Point(targetArea.x - 10, targetArea.y + 20);
        };
        return stepInfo;
    }

    private StepHandler getSaveTestSuiteStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("save_test_suite");
        stepInfo.description = OnboardingMessageConstants.TEST_SUITE_TOUR_SAVE_TEST_SUITE_DESCRIPTION;
        stepInfo.beforeStep = () -> {
            nativeStepHandler.parentOverlay = this.overlayManager.getCurrentOverlay();
        };
        stepInfo.dialogFinder = timer -> ShellManager.getTestCaseBrowserDialog();
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)GlobalMessageConstants.DIA_OK);
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.position = 132096;
        stepInfo.keepOverlay = true;
        return stepInfo;
    }

    private StepHandler getRunTestCaseStep() {
        String findingText = Platform.getCurrent().is(Platform.WINDOWS) ? "Run (Ctrl + Shift + A)" : "Run (Command + Shift + A)";
        NativeStepHandler stepInfo = new NativeStepHandler("run_test_suite");
        stepInfo.description = OnboardingMessageConstants.TEST_SUITE_TOUR_RUN_TEST_SUITE_DESCRIPTION;
        stepInfo.beforeStep = () -> {
            if (this.overlayManager.isOverlayDisposed()) {
                this.overlayManager.getOrCreateOverlay();
                this.overlayManager.openOverlay();
            }
            nativeStepHandler.overlay = this.overlayManager.getCurrentOverlay();
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByTypeAndText((Widget)mainShell, ToolItem.class, (String)findingText);
        stepInfo.keepOverlay = true;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.iconPath = "toolbar/play_24@2x.png";
        stepInfo.customClickHandler = event -> {
            if (event.detail == 4) {
                Shell shell = ShellManager.getMainShell();
                Widget item = ComponentFinder.findByTypeAndText((Widget)shell, ToolItem.class, (String)findingText);
                Menu runMenu = (Menu)ComponentFinder.findByTypeAndText((Widget)item, Menu.class, (String)"Run");
                runMenu.setVisible(false);
            }
        };
        return stepInfo;
    }

    private StepHandler getWaitForExecutionStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("wait_for_execution");
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.beforeStep = () -> {
            nativeStepHandler.parentOverlay = this.overlayManager.getCurrentOverlay();
        };
        stepInfo.keepOverlay = false;
        stepInfo.mainScript = () -> UITimeUtil.setTimeout(() -> UITimeUtil.waitFor(timer -> !LauncherManager.getInstance().isAnyLauncherRunning(), stepInfo::completeStep, (long)0L, (long)1000L), (long)5000L);
        return stepInfo;
    }

    private StepHandler getIntroduceLogViewerStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("introduce_log_viewer");
        stepInfo.description = OnboardingMessageConstants.TEST_SUITE_TOUR_INTRODUCE_LOG_VIEWER_DESCRIPTION;
        stepInfo.beforeStep = () -> {
            nativeStepHandler.parentOverlay = this.overlayManager.getCurrentOverlay();
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> {
            if (mainShell == null || mainShell.isDisposed()) {
                return null;
            }
            ArrayList tabItems = new ArrayList();
            Display.getDefault().syncExec(() -> {
                if (!mainShell.isDisposed()) {
                    tabItems.addAll(ComponentFinder.findAllByType((Widget)mainShell, CTabFolder.class).stream().filter(Objects::nonNull).filter(folder -> !folder.isDisposed()).flatMap(folder -> Arrays.stream(folder.getItems())).filter(Objects::nonNull).filter(item -> !item.isDisposed() && "Log Viewer".equals(item.getText())).toList());
                }
            });
            return tabItems.isEmpty() ? null : (Widget)tabItems.get(0);
        };
        stepInfo.nextable = true;
        return stepInfo;
    }

    private StepHandler getIntroduceTestSuiteResultStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("introduce_test_suite_result");
        stepInfo.description = OnboardingMessageConstants.TEST_SUITE_TOUR_INTRODUCE_TEST_SUITE_RESULT_DESCRIPTION;
        stepInfo.beforeStep = () -> {
            nativeStepHandler.overlay = this.overlayManager.getCurrentOverlay();
        };
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> {
            if (mainShell == null || mainShell.isDisposed()) {
                return null;
            }
            ArrayList tabItems = new ArrayList();
            Display.getDefault().syncExec(() -> {
                if (!mainShell.isDisposed()) {
                    tabItems.addAll(ComponentFinder.findAllByType((Widget)mainShell, CTabFolder.class).stream().filter(Objects::nonNull).filter(folder -> !folder.isDisposed()).flatMap(folder -> Arrays.stream(folder.getItems())).filter(Objects::nonNull).filter(item -> !item.isDisposed() && "Result".equals(item.getText())).toList());
                }
            });
            return tabItems.isEmpty() ? null : (Widget)tabItems.get(0);
        };
        stepInfo.keepOverlay = false;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.position = 128;
        return stepInfo;
    }

    private StepHandler getIntroduceExportReportStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("introduce_export_report");
        stepInfo.description = OnboardingMessageConstants.TEST_SUITE_TOUR_INTRODUCE_EXPORT_REPORT_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = this::findExportReportToolItem;
        stepInfo.beforeStep = () -> {
            nativeStepHandler.parentOverlay = this.overlayManager.getCurrentOverlay();
            UISynchronizeService.asyncExec(() -> {
                ToolItem exportReportItem = this.findExportReportToolItem(ShellManager.getMainShell());
                if (exportReportItem != null) {
                    exportReportItem.setEnabled(false);
                }
            });
        };
        stepInfo.afterStep = () -> UISynchronizeService.asyncExec(() -> {
            ToolItem exportReportItem = this.findExportReportToolItem(ShellManager.getMainShell());
            if (exportReportItem != null) {
                exportReportItem.setEnabled(true);
            }
        });
        stepInfo.nextable = true;
        stepInfo.keepOverlay = false;
        stepInfo.position = 132096;
        return stepInfo;
    }

    private StepHandler getReportOnExplorerStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("introduce_report_on_explorer");
        stepInfo.description = OnboardingMessageConstants.TEST_SUITE_TOUR_INTRODUCE_REPORT_ON_EXPLORER_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.beforeStep = () -> {
            nativeStepHandler.parentOverlay = this.overlayManager.getCurrentOverlay();
        };
        stepInfo.targetFinder = mainShell -> {
            Tree explorerTreeView;
            block3: {
                try {
                    Composite explorerWidget = (Composite)KatalonPartHelper.getExplorerPartStack().getWidget();
                    explorerTreeView = (Tree)ComponentFinder.findByType((Widget)explorerWidget, Tree.class);
                    if (explorerTreeView != null) break block3;
                    return null;
                }
                catch (Exception e) {
                    stepInfo.error(e);
                    return null;
                }
            }
            return ComponentFinder.findByTypeAndText((Widget)explorerTreeView, TreeItem.class, (String)StringConstants.ROOT_FOLDER_NAME_REPORT);
        };
        stepInfo.useFinishButton = true;
        stepInfo.position = 16384;
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle targetArea = (Rectangle)args[1];
            return new Point(targetArea.x + targetArea.width + 10, targetArea.y + ComponentUtil.getTabNavHeight() - 20);
        };
        return stepInfo;
    }

    private ToolItem findExportReportToolItem(Shell mainShell) {
        if (Display.getCurrent() == null) {
            throw new IllegalStateException("Must be called from UI thread");
        }
        if (mainShell == null || mainShell.isDisposed()) {
            return null;
        }
        return ComponentFinder.findAllByType((Widget)mainShell, ToolBar.class).stream().filter(toolbar -> toolbar != null && !toolbar.isDisposed()).flatMap(toolbar -> Arrays.stream(toolbar.getItems())).filter(item -> item != null && !item.isDisposed() && "Export report".equals(item.getText())).findFirst().orElse(null);
    }

    @Override
    public void cleanup() {
        if (this.overlayManager != null) {
            this.overlayManager.dispose();
        }
    }
}

