/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.onboardingtour;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.overlay.HighlightOverlay;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.helpers.KatalonPartHelper;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.preferences.TestCasePreferenceDefaultValueInitializer;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.objectspy.core.InspectSession;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTour;
import com.kms.katalon.onboarding.domain.tour.NativeStepHandler;
import com.kms.katalon.onboarding.domain.tour.StepGroupHandler;
import com.kms.katalon.onboarding.domain.tour.StepHandler;
import com.kms.katalon.onboarding.domain.tour.TourHandler;
import com.kms.katalon.onboarding.domain.tour.WebStepHandler;
import com.kms.katalon.onboarding.presentation.popover.WebPopoverBuilder;
import com.kms.katalon.onboarding.presentation.popover.WebPopoverHandler;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.openqa.selenium.Platform;

public class WebRecordingTour
extends TourHandler {
    private HighlightOverlay mainOverlay;
    private HighlightOverlay recorderOverlay;
    private Shell recorderDialogShell;
    private static final String STOP_RECORDING = "Stop recording";
    private static final long FIRST_STEP_DELAY_MS = 30000L;

    public WebRecordingTour(OnboardingTour tour) {
        super(tour);
        this.create();
        this.subcribeRecordSession();
    }

    private void create() {
        StepGroupHandler firstStepGroup = new StepGroupHandler(this, "create-test-case");
        StepGroupHandler secondStepGroup = new StepGroupHandler(this, "explore-test");
        StepGroupHandler thirdStepGroup = new StepGroupHandler(this, "run-test");
        firstStepGroup.addStepHandler(this.getClickWebRecordButtonStep());
        firstStepGroup.addStepHandler(this.getClickRecordButtonStep());
        firstStepGroup.addStepHandler(this.getWaitBrowserLaunchStep());
        firstStepGroup.addStepHandler(this.getClickMakeAppointmentButtonStep());
        firstStepGroup.addStepHandler(this.getIntroduceRecordActionsStep());
        firstStepGroup.addStepHandler(this.getInputUsernameStep());
        firstStepGroup.addStepHandler(this.getInputPasswordStep());
        firstStepGroup.addStepHandler(this.getClickLoginButtonStep());
        firstStepGroup.addStepHandler(this.getClickCalendarButtonStep());
        firstStepGroup.addStepHandler(this.getChooseAppointmentDateStep());
        firstStepGroup.addStepHandler(this.getClickBookAppointmentButtonStep());
        firstStepGroup.addStepHandler(this.getClickStopRecorderButtonStep());
        firstStepGroup.addStepHandler(this.getSaveRecordedSessionStep());
        firstStepGroup.addStepHandler(this.getSaveRecorderObjectStep());
        firstStepGroup.addStepHandler(this.getSaveTestCaseStep());
        secondStepGroup.addStepHandler(this.getIntroduceEditorStep());
        secondStepGroup.addStepHandler(this.getIntroduceExplorerStep());
        String defaultStartView = PreferenceStoreManager.getPreferenceStore(TestCasePreferenceDefaultValueInitializer.class).getString("default.startView");
        if (StringUtils.equals((String)defaultStartView, (String)TestCaseCompositePart.MANUAL_TAB_TITLE)) {
            secondStepGroup.addStepHandler(this.getIntroduceScriptTabStep());
            secondStepGroup.addStepHandler(this.getIntroduceManualTabStep());
        } else {
            secondStepGroup.addStepHandler(this.getIntroduceManualTabStep());
            secondStepGroup.addStepHandler(this.getIntroduceScriptTabStep());
        }
        thirdStepGroup.addStepHandler(this.getRunTestCaseStep());
        thirdStepGroup.addStepHandler(this.getWaitForExecutionStep());
        thirdStepGroup.addStepHandler(this.getIntroduceLogViewerStep());
        this.addStepGroupHandler(firstStepGroup);
        this.addStepGroupHandler(secondStepGroup);
        this.addStepGroupHandler(thirdStepGroup);
    }

    private void subcribeRecordSession() {
        IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        eventBroker.subscribe("RECORDER/SESSION_CREATED", event -> {
            Object data = event.getProperty("org.eclipse.e4.data");
            if (data instanceof InspectSession) {
                WebPopoverHandler.recordSession = (InspectSession)data;
            }
        });
    }

    private HighlightOverlay createOverlay() {
        HighlightOverlay overlay = new HighlightOverlay((Control)ShellManager.getMainShell());
        overlay.setAlpha(20);
        ComponentEventUtil.onClick((Widget)overlay, event -> {
            if (event.count == 5) {
                this.cleanup();
            }
        });
        return overlay;
    }

    private StepHandler getClickWebRecordButtonStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("click_web_record_button");
        stepInfo.description = OnboardingMessageConstants.WEB_TOUR_CLICK_WEB_RECORD_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByTypeAndText((Widget)mainShell, ToolItem.class, (String)"Record Web");
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        stepInfo.iconPath = "toolbar/web_object_record_24@2x.png";
        stepInfo.beforeStep = () -> {
            this.mainOverlay = this.createOverlay();
            this.mainOverlay.open();
            nativeStepHandler.overlay = this.mainOverlay;
            nativeStepHandler.parentOverlay = this.mainOverlay;
        };
        stepInfo.findElementTimeoutMs = 30000L;
        return stepInfo;
    }

    private StepHandler getClickRecordButtonStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("click_record_button");
        stepInfo.description = OnboardingMessageConstants.WEB_TOUR_CLICK_RECORD_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getWebRecorderDialog();
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, ToolItem.class, (String)"Record");
        stepInfo.setupDialog = dialog -> {
            this.recorderDialogShell = dialog;
            DialogUtil.setCanCloseAndClickOK((Shell)dialog, (boolean)false);
        };
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            nativeStepHandler.parentOverlay = this.mainOverlay;
            IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
            eventBroker.post("RECORDER/DIALOG_VIEW_STATE_CHANGED", (Object)true);
            eventBroker.post("RECORDER/DIALOG_BROWSER_CHANGED", (Object)WebUIDriverType.EDGE_CHROMIUM_DRIVER);
            eventBroker.post("RECORDER/DIALOG_URL_CHANGED", (Object)OnboardingMessageConstants.WEB_TOUR_DEMO_URL);
        };
        stepInfo.customClickHandler = event -> {
            if (event.detail == 4) {
                Shell dialog = ShellManager.getWebRecorderDialog();
                Widget item = ComponentFinder.findByTypeAndText((Widget)dialog, ToolItem.class, (String)"Record");
                Menu runMenu = (Menu)ComponentFinder.findByTypeAndText((Widget)item, Menu.class, (String)"Record");
                runMenu.setVisible(false);
            }
        };
        stepInfo.afterStep = () -> {
            this.recorderOverlay = nativeStepHandler.overlay;
        };
        return stepInfo;
    }

    private StepHandler getWaitBrowserLaunchStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("wait_browser_launch");
        stepInfo.mainScript = () -> UITimeUtil.waitForWithTimeout(timer -> WebPopoverHandler.recordSession != null && WebPopoverHandler.recordSession.getWebDriver() != null, () -> UITimeUtil.setTimeout(() -> stepInfo.completeStep(), (long)5000L), () -> stepInfo.error(new Exception(OnboardingMessageConstants.ERROR_TIMEOUT_SESSION_RECORD)), (long)10000L, (long)300L);
        return stepInfo;
    }

    private StepHandler getClickMakeAppointmentButtonStep() {
        WebStepHandler stepInfo = new WebStepHandler("click_make_appointment_button");
        stepInfo.needWaitForAnnimation = true;
        stepInfo.popoverBuilder = new WebPopoverBuilder().withElementId("btn-make-appointment").withLocation(WebPopoverBuilder.PopoverLocation.BOTTOM).withDescription(OnboardingMessageConstants.WEB_TOUR_MAKE_APPOINTMENT_POPOVER_DESCRIPTION);
        return stepInfo;
    }

    private StepHandler getIntroduceRecordActionsStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("introduce_record_actions");
        stepInfo.description = OnboardingMessageConstants.WEB_TOUR_INTRODUCE_RECORD_ACTIONS_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getWebRecorderDialog();
        stepInfo.targetFinder = dialog -> ComponentFinder.findByType((Widget)dialog, Tree.class);
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        stepInfo.nextable = true;
        stepInfo.beforeStep = () -> {
            nativeStepHandler.overlay = this.recorderOverlay;
            nativeStepHandler.parentOverlay = this.mainOverlay;
        };
        stepInfo.position = 131072;
        stepInfo.marginLeftXButton = 13;
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle targetArea = (Rectangle)args[1];
            return new Point(targetArea.x - 8, targetArea.y + 100);
        };
        return stepInfo;
    }

    private StepHandler getInputUsernameStep() {
        WebStepHandler stepInfo = new WebStepHandler("input_username");
        stepInfo.popoverBuilder = new WebPopoverBuilder().withElementId("txt-username").withLocation(WebPopoverBuilder.PopoverLocation.BOTTOM).withDescription(OnboardingMessageConstants.WEB_TOUR_USERNAME_POPOVER_DESCRIPTION).withValidationValue("John Doe");
        return stepInfo;
    }

    private StepHandler getInputPasswordStep() {
        WebStepHandler stepInfo = new WebStepHandler("input_password");
        stepInfo.popoverBuilder = new WebPopoverBuilder().withElementId("txt-password").withLocation(WebPopoverBuilder.PopoverLocation.BOTTOM).withDescription(OnboardingMessageConstants.WEB_TOUR_PASSWORD_POPOVER_DESCRIPTION).withValidationValue("ThisIsNotAPassword");
        return stepInfo;
    }

    private StepHandler getClickLoginButtonStep() {
        WebStepHandler stepInfo = new WebStepHandler("click_login_button");
        stepInfo.popoverBuilder = new WebPopoverBuilder().withElementId("btn-login").withLocation(WebPopoverBuilder.PopoverLocation.RIGHT).withDescription(OnboardingMessageConstants.WEB_TOUR_LOGIN_POPOVER_DESCRIPTION);
        return stepInfo;
    }

    private StepHandler getClickCalendarButtonStep() {
        WebStepHandler stepInfo = new WebStepHandler("click_calendar_button");
        stepInfo.needWaitForAnnimation = true;
        stepInfo.popoverBuilder = new WebPopoverBuilder().withElementClass("input-group-addon").withLocation(WebPopoverBuilder.PopoverLocation.LEFT).withDescription(OnboardingMessageConstants.WEB_TOUR_CALENDAR_POPOVER_DESCRIPTION);
        return stepInfo;
    }

    private StepHandler getChooseAppointmentDateStep() {
        WebStepHandler stepInfo = new WebStepHandler("choose_appointment_date");
        stepInfo.popoverBuilder = new WebPopoverBuilder().withElementClass("day").withLocation(WebPopoverBuilder.PopoverLocation.RIGHT).withDescription(OnboardingMessageConstants.WEB_TOUR_CHOOSE_DATE_POPOVER_DESCRIPTION);
        return stepInfo;
    }

    private StepHandler getClickBookAppointmentButtonStep() {
        WebStepHandler stepInfo = new WebStepHandler("click_book_appointment_button");
        stepInfo.popoverBuilder = new WebPopoverBuilder().withElementId("btn-book-appointment").withLocation(WebPopoverBuilder.PopoverLocation.TOP).withDescription(OnboardingMessageConstants.WEB_TOUR_BOOK_APPOINTMENT_POPOVER_DESCRIPTION);
        return stepInfo;
    }

    private StepHandler getClickStopRecorderButtonStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("click_stop_recorder_button");
        stepInfo.description = OnboardingMessageConstants.WEB_TOUR_CLICK_STOP_RECORDER_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getWebRecorderDialog();
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, ToolItem.class, (String)STOP_RECORDING);
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            nativeStepHandler.overlay = this.recorderOverlay;
            nativeStepHandler.parentOverlay = this.mainOverlay;
        };
        return stepInfo;
    }

    private StepHandler getSaveRecordedSessionStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("save_recorded_session");
        stepInfo.description = OnboardingMessageConstants.WEB_TOUR_SAVE_RECORDED_SESSION_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getWebRecorderDialog();
        stepInfo.setupDialog = dialog -> DialogUtil.setCanClickOK((Shell)dialog, (boolean)true);
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)"Save Script");
        stepInfo.position = 128;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            nativeStepHandler.overlay = this.recorderOverlay;
            nativeStepHandler.parentOverlay = this.mainOverlay;
        };
        return stepInfo;
    }

    private StepHandler getSaveRecorderObjectStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("save_recorder_object");
        stepInfo.description = OnboardingMessageConstants.WEB_TOUR_SAVE_RECORDER_OBJECT_DESCRIPTION;
        stepInfo.dialogFinder = timer -> {
            DialogUtil.setCanClose((Shell)this.recorderDialogShell, (boolean)true);
            Shell testObjectsSavingDialog = ShellManager.getTestObjectsSavingDialog();
            if (testObjectsSavingDialog != null) {
                return testObjectsSavingDialog;
            }
            return null;
        };
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)GlobalMessageConstants.DIA_OK);
        stepInfo.triggerWhenClickTarget = true;
        return stepInfo;
    }

    private StepHandler getSaveTestCaseStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("save_test_case");
        stepInfo.description = OnboardingMessageConstants.WEB_TOUR_SAVE_TEST_CASE_DESCRIPTION;
        stepInfo.dialogFinder = timer -> {
            Shell testCaseSavingDialog = ShellManager.getTestCaseSavingDialog();
            if (testCaseSavingDialog != null) {
                return testCaseSavingDialog;
            }
            return null;
        };
        stepInfo.targetFinder = dialog -> ComponentFinder.findByTypeAndText((Widget)dialog, Button.class, (String)GlobalMessageConstants.DIA_OK);
        stepInfo.triggerWhenClickTarget = true;
        return stepInfo;
    }

    private StepHandler getIntroduceEditorStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("introduce_editor");
        stepInfo.description = OnboardingMessageConstants.WEB_TOUR_INTRODUCE_EDITOR_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> (Composite)KatalonPartHelper.getEditorPartStack().getWidget();
        stepInfo.nextable = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            nativeStepHandler.overlay = this.mainOverlay;
        };
        stepInfo.position = 131072;
        stepInfo.marginLeftXButton = 13;
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle targetArea = (Rectangle)args[1];
            return new Point(targetArea.x - 8, targetArea.y + 100);
        };
        return stepInfo;
    }

    private StepHandler getIntroduceExplorerStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("introduce_explorer");
        stepInfo.description = OnboardingMessageConstants.WEB_TOUR_INTRODUCE_EXPLORER_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> (Composite)KatalonPartHelper.getExplorerPartStack().getWidget();
        stepInfo.nextable = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            nativeStepHandler.overlay = this.mainOverlay;
        };
        stepInfo.position = 16384;
        stepInfo.guidingDialogPositionProvider = (shell, args) -> {
            Rectangle targetArea = (Rectangle)args[1];
            return new Point(targetArea.x + targetArea.width + 8, targetArea.y + ComponentUtil.applyZoom((int)50) + ComponentUtil.getTabNavHeight());
        };
        return stepInfo;
    }

    private StepHandler getIntroduceScriptTabStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("introduce_script_tab");
        stepInfo.description = OnboardingMessageConstants.WEB_TOUR_INTRODUCE_SCRIPT_TAB_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> {
            List allTabFolders = ComponentFinder.findAllByType((Widget)mainShell, CTabFolder.class);
            for (CTabFolder tabFolder : allTabFolders) {
                CTabItem[] cTabItemArray = tabFolder.getItems();
                int n = cTabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem item = cTabItemArray[n2];
                    String text = item.getText();
                    if ("Script".equals(text)) {
                        return item;
                    }
                    ++n2;
                }
            }
            return null;
        };
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            nativeStepHandler.overlay = this.mainOverlay;
        };
        stepInfo.position = 128;
        return stepInfo;
    }

    private StepHandler getIntroduceManualTabStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("introduce_manual_tab");
        stepInfo.description = OnboardingMessageConstants.WEB_TOUR_INTRODUCE_MANUAL_TAB_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> {
            List allTabFolders = ComponentFinder.findAllByType((Widget)mainShell, CTabFolder.class);
            for (CTabFolder tabFolder : allTabFolders) {
                CTabItem[] cTabItemArray = tabFolder.getItems();
                int n = cTabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem item = cTabItemArray[n2];
                    String text = item.getText();
                    if ("Manual".equals(text)) {
                        return item;
                    }
                    ++n2;
                }
            }
            return null;
        };
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            nativeStepHandler.overlay = this.mainOverlay;
        };
        stepInfo.position = 128;
        return stepInfo;
    }

    private StepHandler getRunTestCaseStep() {
        String findingText = Platform.getCurrent().is(Platform.WINDOWS) ? "Run (Ctrl + Shift + A)" : "Run (Command + Shift + A)";
        NativeStepHandler stepInfo = new NativeStepHandler("run_test_case");
        stepInfo.description = OnboardingMessageConstants.WEB_TOUR_RUN_TEST_CASE_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> ComponentFinder.findByTypeAndText((Widget)mainShell, ToolItem.class, (String)findingText);
        stepInfo.keepOverlay = true;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.iconPath = "toolbar/play_24@2x.png";
        stepInfo.beforeStep = () -> {
            nativeStepHandler.overlay = this.mainOverlay;
        };
        stepInfo.customClickHandler = event -> {
            if (event.detail == 4) {
                Shell shell = ShellManager.getMainShell();
                Widget item = ComponentFinder.findByTypeAndText((Widget)shell, ToolItem.class, (String)findingText);
                Menu runMenu = (Menu)ComponentFinder.findByTypeAndText((Widget)item, Menu.class, (String)"Run");
                runMenu.setVisible(false);
            }
        };
        return stepInfo;
    }

    private StepHandler getWaitForExecutionStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("wait_for_execution");
        stepInfo.waitToStartTimeout = 0L;
        stepInfo.mainScript = () -> UITimeUtil.setTimeout(() -> UITimeUtil.waitFor(timer -> LauncherManager.getInstance().isAnyLauncherRunning(), () -> stepInfo.completeStep()), (long)10000L);
        return stepInfo;
    }

    private StepHandler getIntroduceLogViewerStep() {
        NativeStepHandler stepInfo = new NativeStepHandler("introduce_log_viewer");
        stepInfo.description = OnboardingMessageConstants.WEB_TOUR_INTRODUCE_LOG_VIEWER_DESCRIPTION;
        stepInfo.dialogFinder = timer -> ShellManager.getMainShell();
        stepInfo.targetFinder = mainShell -> {
            List allTabFolders = ComponentFinder.findAllByType((Widget)mainShell, CTabFolder.class);
            for (CTabFolder tabFolder : allTabFolders) {
                CTabItem[] cTabItemArray = tabFolder.getItems();
                int n = cTabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem item = cTabItemArray[n2];
                    String text = item.getText();
                    if ("Log Viewer".equals(text)) {
                        return item;
                    }
                    ++n2;
                }
            }
            return null;
        };
        stepInfo.useFinishButton = true;
        stepInfo.triggerWhenClickTarget = true;
        stepInfo.keepOverlay = true;
        stepInfo.beforeStep = () -> {
            nativeStepHandler.overlay = this.mainOverlay;
        };
        return stepInfo;
    }

    @Override
    public void cleanup() {
        Display.getDefault().asyncExec(() -> {
            this.closeOverlaySilently(this.mainOverlay);
            this.closeOverlaySilently(this.recorderOverlay);
        });
    }

    @Override
    public void ensureOnboardingReady() throws Exception {
    }

    private void closeOverlaySilently(HighlightOverlay overlay) {
        if (overlay == null) {
            return;
        }
        try {
            try {
                overlay.close();
                overlay.dispose();
            }
            catch (Exception e) {
                LoggerSingleton.logWarn((String)MessageFormat.format(OnboardingMessageConstants.ERROR_FAILED_TO_DISPOSE_OVERLAY, e));
                overlay = null;
            }
        }
        finally {
            overlay = null;
        }
    }
}

