/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.codeassist.editor;

import com.kms.katalon.composer.codeassist.constant.ComposerCodeAssistMessageConstants;
import com.kms.katalon.composer.codeassist.constant.ImageConstants;
import com.kms.katalon.composer.components.impl.editors.extensions.CodeSelectHelper;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.components.BrowserInformationControlCustom;
import com.kms.katalon.composer.testcase.util.KeywordURLUtil;
import java.lang.reflect.Field;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.eclipse.codebrowsing.elements.GroovyResolvedBinaryMethod;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.CodeSelectRequestor;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.editor.GroovyExtraInformationHover;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;

public class ImprovedGroovyTextEditorHover
extends GroovyExtraInformationHover {
    private KatalonInformationControlCreator katalonInformationControl;
    private static String keywordDescURI = null;

    protected IJavaElement[] getJavaElementsAt(ITextViewer textViewer, IRegion hoverRegion) {
        ICodeAssist codeAssist = this.getCodeAssist();
        if (codeAssist instanceof GroovyCompilationUnit) {
            return new CustomCodeSelectHelper().select((GroovyCompilationUnit)codeAssist, hoverRegion.getOffset(), hoverRegion.getLength());
        }
        return super.getJavaElementsAt(textViewer, hoverRegion);
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        IJavaElement[] elements = this.getJavaElementsAt(textViewer, hoverRegion);
        this.updateCurrentKeyword(elements);
        if (elements == null) {
            return super.getHoverInfo2(textViewer, hoverRegion);
        }
        return JavadocHover.getHoverInfo((IJavaElement[])elements, (ITypeRoot)this.getEditorInputJavaElement(), (IRegion)hoverRegion, null);
    }

    private void updateCurrentKeyword(IJavaElement[] elements) {
        keywordDescURI = null;
        if (elements == null || elements.length != 1 || !(elements[0] instanceof GroovyResolvedBinaryMethod)) {
            return;
        }
        String elementKey = ((GroovyResolvedBinaryMethod)elements[0]).getKey();
        if (elementKey == null) {
            return;
        }
        keywordDescURI = KeywordURLUtil.getKeywordDescriptionURI((String)elementKey);
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.katalonInformationControl == null) {
            this.katalonInformationControl = new KatalonInformationControlCreator();
        }
        return this.katalonInformationControl;
    }

    private class CustomCodeSelectHelper
    extends CodeSelectHelper {
        private CustomCodeSelectHelper() {
        }

        protected CodeSelectRequestor createRequestor(ASTNode node, Region nodeRegion, Region selectRegion, GroovyCompilationUnit unit) {
            return new CodeSelectRequestor(node, unit);
        }
    }

    private class KatalonInformationControlCreator
    implements IInformationControlCreator {
        private KatalonInformationControlCreator() {
        }

        public IInformationControl createInformationControl(Shell parent) {
            String font = "org.eclipse.jdt.ui.javadocfont";
            BrowserInformationControlCustom bi = new BrowserInformationControlCustom(parent, font, ""){

                public IInformationControlCreator getInformationPresenterControlCreator() {
                    return new JavadocHover.PresenterControlCreator(KatalonInformationControlCreator.this.getSite());
                }

                public boolean isResizable() {
                    return true;
                }
            };
            bi.setScrollBarSize((Composite)parent);
            if (keywordDescURI == null) {
                return bi;
            }
            this.addOpenDescKeywordButton(bi);
            return bi;
        }

        private void addOpenDescKeywordButton(BrowserInformationControlCustom bi) {
            try {
                Field f = bi.getClass().getSuperclass().getDeclaredField("fToolBar");
                f.setAccessible(true);
                ToolBar tb = (ToolBar)f.get(bi);
                ToolItem katItem = new ToolItem(tb, 0);
                katItem.setToolTipText(ComposerCodeAssistMessageConstants.KEYWORD_DESC_BUTTON_TOOLTIP);
                katItem.setImage(ImageConstants.IMG_16_KEYWORD_WIKI);
                katItem.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        try {
                            Program.launch((String)keywordDescURI);
                        }
                        catch (Exception ex) {
                            LoggerSingleton.logError((Throwable)ex);
                        }
                    }
                });
            }
            catch (Exception ex) {
                LoggerSingleton.logError((Throwable)ex);
            }
        }

        private IWorkbenchSite getSite() {
            IWorkbenchPage page;
            IEditorPart editor = ImprovedGroovyTextEditorHover.this.getEditor();
            if (editor == null && (page = JavaPlugin.getActivePage()) != null) {
                editor = page.getActiveEditor();
            }
            if (editor != null) {
                return editor.getSite();
            }
            return null;
        }
    }
}

