/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.console;

import io.cucumber.eclipse.editor.console.CucumberConsole;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleManager;

public class CucumberConsoleFactory
implements IConsoleFactory {
    public void openConsole() {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        consoleManager.showConsoleView((IConsole)CucumberConsoleFactory.getConsole(consoleManager, always -> true));
    }

    public static CucumberConsole getConsole(boolean show) {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        CucumberConsole console = CucumberConsoleFactory.getConsole(consoleManager, CucumberConsole::reset);
        if (show) {
            consoleManager.showConsoleView((IConsole)console);
        }
        return console;
    }

    private static CucumberConsole getConsole(IConsoleManager consoleManager, Predicate<CucumberConsole> filter) {
        return Arrays.stream(consoleManager.getConsoles()).filter(c -> "cucumber".equals(c.getType())).filter(CucumberConsole.class::isInstance).map(CucumberConsole.class::cast).filter(filter).findFirst().or(() -> {
            CucumberConsole c = new CucumberConsole();
            consoleManager.addConsoles(new IConsole[]{c});
            return Optional.of(c);
        }).get();
    }
}

