/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.document;

import io.cucumber.gherkin.GherkinDialect;
import java.util.Comparator;
import java.util.Locale;

public class GherkinKeyword {
    public static final Comparator<? super GherkinKeyword> KEY_ORDER = (w1, w2) -> w1.lcKey.compareTo(w2.lcKey);
    private final String key;
    private final Locale locale;
    private final GherkinDialect dialect;
    private final String lcKey;

    GherkinKeyword(String key, Locale locale, GherkinDialect dialect) {
        this.key = key;
        this.locale = locale;
        this.dialect = dialect;
        this.lcKey = key.toLowerCase(locale);
    }

    public String getKey() {
        return this.key;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public GherkinDialect getDialect() {
        return this.dialect;
    }

    public boolean matches(String str) {
        return str.toLowerCase(this.locale).equals(this.lcKey);
    }

    public boolean prefix(String str) {
        return this.lcKey.startsWith(str.toLowerCase(this.locale));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GherkinKeyword other = (GherkinKeyword)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.locale == null ? other.locale != null : !this.locale.equals(other.locale));
    }
}

