/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.steps;

import io.cucumber.eclipse.editor.Activator;
import io.cucumber.eclipse.editor.BuildStorage;
import io.cucumber.eclipse.editor.StorageHelper;
import io.cucumber.eclipse.editor.steps.StepDefinitionsRepository;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class StepDefinitionsStorage
implements BuildStorage<StepDefinitionsRepository> {
    public static final StepDefinitionsStorage INSTANCE = new StepDefinitionsStorage();
    private static final String BUILD_FILE = "cucumber.stepDefinitions.tmp";
    private Map<IProject, StepDefinitionsRepository> stepDefinitionsByProject = new HashMap<IProject, StepDefinitionsRepository>();
    private List<IProject> initializedProjects = new ArrayList<IProject>();

    private StepDefinitionsStorage() {
    }

    @Override
    public StepDefinitionsRepository getOrCreate(IProject project, IProgressMonitor monitor) throws CoreException {
        StepDefinitionsRepository stepDefinitionRepository;
        if (!this.initializedProjects.contains(project)) {
            this.load(project, monitor);
            this.initializedProjects.add(project);
        }
        if ((stepDefinitionRepository = this.stepDefinitionsByProject.get(project)) == null) {
            stepDefinitionRepository = new StepDefinitionsRepository();
            this.add(project, stepDefinitionRepository);
            this.initializedProjects.add(project);
        }
        return stepDefinitionRepository;
    }

    @Override
    public void add(IProject project, StepDefinitionsRepository stepDefinitionsRepository) {
        this.stepDefinitionsByProject.put(project, stepDefinitionsRepository);
    }

    @Override
    public void persist(IProject project, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Persiting step definitions", (int)100);
        StepDefinitionsRepository stepDefinitionsRepository = this.getOrCreate(project, (IProgressMonitor)subMonitor.newChild(10));
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream inputStream = StorageHelper.toStream(stepDefinitionsRepository, (IProgressMonitor)subMonitor.newChild(80));){
                StorageHelper.saveIntoBuildDirectory(BUILD_FILE, project, (IProgressMonitor)subMonitor.newChild(10), inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "io.cucumber.eclipse.editor", e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public void load(IProject project, IProgressMonitor monitor) throws CoreException {
        IFolder outputFolder = StorageHelper.getOutputFolder(project);
        if (!outputFolder.exists()) {
            return;
        }
        IFile buildFile = outputFolder.getFile(BUILD_FILE);
        if (!buildFile.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var6_10 = null;
            try (InputStream inputStream = buildFile.getContents();){
                StepDefinitionsRepository repository = StorageHelper.fromStream(StepDefinitionsRepository.class, inputStream, monitor);
                this.add(project, repository);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RuntimeException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "io.cucumber.eclipse.editor", "loading StepDefinitionStore failed, a full rebuild of the project might be required", (Throwable)e));
            this.add(project, new StepDefinitionsRepository());
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "io.cucumber.eclipse.editor", "loading StepDefinitionStore failed, a full rebuild of the project might be required", (Throwable)e));
            this.add(project, new StepDefinitionsRepository());
        }
        catch (ClassNotFoundException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "io.cucumber.eclipse.editor", "loading StepDefinitionStore failed, a full rebuild of the project might be required", (Throwable)e));
            this.add(project, new StepDefinitionsRepository());
        }
    }
}

