/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.validation;

import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.marker.MarkerFactory;
import io.cucumber.messages.types.ParseError;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;

public class GherkinSyntaxValidator
implements IDocumentSetupParticipant {
    private static ConcurrentMap<IDocument, VerificationJob> jobMap = new ConcurrentHashMap<IDocument, VerificationJob>();

    public void setup(IDocument document) {
        document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                GherkinSyntaxValidator.validate(event.getDocument(), 500, false);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        GherkinSyntaxValidator.validate(document, 0, false);
    }

    public static Job validate(IDocument document) {
        return GherkinSyntaxValidator.validate(document, 0, true);
    }

    private static Job validate(IDocument document, int delay, boolean peristent) {
        return jobMap.compute(document, (key, oldJob) -> {
            if (oldJob != null && !oldJob.peristent) {
                oldJob.cancel();
            }
            VerificationJob verificationJob = new VerificationJob((VerificationJob)((Object)oldJob), document, peristent);
            verificationJob.setUser(false);
            verificationJob.setPriority(50);
            if (delay > 0) {
                verificationJob.schedule(delay);
            } else {
                verificationJob.schedule();
            }
            return verificationJob;
        });
    }

    private static final class VerificationJob
    extends Job {
        private VerificationJob oldJob;
        private IDocument document;
        private boolean peristent;

        public VerificationJob(VerificationJob oldJob, IDocument document, boolean peristent) {
            super("Verify Gherkin Document");
            this.oldJob = oldJob;
            this.document = document;
            this.peristent = peristent;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IResource resource;
            GherkinEditorDocument editorDocument;
            if (this.oldJob != null) {
                try {
                    this.oldJob.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return Status.CANCEL_STATUS;
                }
            }
            if ((editorDocument = GherkinEditorDocument.get(this.document)) != null && (resource = editorDocument.getResource()) != null) {
                List<ParseError> list = editorDocument.getParseError().collect(Collectors.toList());
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                MarkerFactory.syntaxErrorOnGherkin(resource, list, this.peristent);
            }
            jobMap.remove(this.document, (Object)this);
            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }
    }
}

