/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.checkpoint;

import com.kms.katalon.entity.checkpoint.CheckpointCell;
import com.kms.katalon.entity.checkpoint.CheckpointSourceInfo;
import com.kms.katalon.entity.file.FileEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class CheckpointEntity
extends FileEntity {
    private static final long serialVersionUID = -7729866738452365898L;
    private CheckpointSourceInfo sourceInfo;
    private List<String> columnNames;
    private List<List<CheckpointCell>> checkpointData;
    private Date takenDate;

    public static String getCheckpointFileExtension() {
        return ".cpt";
    }

    public CheckpointSourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(CheckpointSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public List<List<CheckpointCell>> getCheckpointData() {
        return this.checkpointData;
    }

    public void setCheckpointData(List<List<CheckpointCell>> data) {
        this.checkpointData = data;
    }

    public Date getTakenDate() {
        return this.takenDate;
    }

    public void setTakenDate(Date takenDate) {
        this.takenDate = takenDate;
    }

    @Override
    public String getFileExtension() {
        return CheckpointEntity.getCheckpointFileExtension();
    }

    @Override
    public CheckpointEntity clone() {
        return (CheckpointEntity)super.clone();
    }

    public void copyPropertiesFrom(CheckpointEntity anotherCheckpoint) {
        List<List<CheckpointCell>> anotherCheckpointData = anotherCheckpoint.getCheckpointData();
        if (anotherCheckpointData != null) {
            ArrayList<List<CheckpointCell>> clonedCheckpointData = new ArrayList<List<CheckpointCell>>();
            for (List<CheckpointCell> checkpointCells : anotherCheckpointData) {
                ArrayList<CheckpointCell> clonedCheckpointCells = new ArrayList<CheckpointCell>();
                for (CheckpointCell checkpointCell : checkpointCells) {
                    clonedCheckpointCells.add(checkpointCell.clone());
                }
                clonedCheckpointData.add(clonedCheckpointCells);
            }
            this.setCheckpointData(clonedCheckpointData);
        }
        this.setSourceInfo(anotherCheckpoint.getSourceInfo().clone());
        if (anotherCheckpoint.getColumnNames() != null) {
            this.setColumnNames(new ArrayList<String>(anotherCheckpoint.getColumnNames()));
        }
        this.setTakenDate(anotherCheckpoint.getTakenDate());
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEquals = super.equals(obj);
        if (!(obj instanceof CheckpointEntity)) {
            return false;
        }
        CheckpointEntity that = (CheckpointEntity)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder().append(this.getCheckpointData(), that.getCheckpointData()).append((Object)this.getTakenDate(), (Object)that.getTakenDate());
        return isEquals && equalsBuilder.isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(7, 31).appendSuper(super.hashCode()).append((Object)this.getId()).append(this.getCheckpointData()).append((Object)this.getTakenDate()).toHashCode();
    }
}

