/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.testdata.events;

import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;

public class TestDataUpdatedEvent {
    private final String originalPk;
    private final FileEntity dataFileEntity;
    private final TriggeredBy triggeredBy;
    private final String publisherPartId;

    public TestDataUpdatedEvent(String originalPk, FileEntity dataFileEntity, TriggeredBy triggeredBy) {
        this.originalPk = originalPk;
        this.dataFileEntity = dataFileEntity;
        this.triggeredBy = triggeredBy;
        this.publisherPartId = null;
    }

    public TestDataUpdatedEvent(String originalPk, FileEntity dataFileEntity, TriggeredBy triggeredBy, String publisherPartId) {
        this.originalPk = originalPk;
        this.dataFileEntity = dataFileEntity;
        this.triggeredBy = triggeredBy;
        this.publisherPartId = publisherPartId;
    }

    public String getOriginalPk() {
        return this.originalPk;
    }

    public DataFileEntity getDataFileEntity() {
        return (DataFileEntity)this.dataFileEntity;
    }

    public TriggeredBy getTriggeredBy() {
        return this.triggeredBy;
    }

    public String getPublisherPartId() {
        return this.publisherPartId;
    }

    public boolean shouldTriggerReferenceUpdate() {
        return this.triggeredBy == TriggeredBy.RENAME_TEST_DATA || this.triggeredBy == TriggeredBy.MOVE_TEST_DATA || this.triggeredBy == TriggeredBy.RENAME_FOLDER;
    }

    public boolean isContentOnlyChange() {
        return this.triggeredBy == TriggeredBy.CONTENT_MODIFICATION;
    }

    public static enum TriggeredBy {
        RENAME_TEST_DATA,
        MOVE_TEST_DATA,
        RENAME_FOLDER,
        CONTENT_MODIFICATION,
        OTHERS;

    }
}

