/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.config.AiAutoTagConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.core.services.IStudioAssistController;
import com.kms.katalon.composer.ai.studioassist.preference.AiAutoTagComponent;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.core.setting.IStudioAssistAiAutoTagSetting;
import com.kms.katalon.session.core.model.AiAutoTagSetting;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class UserManagedAiAutoTagComponent
extends AiAutoTagComponent {
    private Button apiTestCaseGenerationButton;
    private Button generateCodeButton;
    private Button apiDefaultTagRadio;
    private Button apiCustomTagRadio;
    private Text apiCustomTagText;
    private Button codeDefaultTagRadio;
    private Button codeCustomTagRadio;
    private Text codeCustomTagText;

    public UserManagedAiAutoTagComponent(Composite parent, AiAutoTagSetting aiAutoTaggingSetting, IStudioAssistController controller) {
        super(parent, aiAutoTaggingSetting, controller);
    }

    @Override
    protected Composite createContent(Composite parent) {
        this.createApiTestCaseSection(parent);
        this.createGenerateCodeSection(parent);
        Composite duo = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).build();
        ComponentBuilder.label((Composite)duo).text("*Test cases with AI-generated tags will be highlighted in purple ").italic().color(ColorUtil.themeColor((Color)ColorUtil.INFO_LABEL_LIGHT_THEME, (Color)ColorUtil.INFO_LABEL_DARK_THEME)).build();
        ComponentBuilder.image((Composite)duo, (String)"genai/test_case_ai_16.png").autoSize(24, 24).build();
        return parent;
    }

    @Override
    public void saveConfig() throws StudioAssistSavingConfigException {
        AiAutoTagConfig studioAssistSetting = new AiAutoTagConfig();
        studioAssistSetting.setApiTestCaseGeneration(this.apiTestCaseGenerationButton.getSelection());
        studioAssistSetting.setCodeGeneration(this.generateCodeButton.getSelection());
        studioAssistSetting.setApiTestCaseDefaultTag(this.apiDefaultTagRadio.getSelection());
        studioAssistSetting.setCodeGenerationDefaultTag(this.codeDefaultTagRadio.getSelection());
        studioAssistSetting.setApiTestCaseCustomTag(this.apiCustomTagRadio.getSelection());
        studioAssistSetting.setCodeGenerationCustomTag(this.codeCustomTagRadio.getSelection());
        studioAssistSetting.setApiTestCustomTag(this.apiCustomTagText.getText().trim());
        studioAssistSetting.setGenerateCodeCustomTag(this.codeCustomTagText.getText().trim());
        this.controller.saveStudioAssistAiAutoTagSetting(studioAssistSetting);
    }

    @Override
    public void resetConfig() {
        this.resetCustomTagToDefaults(this.apiTestCaseGenerationButton, this.apiDefaultTagRadio, this.apiCustomTagRadio, this.apiCustomTagText);
        this.resetCustomTagToDefaults(this.generateCodeButton, this.codeDefaultTagRadio, this.codeCustomTagRadio, this.codeCustomTagText);
    }

    private void createApiTestCaseSection(Composite parent) {
        IStudioAssistAiAutoTagSetting studioAssistSetting = this.controller.getStudioAssistAiAutoTagSetting();
        this.apiTestCaseGenerationButton = (Button)ComponentBuilder.checkBox((Composite)parent).text("API Test Case Generation").onSelection(e -> this.validateCustomTagOption()).marginTop(5).build();
        this.apiTestCaseGenerationButton.setSelection(studioAssistSetting.isApiTestCaseGeneration());
        Composite radioGroup = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1, (int)0).marginLeft(20).fillHorizontal().build();
        this.apiDefaultTagRadio = (Button)ComponentBuilder.radio((Composite)radioGroup).text("Default tag (API_Test_Generation)").onSelection(e -> this.validateCustomTagOption()).build();
        this.apiDefaultTagRadio.setSelection(studioAssistSetting.isApiTestCaseDefaultTag());
        this.apiCustomTagRadio = (Button)ComponentBuilder.radio((Composite)radioGroup).text("Custom tag").onSelection(e -> this.validateCustomTagOption()).build();
        this.apiCustomTagRadio.setSelection(studioAssistSetting.isApiTestCaseCustomTag());
        this.apiCustomTagText = (Text)ComponentBuilder.text((Composite)radioGroup, (int)2048).placeholder("Enter a tag name").fillHorizontal().onChange(event -> this.validateCustomTag()).build();
        this.apiCustomTagText.setText(studioAssistSetting.getApiTestCustomTag());
        this.addCustomTagListeners(this.apiTestCaseGenerationButton, this.apiDefaultTagRadio, this.apiCustomTagRadio, this.apiCustomTagText);
        this.initializeAITagState(studioAssistSetting.isApiTestCaseGeneration(), this.apiDefaultTagRadio, this.apiCustomTagRadio, this.apiCustomTagText);
    }

    private void createGenerateCodeSection(Composite parent) {
        IStudioAssistAiAutoTagSetting studioAssistSetting = this.controller.getStudioAssistAiAutoTagSetting();
        this.generateCodeButton = (Button)ComponentBuilder.checkBox((Composite)parent).text("StudioAssist Code Generation").onSelection(e -> this.validateCustomTagOption()).marginTop(5).build();
        this.generateCodeButton.setSelection(studioAssistSetting.isCodeGeneration());
        Composite radioGroup = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1, (int)0).marginLeft(20).fillHorizontal().build();
        this.codeDefaultTagRadio = (Button)ComponentBuilder.radio((Composite)radioGroup).text("Default tag (GenAI)").onSelection(e -> this.validateCustomTagOption()).build();
        this.codeDefaultTagRadio.setSelection(studioAssistSetting.isCodeGenerationDefaultTag());
        this.codeCustomTagRadio = (Button)ComponentBuilder.radio((Composite)radioGroup).text("Custom tag").onSelection(e -> this.validateCustomTagOption()).build();
        this.codeCustomTagRadio.setSelection(studioAssistSetting.isCodeGenerationCustomTag());
        this.codeCustomTagText = (Text)ComponentBuilder.text((Composite)radioGroup, (int)2048).placeholder("Enter a tag name").fillHorizontal().onChange(event -> this.validateCustomTag()).build();
        this.codeCustomTagText.setText(studioAssistSetting.getGenerateCodeCustomTag());
        this.addCustomTagListeners(this.generateCodeButton, this.codeDefaultTagRadio, this.codeCustomTagRadio, this.codeCustomTagText);
        this.initializeAITagState(studioAssistSetting.isCodeGeneration(), this.codeDefaultTagRadio, this.codeCustomTagRadio, this.codeCustomTagText);
    }

    private void addCustomTagListeners(Button mainCheckBox, Button defaultTagRadio, Button customTagRadio, Text customTagText) {
        mainCheckBox.addListener(13, event -> {
            boolean selected = mainCheckBox.getSelection();
            defaultTagRadio.setEnabled(selected);
            customTagRadio.setEnabled(selected);
            customTagText.setEditable(selected && customTagRadio.getSelection());
        });
        defaultTagRadio.addListener(13, event -> {
            if (defaultTagRadio.getSelection()) {
                customTagText.setEditable(false);
            }
        });
        customTagRadio.addListener(13, event -> {
            if (customTagRadio.getSelection()) {
                customTagText.setEditable(mainCheckBox.getSelection());
            }
        });
    }

    private void initializeAITagState(boolean enabled, Button defaultTagRadio, Button customTagRadio, Text customTagText) {
        defaultTagRadio.setEnabled(enabled);
        customTagRadio.setEnabled(enabled);
        customTagText.setEditable(enabled && customTagRadio.getSelection());
    }

    private void validateCustomTagOption() {
        if (!this.apiCustomTagRadio.getSelection() && !this.codeCustomTagRadio.getSelection()) {
            this.setValidationStatus(true, null);
            return;
        }
        boolean isValid = true;
        String errorMessage = null;
        if (this.apiCustomTagRadio.getSelection() && this.apiTestCaseGenerationButton.getSelection()) {
            String apiText = this.apiCustomTagText.getText().trim();
            errorMessage = this.validateTagTextMessage(apiText);
            boolean bl = isValid = errorMessage == null;
        }
        if (isValid && this.codeCustomTagRadio.getSelection() && this.generateCodeButton.getSelection()) {
            String codeText = this.codeCustomTagText.getText().trim();
            errorMessage = this.validateTagTextMessage(codeText);
            isValid = errorMessage == null;
        }
        this.setValidationStatus(isValid, errorMessage);
    }

    private void validateCustomTag() {
        String codeGenText;
        String apiTestText;
        String errorMessage;
        if (Objects.nonNull(this.apiCustomTagRadio) && this.apiCustomTagRadio.getSelection() && (errorMessage = this.validateTagTextMessage(apiTestText = this.apiCustomTagText.getText().trim())) != null) {
            this.setValidationStatus(false, errorMessage);
            return;
        }
        if (Objects.nonNull(this.codeCustomTagRadio) && this.codeCustomTagRadio.getSelection() && (errorMessage = this.validateTagTextMessage(codeGenText = this.codeCustomTagText.getText().trim())) != null) {
            this.setValidationStatus(false, errorMessage);
            return;
        }
        this.setValidationStatus(true, null);
    }

    private String validateTagTextMessage(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return "Custom tag name cannot be empty";
        }
        if (text.length() > 200) {
            return "Custom tag name cannot be longer than 200 characters";
        }
        if (text.contains(",") || text.contains(";")) {
            return "Custom tag name cannot contain commas or semicolons";
        }
        return null;
    }

    private void setValidationStatus(boolean isValid, String errorMessage) {
        if (this.mainPreferencePage != null) {
            this.mainPreferencePage.setValid(isValid);
            this.mainPreferencePage.setErrorMessage(errorMessage);
        }
    }

    private void resetCustomTagToDefaults(Button mainCheckBox, Button defaultTagRadio, Button customTagRadio, Text customTagText) {
        mainCheckBox.setEnabled(true);
        mainCheckBox.setSelection(true);
        defaultTagRadio.setEnabled(true);
        defaultTagRadio.setSelection(true);
        customTagRadio.setEnabled(true);
        customTagRadio.setSelection(false);
        customTagText.setEditable(false);
        customTagText.setText("");
    }
}

