/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.azure.preference.composite;

import com.kms.katalon.composer.components.impl.control.ExpandableComposite;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.integration.azure.constant.StringConstants;
import com.kms.katalon.composer.integration.azure.preference.composite.StatusMappingTable;
import com.kms.katalon.composer.integration.azure.preference.composite.TestConfigurationMappingComposite;
import com.kms.katalon.integration.azure.exception.AzureApiException;
import com.kms.katalon.integration.azure.model.AzureCredential;
import com.kms.katalon.integration.azure.model.AzureProjectRef;
import com.kms.katalon.integration.azure.model.AzureTestConfigurationsRef;
import com.kms.katalon.integration.azure.provider.AzureIntegrationRequest;
import com.kms.katalon.integration.azure.setting.AzureSettingStore;
import com.kms.katalon.integration.azure.setting.ExecutionStatusMapping;
import com.kms.katalon.integration.azure.setting.TestConfigurationMapping;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestArtifactsMappingComposite
extends ExpandableComposite {
    private static Logger logger = LoggerFactory.getLogger(TestArtifactsMappingComposite.class);
    private Composite container;
    private AzureSettingStore settingStore;
    private StatusMappingTable statusMappingTable;
    private List<ExecutionStatusMapping> statusMappingList;
    private List<TestConfigurationMapping> testConfigurationMappingList;
    private TestConfigurationMappingComposite testConfigurationMappingComposite;
    private AzureTestConfigurationsRef testConfigSuggestions;
    private static final int LIMIT_DIALOG_SETTING_HEIGHT = 720;

    public TestArtifactsMappingComposite(Composite parent, AzureSettingStore settingStore) {
        super(parent, StringConstants.GRP_TEST_ARTIFACTS_MAPPING, 1, false, 2048);
        this.settingStore = settingStore;
        this.container = (Composite)ComponentBuilder.fromGrid((Composite)this.createControl()).marginLeft(5).fillHorizontal().build();
        this.initializeData();
    }

    public void initializeData() {
        this.statusMappingList = this.settingStore.getExecutionStatusMappings();
        this.testConfigurationMappingList = this.settingStore.getTestConfigurationMappings();
        AzureCredential credential = this.settingStore.getCredential();
        AzureProjectRef storedProject = this.settingStore.getIntegratedProject();
        String projectId = "";
        if (storedProject != null) {
            projectId = storedProject.getId();
        }
        if (StringUtils.isNotEmpty((CharSequence)(credential.getServerUrl().trim() + credential.getToken()))) {
            this.updateTestConfigurationSuggestions(credential, projectId);
            this.statusMappingTable.setInput(this.statusMappingList);
        }
    }

    public AzureTestConfigurationsRef fetchTestConfigurations(AzureCredential credential, String projectId) {
        if (credential == null && StringUtils.isBlank((CharSequence)projectId)) {
            return null;
        }
        AzureTestConfigurationsRef testConfigList = new AzureTestConfigurationsRef();
        try {
            testConfigList = AzureIntegrationRequest.getAllTestConfigurations((AzureCredential)credential, (String)projectId);
        }
        catch (AzureApiException exception) {
            logger.error(StringConstants.MSG_ERROR_FETCHING_TEST_CONFIGURATIONS + "\n" + exception.getMessage());
            return null;
        }
        return testConfigList;
    }

    public Composite createControl() {
        Composite parent = super.createControl();
        ComponentBuilder.label((Composite)parent, (int)0).text(StringConstants.LBL_EXECUTION_STATUS_MAPPING).font(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont")).build();
        ComponentBuilder.label((Composite)parent, (int)0).text(StringConstants.LBL_EXECUTION_STATUS_MAPPING_DESCRIPTION).build();
        this.statusMappingTable = new StatusMappingTable(parent);
        ComponentBuilder.label((Composite)parent, (int)0).text(StringConstants.LBL_TEST_CONFIGURATION_MAPPING).font(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont")).build();
        ComponentBuilder.label((Composite)parent, (int)0).text(StringConstants.LBL_TEST_CONFIGURATION_MAPPING_DESCRIPTION).build();
        this.testConfigurationMappingComposite = new TestConfigurationMappingComposite(parent);
        return parent;
    }

    public void reset(AzureCredential credential, String projectId) {
        this.statusMappingList = this.settingStore.getDefaultExecutionStatusMappings();
        this.statusMappingTable.setInput(this.statusMappingList);
        this.testConfigurationMappingList = this.settingStore.getDefaultTestConfigurationMappings();
        this.updateTestConfigurationSuggestions(credential, projectId);
    }

    public void updateTestConfigurationSuggestions(AzureCredential credential, String projectId) {
        this.testConfigSuggestions = this.fetchTestConfigurations(credential, projectId);
        this.testConfigurationMappingComposite.setInput(this.testConfigurationMappingList, this.testConfigSuggestions);
    }

    private boolean isStatusMappingDefault() {
        if (this.statusMappingList == null || this.statusMappingList.isEmpty()) {
            return true;
        }
        List defaultStatusMappingList = this.settingStore.getDefaultExecutionStatusMappings();
        int i = 0;
        while (i < defaultStatusMappingList.size()) {
            if (!((ExecutionStatusMapping)defaultStatusMappingList.get(i)).getAzureStatus().equals(this.statusMappingList.get(i).getAzureStatus())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isTestConfigurationMappingDefault() {
        List defaultTestConfigList = this.settingStore.getDefaultTestConfigurationMappings();
        if (defaultTestConfigList.size() != this.testConfigurationMappingList.size()) {
            return false;
        }
        int numberOfSimilarTestConfig = 0;
        int indexOfDefault = 0;
        while (indexOfDefault < defaultTestConfigList.size()) {
            TestConfigurationMapping defaultConfig = (TestConfigurationMapping)defaultTestConfigList.get(indexOfDefault);
            if (this.testConfigSuggestions != null && this.testConfigSuggestions.getCount() > 0) {
                defaultConfig.setAzureTestConfigurationId(this.testConfigSuggestions.getValue()[0].getId());
            }
            int testConfigIndex = 0;
            while (testConfigIndex < this.testConfigurationMappingList.size()) {
                TestConfigurationMapping config = this.testConfigurationMappingList.get(indexOfDefault);
                if (defaultConfig.toString().equals(config.toString())) {
                    ++numberOfSimilarTestConfig;
                }
                ++testConfigIndex;
            }
            ++indexOfDefault;
        }
        return numberOfSimilarTestConfig == defaultTestConfigList.size();
    }

    public boolean hasEditted() {
        if (!this.isStatusMappingDefault()) {
            return true;
        }
        return !this.isTestConfigurationMappingDefault();
    }

    public void saveToSettingStore() throws IOException {
        this.settingStore.setExecutionStatusMappings(this.statusMappingTable.getInput());
        this.settingStore.setTestConfigurationMappings(this.testConfigurationMappingComposite.getInput());
    }

    protected void expandCollapseBody() {
        super.expandCollapseBody();
        if (this.container == null) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Composite composite = TestArtifactsMappingComposite.this.container;
                int count = 0;
                do {
                    ScrolledComposite scrolledComposite;
                    ++count;
                    if (!((composite = composite.getParent()) instanceof ScrolledComposite) || !(scrolledComposite = (ScrolledComposite)composite).getExpandHorizontal() && !scrolledComposite.getExpandVertical()) continue;
                    scrolledComposite.setMinSize(scrolledComposite.getContent().computeSize(-1, -1, true));
                    Shell shell = scrolledComposite.getShell();
                    Point defaultSize = TestArtifactsMappingComposite.this.container.getShell().computeSize(-1, -1);
                    int height = shell.getClientArea().height;
                    int width = shell.getClientArea().width;
                    if (width < defaultSize.x) {
                        width = -1;
                    }
                    if (height < defaultSize.y) {
                        height = -1;
                    }
                    Point newPoint = shell.computeSize(width, height, true);
                    int maximumHeight = shell.getDisplay().getClientArea().height - 50;
                    int n = maximumHeight = maximumHeight > 720 ? 720 : maximumHeight;
                    if (shell.getMaximized()) {
                        return;
                    }
                    if (newPoint.y > maximumHeight) {
                        newPoint.y = maximumHeight;
                    }
                    shell.setSize(newPoint);
                    return;
                } while (!(composite instanceof ScrolledComposite) && count <= 5);
            }
        });
    }

    public boolean checkValidationBeforeSaving() {
        List<TestConfigurationMapping> testConfigList = this.testConfigurationMappingComposite.getInput();
        if (testConfigList == null || testConfigList.size() <= 0) {
            MessageDialog.openError(null, (String)StringConstants.AZURE_DEVOPS_NAME, (String)(StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS + " " + StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS_TEST_CONFIGURATIONS_ARE_NULL));
            return false;
        }
        return true;
    }

    public void setEnabled(boolean isEnabled) {
        if (this.container != null) {
            ControlUtils.recursiveSetEnabled((Control)this.container, (boolean)isEnabled);
        }
    }
}

