/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.machine.service;

import com.kms.katalon.logging.LogUtil;
import java.security.MessageDigest;

public interface MachineIdService {
    public static final String UUID_REGEX = "[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}";
    public static final String UNAVAILABLE = "N/A";

    public String getMachineId();

    public String getOsDependentUsername();

    default public String appendAdditionalSignatures(String str) {
        LogUtil.logInfo((String)"Start appending additional signatures");
        String osDependentUsername = this.getOsDependentUsername().toLowerCase();
        String signature = str + "__" + osDependentUsername;
        LogUtil.logInfo((String)("End appending additional signatures " + signature));
        return signature;
    }

    public static String hash(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            byte[] bd1 = md.digest();
            StringBuffer hexString = new StringBuffer();
            int i = 0;
            while (i < bd1.length) {
                String hex = Integer.toHexString(0xFF & bd1[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
                ++i;
            }
            return hexString.toString().substring(0, 32);
        }
        catch (Exception e) {
            LogUtil.logError((String)("Cannot hash the Machine ID because: " + e.getMessage()));
            return str;
        }
    }

    public static String defaultMachineId() {
        return MachineIdService.hash(UNAVAILABLE);
    }
}

