/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.component;

import com.katalon.capability.constant.DriverType;
import com.katalon.capability.constant.RemoteDriverType;
import com.katalon.capability.model.CapabilitySetting;
import com.kms.katalon.composer.execution.components.DriverCapabilityComposite;
import com.kms.katalon.composer.execution.components.DriverPropertyMapComposite;
import com.kms.katalon.composer.webui.constants.StringConstants;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class RemoteWebDriverCapabilityComposite
extends DriverCapabilityComposite {
    private Text txtRemoteServerUrl;
    private Combo cbbRemoteDriverType;
    private Combo cbbAppiumDriver;
    private GridData gdMobileComposite;
    private GridData gdLblDriverType;
    private static final Map<String, DriverType> APPIUM_DRIVER_MAP = Map.of("Android Driver", DriverType.ANDROID_DRIVER, "iOS Driver", DriverType.IOS_DRIVER);

    public RemoteWebDriverCapabilityComposite(Composite parent, int style, CapabilitySetting capabilitySetting) {
        super(parent, style, capabilitySetting);
    }

    protected void createContents() {
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(1808));
        Composite remoteUrlComposite = new Composite((Composite)this, 0);
        remoteUrlComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glRemoteComposite = new GridLayout(2, false);
        glRemoteComposite.verticalSpacing = 10;
        glRemoteComposite.horizontalSpacing = 15;
        remoteUrlComposite.setLayout((Layout)glRemoteComposite);
        final Label lblRemoteServerUrl = new Label(remoteUrlComposite, 0);
        GridData gdLblServerUrl = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblRemoteServerUrl.setLayoutData((Object)gdLblServerUrl);
        lblRemoteServerUrl.setText(StringConstants.LBL_REMOTE_SERVER_URL);
        this.txtRemoteServerUrl = new Text(remoteUrlComposite, 2048);
        final GridData gdTxtUrl = new GridData(4, 0x1000000, true, false, 1, 1);
        this.txtRemoteServerUrl.setLayoutData((Object)gdTxtUrl);
        gdTxtUrl.widthHint = 250;
        this.txtRemoteServerUrl.setToolTipText(this.txtRemoteServerUrl.getText());
        this.txtRemoteServerUrl.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                gdTxtUrl.widthHint = event.width;
                RemoteWebDriverCapabilityComposite.this.gdLblDriverType.widthHint = lblRemoteServerUrl.getBounds().width;
            }
        });
        this.txtRemoteServerUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteWebDriverCapabilityComposite.this.txtRemoteServerUrl.setToolTipText(RemoteWebDriverCapabilityComposite.this.txtRemoteServerUrl.getText());
            }
        });
        Label lblRemoteServerType = new Label(remoteUrlComposite, 0);
        GridData gdLblRemoteServerType = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblRemoteServerType.setLayoutData((Object)gdLblRemoteServerType);
        lblRemoteServerType.setText(StringConstants.LBL_REMOTE_SERVER_TYPE);
        this.cbbRemoteDriverType = new Combo(remoteUrlComposite, 8);
        this.cbbRemoteDriverType.setItems(RemoteDriverType.getDisplayNameArray());
        this.cbbRemoteDriverType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteDriverType remoteDriverType = RemoteDriverType.fromDisplayName((String)RemoteWebDriverCapabilityComposite.this.cbbRemoteDriverType.getText());
                RemoteWebDriverCapabilityComposite.this.updateMobileCompositeLayout(remoteDriverType);
            }
        });
        Composite mobileDriverComposite = new Composite((Composite)this, 0);
        this.gdMobileComposite = new GridData(4, 0x1000000, true, false, 1, 1);
        mobileDriverComposite.setLayoutData((Object)this.gdMobileComposite);
        GridLayout glMobileComposite = new GridLayout(2, false);
        glMobileComposite.verticalSpacing = 10;
        glMobileComposite.horizontalSpacing = 15;
        mobileDriverComposite.setLayout((Layout)glMobileComposite);
        Label lblDriverType = new Label(mobileDriverComposite, 0);
        this.gdLblDriverType = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblDriverType.setLayoutData((Object)lblDriverType);
        lblDriverType.setLayoutData((Object)this.gdLblDriverType);
        lblDriverType.setText("Appium driver");
        this.cbbAppiumDriver = new Combo(mobileDriverComposite, 8);
        this.cbbAppiumDriver.setItems((String[])APPIUM_DRIVER_MAP.keySet().toArray(String[]::new));
        this.driverPropertyMapComposite = new DriverPropertyMapComposite((Composite)this);
        this.updateUI();
    }

    public CapabilitySetting getCapability() {
        String appiumDriverTypeStr;
        String remoteDriverTypeStr;
        Map currentDriverProperties = this.driverPropertyMapComposite.getDriverProperties();
        String remoteServerUrl = this.txtRemoteServerUrl.getText();
        if (StringUtils.isNotBlank((CharSequence)remoteServerUrl)) {
            currentDriverProperties.put("remoteWebDriverUrl", remoteServerUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)(remoteDriverTypeStr = this.cbbRemoteDriverType.getText()))) {
            RemoteDriverType remoteDriverType = RemoteDriverType.fromDisplayName((String)remoteDriverTypeStr);
            currentDriverProperties.put("remoteWebDriverType", remoteDriverType.getDisplayName());
        }
        if (StringUtils.isNotBlank((CharSequence)(appiumDriverTypeStr = this.cbbAppiumDriver.getText()))) {
            DriverType appiumDriverType = APPIUM_DRIVER_MAP.get(appiumDriverTypeStr);
            currentDriverProperties.put("remoteMobileDriver", appiumDriverType);
        }
        this.capabilitySetting.setValue(currentDriverProperties);
        return this.capabilitySetting;
    }

    public void updateUI() {
        String remoteDriverType;
        int remoteDriverTypeIndex;
        String remoteDriverUrl = (String)this.capabilitySetting.getValue().get("remoteWebDriverUrl");
        if (StringUtils.isNotBlank((CharSequence)remoteDriverUrl)) {
            this.txtRemoteServerUrl.setText(remoteDriverUrl);
        }
        if (-1 < (remoteDriverTypeIndex = this.cbbRemoteDriverType.indexOf(remoteDriverType = this.capabilitySetting.getValue().getOrDefault("remoteWebDriverType", "")))) {
            this.cbbRemoteDriverType.select(remoteDriverTypeIndex);
        }
        String appiumDriverTypeStr = this.capabilitySetting.getValue().getOrDefault("remoteMobileDriver", "");
        String selectedKey = APPIUM_DRIVER_MAP.entrySet().stream().filter(item -> ((DriverType)item.getValue()).name().equals(appiumDriverTypeStr)).map(Map.Entry::getKey).findFirst().orElse("");
        int appiumDriverTypeIndex = this.cbbAppiumDriver.indexOf(selectedKey);
        if (-1 < appiumDriverTypeIndex) {
            this.cbbAppiumDriver.select(appiumDriverTypeIndex);
        }
        this.capabilitySetting.getValue().remove("remoteWebDriverUrl");
        this.capabilitySetting.getValue().remove("remoteWebDriverType");
        this.capabilitySetting.getValue().remove("remoteMobileDriver");
        super.updateUI();
    }

    private void updateMobileCompositeLayout(RemoteDriverType remoteDriverType) {
        this.gdMobileComposite.heightHint = remoteDriverType != RemoteDriverType.APPIUM ? 0 : -1;
        this.getParent().getParent().layout(true, true);
    }
}

