/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.strategies;

import com.kms.katalon.dal.fileservice.strategies.IEntityLoadStrategy;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.util.XmlInputFactoryProvider;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.function.Predicate;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class FilePathPrecheckEntityLoadStrategy
implements IEntityLoadStrategy {
    private Predicate<String> predicate;
    private XMLInputFactory xif = XmlInputFactoryProvider.newInstanceForEntityUnmarshaller();

    public FilePathPrecheckEntityLoadStrategy(Predicate<String> predicate) {
        this.predicate = predicate;
    }

    @Override
    public FileEntity load(String filePath, Unmarshaller unmarshaller) throws Exception {
        if (!this.predicate.test(filePath)) {
            return null;
        }
        String content = Files.readString(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8);
        XMLStreamReader xsr = this.xif.createXMLStreamReader(new StringReader(content));
        FileEntity entity = (FileEntity)unmarshaller.unmarshal(xsr);
        return entity;
    }
}

