/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.testcloud.core.model;

import com.kms.katalon.testcloud.core.model.TestCloudBrowser;
import com.kms.katalon.testcloud.core.model.TestCloudDesktopBrowser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class TestCloudOS {
    private String os;
    private String osDisplayName;
    private List<TestCloudBrowser> browsers = new ArrayList<TestCloudBrowser>();

    public TestCloudOS(TestCloudDesktopBrowser environment) {
        this.setOs(environment.getOs());
        this.setOsDisplayName(environment.getOsDisplayName());
        this.addBrowser(environment);
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getOsDisplayName() {
        if (Objects.isNull(this.osDisplayName)) {
            return "";
        }
        if (this.osDisplayName.toLowerCase().equals("macos") || this.osDisplayName.toLowerCase().equals("mac os") || this.osDisplayName.toLowerCase().equals("mac os x") || this.osDisplayName.toLowerCase().equals("mac")) {
            return "macOS";
        }
        return StringUtils.capitalize((String)this.osDisplayName.toLowerCase());
    }

    public void setOsDisplayName(String osDisplayName) {
        this.osDisplayName = osDisplayName;
    }

    public List<TestCloudBrowser> getBrowsers() {
        return this.browsers;
    }

    public void setBrowsers(List<TestCloudBrowser> browsers) {
        this.browsers = browsers;
    }

    public void addBrowser(TestCloudDesktopBrowser environment) {
        Optional<TestCloudBrowser> mappedBrowser = this.browsers.stream().filter(e -> e.getBrowserName().equalsIgnoreCase(environment.getBrowserName())).findFirst();
        if (mappedBrowser.isPresent()) {
            mappedBrowser.get().addVersion(environment);
        } else {
            this.browsers.add(new TestCloudBrowser(environment));
        }
    }
}

