/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.util;

import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class FileLockUtil {
    public static FileLock waitForLock(FileChannel channel, int timeout) {
        long startTime = System.currentTimeMillis();
        while (true) {
            FileLock lock = null;
            try {
                lock = channel.tryLock();
            }
            catch (IOException iOException) {}
            if (lock != null) {
                return lock;
            }
            if (System.currentTimeMillis() - startTime > (long)(timeout * 1000)) {
                LogUtil.logError((String)("Timeout: Could not acquire lock within " + timeout + " seconds."));
                return null;
            }
            Random random = new Random();
            int delay = random.nextInt(3) + 1;
            try {
                TimeUnit.SECONDS.sleep(delay);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LogUtil.logError((Throwable)e, (String)"Sleep interrupted!");
                continue;
            }
            break;
        }
    }
}

