/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.DecompilerType;
import org.sf.feeling.decompiler.editor.IDecompilerDescriptor;
import org.sf.feeling.decompiler.editor.JavaDecompilerClassFileEditor;
import org.sf.feeling.decompiler.i18n.Messages;

public class OpenClassWithContributionFactory
extends ExtensionContributionFactory {
    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        boolean openClassWith;
        final ISelectionService selService = (ISelectionService)serviceLocator.getService(ISelectionService.class);
        String dynamicMenuId = "org.sf.feeling.decompiler.openwith.items";
        CompoundContributionItem dynamicItems = new CompoundContributionItem(dynamicMenuId){

            protected IContributionItem[] getContributionItems() {
                IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                Iterator selections = OpenClassWithContributionFactory.this.getSelections(selService);
                if (selections == null) {
                    return new IContributionItem[0];
                }
                List classes = OpenClassWithContributionFactory.this.getSelectedElements(selService, IClassFile.class);
                ArrayList<ActionContributionItem> list = new ArrayList<ActionContributionItem>();
                if (classes.size() == 1) {
                    IEditorDescriptor editor = registry.findEditor("org.sf.feeling.decompiler.ClassFileEditor");
                    TreeSet decompilerTypes = new TreeSet();
                    Collections.addAll(decompilerTypes, DecompilerType.getDecompilerTypes());
                    for (String decompilerType : decompilerTypes) {
                        list.add(new ActionContributionItem((IAction)new OpenClassesAction(editor, classes, decompilerType)));
                    }
                }
                return list.toArray(new IContributionItem[list.size()]);
            }
        };
        List<IClassFile> selectedClasses = this.getSelectedElements(selService, IClassFile.class);
        boolean bl = openClassWith = selectedClasses.size() == 1;
        if (openClassWith) {
            MenuManager submenu = new MenuManager(Messages.getString("JavaDecompilerActionBarContributor.Menu.OpenClassWith"), dynamicMenuId);
            submenu.add((IContributionItem)dynamicItems);
            additions.addContributionItem((IContributionItem)submenu, new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                    boolean menuVisible = OpenClassWithContributionFactory.this.isMenuVisible(selService);
                    if (menuVisible) {
                        return EvaluationResult.TRUE;
                    }
                    return EvaluationResult.FALSE;
                }
            });
        }
    }

    private boolean isMenuVisible(ISelectionService selService) {
        Iterator selections = this.getSelections(selService);
        boolean atLeastOneSelection = false;
        boolean allClasses = true;
        boolean singlePackageOrRoot = false;
        while (selections != null && selections.hasNext()) {
            atLeastOneSelection = true;
            Object select = selections.next();
            if (!(select instanceof IClassFile)) {
                allClasses = false;
            }
            if (!(select instanceof IPackageFragment) && (!(select instanceof IPackageFragmentRoot) || selections.hasNext())) continue;
            singlePackageOrRoot = true;
        }
        return atLeastOneSelection && (allClasses || singlePackageOrRoot);
    }

    private <T> List<T> getSelectedElements(ISelectionService selService, Class<T> eleClass) {
        Iterator selections = this.getSelections(selService);
        ArrayList elements = new ArrayList();
        while (selections != null && selections.hasNext()) {
            Object select = selections.next();
            if (!eleClass.isInstance(select)) continue;
            elements.add(select);
        }
        return elements;
    }

    private Iterator getSelections(ISelectionService selService) {
        ISelection selection = selService.getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.iterator();
        }
        return null;
    }

    public static final class OpenClassesAction
    extends Action {
        private final IEditorDescriptor classEditor;
        private final List classes;
        private String decompilerType;

        public OpenClassesAction(IEditorDescriptor classEditor, List classes, String decompilerType) {
            this.classEditor = classEditor;
            this.classes = classes;
            this.decompilerType = decompilerType;
        }

        public String getText() {
            IDecompilerDescriptor decompilerDescriptor = JavaDecompilerPlugin.getDefault().getDecompilerDescriptor(this.decompilerType);
            if (decompilerDescriptor != null) {
                return decompilerDescriptor.getDecompileAction().getText();
            }
            return this.classEditor.getLabel();
        }

        public ImageDescriptor getImageDescriptor() {
            return JavaDecompilerPlugin.getDefault().getDecompilerDescriptor(this.decompilerType).getDecompilerIcon();
        }

        public void run() {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return;
            }
            int i = 0;
            while (i < this.classes.size()) {
                IClassFile classfile = (IClassFile)this.classes.get(i);
                IEditorInput input = EditorUtility.getEditorInput((Object)classfile);
                try {
                    IEditorPart openEditor = page.openEditor(input, this.classEditor.getId(), true);
                    if (openEditor != null && !this.classEditor.getId().equals(openEditor.getEditorSite().getId()) && !openEditor.isDirty()) {
                        openEditor.getSite().getPage().closeEditor(openEditor, false);
                        page.openEditor(input, this.classEditor.getId(), true);
                    }
                    if (openEditor instanceof JavaDecompilerClassFileEditor) {
                        JavaDecompilerClassFileEditor editor = (JavaDecompilerClassFileEditor)openEditor;
                        editor.doSetInput(this.decompilerType, true);
                    }
                }
                catch (PartInitException e) {
                    JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.sf.feeling.decompiler", 0, e.getMessage(), (Throwable)e));
                }
                ++i;
            }
        }
    }
}

