/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.editor;

import com.drgarbage.asm.render.intf.IClassFileDocument;
import com.drgarbage.asm.render.intf.IFieldSection;
import com.drgarbage.asm.render.intf.IMethodSection;
import com.drgarbage.bytecode.ByteCodeConstants;
import com.drgarbage.utils.ClassFileDocumentsUtils;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocBrowserInformationControlInput;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.sf.feeling.decompiler.editor.ByteCodeDocument;
import org.sf.feeling.decompiler.editor.DisassemblerDocument;
import org.sf.feeling.decompiler.editor.DisassemblerDocumentProvider;
import org.sf.feeling.decompiler.editor.JavaDecompilerClassFileEditor;
import org.sf.feeling.decompiler.util.HelpUtils;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.ReflectionUtils;

public class DisassemblerJavadocHover
extends JavadocHover
implements IJavaEditorTextHover {
    /*
     * Enabled aggressive exception aggregation
     */
    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        try {
            if (textViewer.getDocument() instanceof DisassemblerDocument) {
                IJavaElement[] elements;
                ISourceRange range;
                IField f;
                IFieldSection field;
                DisassemblerDocument bytecodeDocument = (DisassemblerDocument)textViewer.getDocument();
                String text = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
                int i = 0;
                while (i < ByteCodeConstants.OPCODE_MNEMONICS.length) {
                    StringBuilder sb;
                    if (text.equals(ByteCodeConstants.OPCODE_MNEMONICS[i]) && (sb = HelpUtils.getOpcodeHelpFor(i)).length() > 0) {
                        JavadocBrowserInformationControlInput input = new JavadocBrowserInformationControlInput(null, null, sb.toString(), 0);
                        return input;
                    }
                    ++i;
                }
                if (text.indexOf("$") != -1) {
                    text = text.substring(text.lastIndexOf("$") + 1);
                }
                int line = bytecodeDocument.getLineOfOffset(hoverRegion.getOffset());
                DisassemblerDocumentProvider provider = bytecodeDocument.getDocumentProvider();
                IClassFileDocument disassemblerClassDocument = provider.getClassFileDocument();
                JavaDecompilerClassFileEditor editor = bytecodeDocument.getEditor();
                ClassFile cf = (ClassFile)((IClassFileEditorInput)editor.getEditorInput()).getClassFile();
                int offset = -1;
                if (disassemblerClassDocument.isLineInMethod(line - 2)) {
                    IMethod m;
                    IMethodSection method = disassemblerClassDocument.findMethodSection(line - 2);
                    if (method != null && (m = ClassFileDocumentsUtils.findMethod((IType)cf.getType(), (String)method.getName(), (String)method.getDescriptor())) != null) {
                        ISourceRange range2 = m.getSourceRange();
                        if (m.getJavadocRange() != null) {
                            range2 = new SourceRange(m.getJavadocRange().getOffset() + m.getJavadocRange().getLength(), range2.getLength() - m.getJavadocRange().getLength());
                        }
                        if (range2 != null && range2.getOffset() != -1 && (offset = m.getClassFile().getBuffer().getText(range2.getOffset(), range2.getLength()).indexOf(text)) != -1) {
                            hoverRegion = new Region(range2.getOffset() + offset, text.length());
                        }
                    }
                } else if (disassemblerClassDocument.isLineInField(line - 2) && (field = disassemblerClassDocument.findFieldSection(line - 2)) != null && (f = cf.getType().getField(field.getName())) != null) {
                    ISourceRange range3 = f.getSourceRange();
                    if (f.getJavadocRange() != null) {
                        range3 = new SourceRange(f.getJavadocRange().getOffset() + f.getJavadocRange().getLength(), range3.getLength() - f.getJavadocRange().getLength());
                    }
                    if (range3 != null && range3.getOffset() != -1 && (offset = f.getClassFile().getBuffer().getText(range3.getOffset(), range3.getLength()).indexOf(text)) != -1) {
                        hoverRegion = new Region(range3.getOffset() + offset, text.length());
                    }
                    if (offset == -1) {
                        range3 = cf.getType().getSourceRange();
                        offset = cf.getType().getClassFile().getBuffer().getText(0, range3.getOffset() + range3.getLength()).indexOf(text);
                        if (offset != -1) {
                            hoverRegion = new Region(offset, text.length());
                        }
                    }
                }
                if (offset == -1 && (range = cf.getType().getSourceRange()) != null && range.getOffset() + range.getLength() > -1 && (offset = cf.getType().getClassFile().getBuffer().getText(0, range.getOffset() + range.getLength()).indexOf(text)) != -1) {
                    hoverRegion = new Region(offset, text.length());
                }
                if ((elements = this.getJavaElementsAt(textViewer, hoverRegion)) == null || elements.length == 0) {
                    return null;
                }
                return JavadocHover.getHoverInfo((IJavaElement[])elements, (ITypeRoot)this.getEditorInputJavaElement(), (IRegion)hoverRegion, null);
            }
            if (textViewer.getDocument() instanceof ByteCodeDocument) {
                int offset = -1;
                String text = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
                ClassFile cf = (ClassFile)((IClassFileEditorInput)((ByteCodeDocument)textViewer.getDocument()).getEditor().getEditorInput()).getClassFile();
                if (hoverRegion.getOffset() > -1) {
                    IJavaElement[] elements;
                    ISourceRange range;
                    IJavaElement element = ((ByteCodeDocument)textViewer.getDocument()).getEditor().getJavaElement(textViewer.getDocument().get(), hoverRegion.getOffset());
                    if (element != null) {
                        if (element instanceof IMethod) {
                            IMethod m = (IMethod)element;
                            if (m.isConstructor() && "init".equals(text)) {
                                text = cf.getTypeName();
                            }
                            ISourceRange range4 = m.getSourceRange();
                            if (m.getJavadocRange() != null) {
                                range4 = new SourceRange(m.getJavadocRange().getOffset() + m.getJavadocRange().getLength(), range4.getLength() - m.getJavadocRange().getLength());
                            }
                            if (range4 != null && range4.getOffset() != -1 && (offset = m.getClassFile().getBuffer().getText(range4.getOffset(), range4.getLength()).indexOf(text)) != -1) {
                                hoverRegion = new Region(range4.getOffset() + offset, text.length());
                            }
                        } else if (element instanceof IField) {
                            IField f = (IField)element;
                            ISourceRange range5 = f.getSourceRange();
                            if (f.getJavadocRange() != null) {
                                range5 = new SourceRange(f.getJavadocRange().getOffset() + f.getJavadocRange().getLength(), range5.getLength() - f.getJavadocRange().getLength());
                            }
                            if (range5 != null && range5.getOffset() != -1 && (offset = f.getClassFile().getBuffer().getText(range5.getOffset(), range5.getLength()).indexOf(text)) != -1) {
                                hoverRegion = new Region(range5.getOffset() + offset, text.length());
                            }
                            if (offset == -1) {
                                range5 = cf.getType().getSourceRange();
                                offset = cf.getType().getClassFile().getBuffer().getText(0, range5.getOffset() + range5.getLength()).indexOf(text);
                                if (offset != -1) {
                                    hoverRegion = new Region(offset, text.length());
                                }
                            }
                        }
                    }
                    if (offset == -1 && (range = cf.getType().getSourceRange()) != null && range.getOffset() + range.getLength() > -1 && (offset = cf.getType().getClassFile().getBuffer().getText(0, range.getOffset() + range.getLength()).indexOf(text)) != -1) {
                        hoverRegion = new Region(offset, text.length());
                    }
                    if ((elements = this.getJavaElementsAt(textViewer, hoverRegion)) == null || elements.length == 0) {
                        return null;
                    }
                    Object[] objectArray = new Object[4];
                    objectArray[0] = elements;
                    objectArray[1] = this.getEditorInputJavaElement();
                    objectArray[2] = hoverRegion;
                    return ReflectionUtils.invokeMethod((Object)this, "getHoverInfo", new Class[]{IJavaElement[].class, ITypeRoot.class, IRegion.class, JavadocBrowserInformationControlInput.class}, objectArray);
                }
            }
        }
        catch (Exception e) {
            Logger.debug(e);
        }
        return null;
    }
}

