/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.editor;

import com.drgarbage.asm.render.impl.OutlineElement;
import com.drgarbage.asm.render.impl.OutlineElementField;
import com.drgarbage.asm.render.impl.OutlineElementMethod;
import com.drgarbage.asm.render.impl.OutlineElementType;
import com.drgarbage.asm.render.intf.IClassFileDocument;
import com.drgarbage.asm.render.intf.IFieldSection;
import com.drgarbage.asm.render.intf.IMethodSection;
import com.drgarbage.asm.render.intf.IOutlineElementField;
import com.drgarbage.utils.ClassFileDocumentsUtils;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.javaeditor.breadcrumb.EditorBreadcrumb;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.rulers.IColumnSupport;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;
import org.eclipse.ui.texteditor.rulers.RulerColumnRegistry;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.actions.ByteCodeAction;
import org.sf.feeling.decompiler.actions.DisassemblerAction;
import org.sf.feeling.decompiler.actions.SourceCodeAction;
import org.sf.feeling.decompiler.editor.DisassemblerConfiguration;
import org.sf.feeling.decompiler.editor.DisassemblerDocument;
import org.sf.feeling.decompiler.editor.DisassemblerDocumentProvider;
import org.sf.feeling.decompiler.editor.JavaDecompilerClassFileEditor;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.ReflectionUtils;
import org.sf.feeling.decompiler.util.UIUtil;

public class DisassemblerSourceViewer
extends AbstractDecoratedTextEditor
implements IPropertyChangeListener {
    private AbstractTextEditor.SelectionProvider fSelectionProvider = new JdtSelectionProvider();
    private JavaDecompilerClassFileEditor editor;
    private DisassemblerDocument disassemblerDocument;
    private Composite container;
    private volatile boolean docChanged = false;
    private volatile boolean styleChanged = false;

    public StyledText getTextWidget() {
        return this.getSourceViewer().getTextWidget();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSelectionProvider;
    }

    public DisassemblerSourceViewer(JavaDecompilerClassFileEditor editor) {
        this.editor = editor;
    }

    private IPreferenceStore createCombinedPreferenceStore() {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(3);
        stores.add(JavaDecompilerPlugin.getDefault().getPreferenceStore());
        stores.add(JavaPlugin.getDefault().getPreferenceStore());
        stores.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    public Composite createControl(Composite parent) {
        this.setSite(this.editor.getSite());
        DisassemblerDocumentProvider provider = new DisassemblerDocumentProvider();
        this.setDocumentProvider((IDocumentProvider)provider);
        this.setInput(this.editor.getEditorInput());
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new FillLayout());
        IPreferenceStore store = this.createCombinedPreferenceStore();
        this.setPreferenceStore(store);
        int styles = 68354;
        IVerticalRuler fVerticalRuler = this.createVerticalRuler();
        ReflectionUtils.setFieldValue((Object)this, "fVerticalRuler", fVerticalRuler);
        JavaSourceViewer fSourceViewer = new JavaSourceViewer(this.container, fVerticalRuler, null, false, styles, store);
        ReflectionUtils.setFieldValue((Object)this, "fSourceViewer", fSourceViewer);
        this.getSourceViewerDecorationSupport((ISourceViewer)fSourceViewer);
        this.createActions();
        ReflectionUtils.invokeMethod((Object)this, "initializeSourceViewer", new Class[]{IEditorInput.class}, new Object[]{this.getEditorInput()});
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.install(this.getPreferenceStore());
        }
        StyledText styledText = fSourceViewer.getTextWidget();
        styledText.addMouseListener((MouseListener)this.getCursorListener());
        styledText.addKeyListener((KeyListener)this.getCursorListener());
        ReflectionUtils.setFieldValue((Object)this, "fEditorContextMenuId", "#TextEditorContext");
        String id = "#TextEditorContext";
        MenuManager manager = new MenuManager(id, id);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(this.getContextMenuListener());
        Menu fTextContextMenu = manager.createContextMenu((Control)styledText);
        styledText.setMenu(fTextContextMenu);
        ReflectionUtils.setFieldValue((Object)this, "fRulerContextMenuId", "#TextRulerContext");
        id = "#TextRulerContext";
        manager = new MenuManager(id, id);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(this.getContextMenuListener());
        Control rulerControl = fVerticalRuler.getControl();
        Menu fRulerContextMenu = manager.createContextMenu(rulerControl);
        rulerControl.setMenu(fRulerContextMenu);
        rulerControl.addMouseListener(this.getRulerMouseListener());
        this.createOverviewRulerContextMenu();
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        IColorManager colorManager = textTools.getColorManager();
        DisassemblerConfiguration classFileConfiguration = new DisassemblerConfiguration(colorManager, store, (ITextEditor)this.editor, "___java_partitioning");
        fSourceViewer.configure((SourceViewerConfiguration)classFileConfiguration);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)classFileConfiguration);
        this.getSourceViewerDecorationSupport((ISourceViewer)fSourceViewer).install(this.getPreferenceStore());
        this.initializeViewerColors((ISourceViewer)fSourceViewer);
        ReflectionUtils.invokeMethod((Object)this, "initializeViewerFont", new Class[]{ISourceViewer.class}, new Object[]{fSourceViewer});
        final EditorSelectionChangedListener fEditorSelectionChangedListener = new EditorSelectionChangedListener();
        fEditorSelectionChangedListener.install(this.getSelectionProvider());
        this.updateDocument(provider, (ISourceViewer)fSourceViewer);
        IVerticalRuler ruler = this.getVerticalRuler();
        if (ruler instanceof CompositeRuler) {
            this.updateContributedRulerColumns((CompositeRuler)ruler);
        }
        IColumnSupport columnSupport = (IColumnSupport)this.getAdapter(IColumnSupport.class);
        RulerColumnDescriptor lineNumberColumnDescriptor = RulerColumnRegistry.getDefault().getColumnDescriptor("org.eclipse.ui.editors.columns.linenumbers");
        if (lineNumberColumnDescriptor != null) {
            columnSupport.setColumnVisible(lineNumberColumnDescriptor, this.isLineNumberRulerVisible());
        }
        IPropertyChangeListener fFontPropertyChangeListener = (IPropertyChangeListener)ReflectionUtils.getFieldValue((Object)this, "fFontPropertyChangeListener");
        JFaceResources.getFontRegistry().addListener(fFontPropertyChangeListener);
        JavaDecompilerPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JavaDecompilerPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)DisassemblerSourceViewer.this);
                fEditorSelectionChangedListener.uninstall(DisassemblerSourceViewer.this.getSelectionProvider());
                DisassemblerSourceViewer.this.dispose();
            }
        });
        return this.container;
    }

    private void updateDocument(DisassemblerDocumentProvider provider, ISourceViewer fSourceViewer) {
        ClassFile cf = (ClassFile)((IClassFileEditorInput)this.editor.getEditorInput()).getClassFile();
        this.disassemblerDocument = new DisassemblerDocument(provider, this.editor);
        provider.setDocument((IDocument)this.disassemblerDocument);
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        tools.setupJavaDocumentPartitioner((IDocument)this.disassemblerDocument, "___java_partitioning");
        try {
            provider.setDocumentContent((IDocument)this.disassemblerDocument, new ByteArrayInputStream(cf.getBytes()), null);
        }
        catch (CoreException e) {
            ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
            try {
                String content = disassembler.disassemble(cf.getBytes(), "\n", 1);
                this.disassemblerDocument.set(content == null ? "" : content);
            }
            catch (Exception ex) {
                Logger.debug(e);
            }
        }
        fSourceViewer.setDocument((IDocument)this.disassemblerDocument);
    }

    private void doHandleCursorPositionChanged() {
        IClassFileDocument disassemblerClassDocument = ((DisassemblerDocumentProvider)this.getDocumentProvider()).getClassFileDocument();
        if (disassemblerClassDocument != null) {
            StyledText disassemblerText = this.getSourceViewer().getTextWidget();
            int selectedRange = disassemblerText.getSelectionRange().x;
            try {
                int line = this.disassemblerDocument.getLineOfOffset(selectedRange);
                ClassFile cf = (ClassFile)((IClassFileEditorInput)this.getEditorInput()).getClassFile();
                if (disassemblerClassDocument.isLineInMethod(line - 2)) {
                    IMethod m;
                    IMethodSection method = disassemblerClassDocument.findMethodSection(line - 2);
                    if (method != null && (m = ClassFileDocumentsUtils.findMethod((IType)cf.getType(), (String)method.getName(), (String)method.getDescriptor())) != null) {
                        this.editor.setSelection((IJavaElement)m);
                    }
                } else if (disassemblerClassDocument.isLineInField(line - 2)) {
                    IField f;
                    IFieldSection field = disassemblerClassDocument.findFieldSection(line - 2);
                    if (field != null && (f = cf.getType().getField(field.getName())) != null) {
                        this.editor.setSelection((IJavaElement)f);
                    }
                } else {
                    this.editor.setSelection((IJavaElement)cf.getType());
                }
            }
            catch (Exception e) {
                Logger.debug(e);
            }
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        String text = (String)ReflectionUtils.invokeMethod((Object)this, "getShowInMenuLabel");
        int i = 0;
        while (i < menu.getItems().length) {
            IContributionItem item = menu.getItems()[i];
            if (item instanceof MenuManager && ((MenuManager)item).getMenuText().equals(text)) {
                menu.remove(item);
            }
            ++i;
        }
        menu.appendToGroup("group.open", this.getAction("SourceCode"));
        menu.appendToGroup("group.open", this.getAction("ByteCode"));
        menu.appendToGroup("group.open", this.getAction("Disassembler"));
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DisassemblerSourceViewer.this.showMenu(manager);
            }
        });
    }

    private void showMenu(IMenuManager submenu) {
        for (IContributionItem item : Arrays.asList(submenu.getItems())) {
            IAction action;
            if (!(item instanceof ActionContributionItem) || !((action = ((ActionContributionItem)item).getAction()) instanceof IUpdate)) continue;
            ((IUpdate)action).update();
        }
    }

    protected void createActions() {
        super.createActions();
        this.setAction("SourceCode", (IAction)new SourceCodeAction());
        this.setAction("ByteCode", (IAction)new ByteCodeAction());
        this.setAction("Disassembler", (IAction)new DisassemblerAction());
    }

    public String[] collectContextMenuPreferencePages() {
        return this.editor.collectContextMenuPreferencePages();
    }

    public boolean isEditorInputModifiable() {
        return false;
    }

    public Control getControl() {
        return this.container;
    }

    public void setSelectionElement(ISourceReference selectedElement) {
        this.setSelectionElement(selectedElement, false);
    }

    public void setSelectionElement(ISourceReference selectedElement, boolean force) {
        StyledText disassemblerText = this.getSourceViewer().getTextWidget();
        OutlineElement disassemblerRootElement = (OutlineElement)((DisassemblerDocumentProvider)this.getDocumentProvider()).getClassFileOutlineElement();
        if (JavaDecompilerPlugin.getDefault().getSourceMode() == 2 && disassemblerText != null && !disassemblerText.isDisposed() && disassemblerRootElement != null) {
            if (!force) {
                if (UIUtil.requestFromDisassemblerSelection()) {
                    return;
                }
                if (!UIUtil.requestFromLinkToSelection()) {
                    return;
                }
            }
            if (selectedElement instanceof IMethod || selectedElement instanceof IField || selectedElement instanceof BinaryType) {
                try {
                    OutlineElement element = this.searchElement(disassemblerRootElement, selectedElement);
                    if (element != null) {
                        this.selectElement(disassemblerText, element);
                    }
                }
                catch (Exception e) {
                    Logger.debug(e);
                }
            }
        }
    }

    public void selectBytecodeLineAndReveal(StyledText disassemblerText, int bytecodeDocumentLine, String elementName, int elementType) {
        try {
            int elementIndex;
            IRegion region = this.disassemblerDocument.getLineInformation(bytecodeDocumentLine + 2);
            int lineStartOffset = region.getOffset();
            int lineLenght = region.getLength();
            String lineString = this.disassemblerDocument.get(lineStartOffset, lineLenght);
            if (elementName == null) {
                disassemblerText.setSelection(lineStartOffset);
            }
            switch (elementType) {
                case 6: {
                    lineStartOffset = 0;
                    String header = this.disassemblerDocument.get().substring(0, this.disassemblerDocument.get().indexOf("{"));
                    int startIndex = 0;
                    startIndex = header.indexOf("class");
                    if (startIndex != -1 || (startIndex = header.indexOf("enum")) != -1 || (startIndex = header.indexOf("interface")) != -1) {
                        elementIndex = startIndex + header.substring(startIndex).indexOf(elementName);
                        break;
                    }
                    elementIndex = header.indexOf(elementName);
                    break;
                }
                case 8: {
                    elementIndex = lineString.indexOf(" " + elementName + ";") + 1;
                    break;
                }
                case 9: {
                    elementIndex = lineString.indexOf(" " + elementName + "(") + 1;
                    break;
                }
                default: {
                    elementIndex = 0;
                    boolean bl = false;
                }
            }
            int elementLength = elementIndex == 0 ? 0 : elementName.length();
            disassemblerText.setSelection(lineStartOffset + elementIndex, lineStartOffset + elementIndex + elementLength);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void selectElement(StyledText disassemblerText, OutlineElement element) {
        int bytecodeDocumentLine = element.getBytecodeDocumentLine();
        if (element instanceof IType) {
            IType type = (IType)element;
            String name = type.getElementName();
            this.selectBytecodeLineAndReveal(disassemblerText, bytecodeDocumentLine, name, 6);
        } else if (element instanceof IOutlineElementField) {
            IOutlineElementField field = (IOutlineElementField)element;
            String name = field.getFieldSection().getName();
            this.selectBytecodeLineAndReveal(disassemblerText, bytecodeDocumentLine, name, 8);
        } else if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            String name = method.getElementName();
            this.selectBytecodeLineAndReveal(disassemblerText, bytecodeDocumentLine, name, 9);
        } else {
            this.selectLineAndRevaluate(disassemblerText, bytecodeDocumentLine);
        }
    }

    public void selectLineAndRevaluate(StyledText disassemblerText, int bytecodeLine) {
        try {
            int lineStartOffset = this.disassemblerDocument.getLineOffset(bytecodeLine);
            disassemblerText.setSelection(lineStartOffset);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OutlineElement searchElement(OutlineElement element, ISourceReference reference) throws CoreException {
        if (reference instanceof BinaryType) {
            if (element instanceof OutlineElementType) {
                OutlineElementType asmType = (OutlineElementType)element;
                BinaryType jdtType = (BinaryType)reference;
                String asmTypeName = asmType.getElementName();
                if (asmTypeName.indexOf(36) != -1 && (asmTypeName = asmTypeName.substring(asmTypeName.lastIndexOf(36) + 1)).matches("\\d+")) {
                    asmTypeName = "";
                }
                if (!asmTypeName.equals(jdtType.getElementName())) return null;
                return element;
            }
            IJavaElement[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                OutlineElement result;
                IJavaElement child = children[i];
                if (child instanceof OutlineElement && (result = this.searchElement((OutlineElement)child, reference)) != null) {
                    return result;
                }
                ++i;
            }
            return null;
        } else if (reference instanceof IField) {
            if (element instanceof OutlineElementField) {
                String asmType;
                String jdtType;
                OutlineElementField asmField = (OutlineElementField)element;
                IField jdtField = (IField)reference;
                String asmFieldName = (String)ReflectionUtils.getFieldValue(asmField, "elementName");
                if (asmFieldName.indexOf(36) != -1) {
                    asmFieldName = asmFieldName.substring(asmFieldName.lastIndexOf(36) + 1);
                }
                if (!asmFieldName.equals(jdtField.getElementName()) || !(jdtType = jdtField.getTypeSignature().replaceAll("<.*>", "")).equals(asmType = asmField.getTypeSignature().replace('/', '.'))) return null;
                return element;
            }
            IJavaElement[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                OutlineElement result;
                IJavaElement child = children[i];
                if (child instanceof OutlineElement && (result = this.searchElement((OutlineElement)child, reference)) != null) {
                    return result;
                }
                ++i;
            }
            return null;
        } else {
            IJavaElement[] children;
            if (!(reference instanceof IMethod)) return null;
            if (element instanceof OutlineElementMethod) {
                OutlineElementMethod asmMethod = (OutlineElementMethod)element;
                IMethod jdtMethod = (IMethod)reference;
                String asmMethodName = asmMethod.getElementName();
                if (asmMethodName.indexOf(36) != -1 && (asmMethodName = asmMethodName.substring(asmMethodName.lastIndexOf(36) + 1)).matches("\\d+")) {
                    asmMethodName = "";
                }
                if (!asmMethodName.equals(jdtMethod.getElementName()) || !asmMethod.getSignature().equals(jdtMethod.getSignature())) return null;
                if (!(jdtMethod.getParent() instanceof BinaryType)) return asmMethod;
                BinaryType jdtType = (BinaryType)jdtMethod.getParent();
                OutlineElementType asmType = (OutlineElementType)asmMethod.getDeclaringType();
                String asmTypeName = asmType.getElementName();
                if (asmTypeName.indexOf(36) != -1 && (asmTypeName = asmTypeName.substring(asmTypeName.lastIndexOf(36) + 1)).matches("\\d+")) {
                    asmTypeName = "";
                }
                if (!asmTypeName.equals(jdtType.getElementName())) return null;
                return element;
            }
            IJavaElement[] iJavaElementArray = children = element.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                OutlineElement result;
                IJavaElement child = iJavaElementArray[n2];
                if (child instanceof OutlineElement && (result = this.searchElement((OutlineElement)child, reference)) != null) {
                    return result;
                }
                ++n2;
            }
        }
        return null;
    }

    protected IConfigurationElement getConfigurationElement() {
        return (IConfigurationElement)ReflectionUtils.invokeMethod((Object)this.editor, "getConfigurationElement");
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().startsWith("BYTECODEMNEMONIC_")) {
            ((DisassemblerConfiguration)this.getSourceViewerConfiguration()).adaptToPreferenceChange(event);
            if (!this.styleChanged) {
                this.styleChanged = true;
                Display.getDefault().timerExec(10, new Runnable(){

                    @Override
                    public void run() {
                        DisassemblerSourceViewer.this.getSourceViewer().invalidateTextPresentation();
                        DisassemblerSourceViewer.this.styleChanged = false;
                    }
                });
            }
        } else if ((event.getProperty().startsWith("CLASS_FILE_ATTR_") || event.getProperty().equals("BRANCH_TARGET_ADDRESS_RENDERING")) && !this.docChanged) {
            this.docChanged = true;
            Display.getDefault().timerExec(10, new Runnable(){

                @Override
                public void run() {
                    DisassemblerSourceViewer.this.updateDocument((DisassemblerDocumentProvider)DisassemblerSourceViewer.this.getDocumentProvider(), DisassemblerSourceViewer.this.getSourceViewer());
                    if (DisassemblerSourceViewer.this.editor.getSelectedElement() != null) {
                        DisassemblerSourceViewer.this.setSelectionElement(DisassemblerSourceViewer.this.editor.getSelectedElement(), true);
                    }
                    DisassemblerSourceViewer.this.docChanged = false;
                }
            });
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isEditorInputReadOnly() {
        return true;
    }

    protected void handleCursorPositionChanged() {
        ReflectionUtils.invokeMethod((Object)this.editor, "handleCursorPositionChanged");
    }

    private class EditorSelectionChangedListener
    extends AbstractTextEditor.AbstractSelectionChangedListener {
        private EditorSelectionChangedListener() {
            super((AbstractTextEditor)DisassemblerSourceViewer.this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DisassemblerSourceViewer.this.doHandleCursorPositionChanged();
        }
    }

    class JdtSelectionProvider
    extends AbstractTextEditor.SelectionProvider {
        private List<ISelectionChangedListener> fSelectionListeners;
        private List<ISelectionChangedListener> fPostSelectionListeners;
        private ITextSelection fInvalidSelection;
        private ISelection fValidSelection;

        JdtSelectionProvider() {
            super((AbstractTextEditor)DisassemblerSourceViewer.this);
            this.fSelectionListeners = new ArrayList<ISelectionChangedListener>();
            this.fPostSelectionListeners = new ArrayList<ISelectionChangedListener>();
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            super.addSelectionChangedListener(listener);
            if (DisassemblerSourceViewer.this.getSourceViewer() != null) {
                this.fSelectionListeners.add(listener);
            }
        }

        public ISelection getSelection() {
            if (this.fInvalidSelection != null) {
                return this.fInvalidSelection;
            }
            return super.getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            super.removeSelectionChangedListener(listener);
            if (DisassemblerSourceViewer.this.getSourceViewer() != null) {
                this.fSelectionListeners.remove(listener);
            }
        }

        public void setSelection(ISelection selection) {
            if (selection instanceof ITextSelection) {
                if (this.fInvalidSelection != null) {
                    this.fInvalidSelection = null;
                    ITextSelection newSelection = (ITextSelection)selection;
                    ITextSelection oldSelection = (ITextSelection)this.getSelection();
                    if (newSelection.getOffset() == oldSelection.getOffset() && newSelection.getLength() == oldSelection.getLength()) {
                        this.markValid();
                    } else {
                        super.setSelection(selection);
                    }
                } else {
                    super.setSelection(selection);
                }
            } else if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof EditorBreadcrumb) {
                this.markInvalid();
            }
        }

        public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
            super.addPostSelectionChangedListener(listener);
            if (DisassemblerSourceViewer.this.getSourceViewer() != null && DisassemblerSourceViewer.this.getSourceViewer().getSelectionProvider() instanceof IPostSelectionProvider) {
                this.fPostSelectionListeners.add(listener);
            }
        }

        public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
            super.removePostSelectionChangedListener(listener);
            if (DisassemblerSourceViewer.this.getSourceViewer() != null) {
                this.fPostSelectionListeners.remove(listener);
            }
        }

        public boolean isValid(ISelection postSelection) {
            return this.fInvalidSelection == null && super.isValid(postSelection);
        }

        private void markInvalid() {
            this.fValidSelection = this.getSelection();
            this.fInvalidSelection = new TextSelection(0, 0);
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.fInvalidSelection);
            for (ISelectionChangedListener listener : this.fSelectionListeners) {
                listener.selectionChanged(event);
            }
            for (ISelectionChangedListener listener : this.fPostSelectionListeners) {
                listener.selectionChanged(event);
            }
        }

        private void markValid() {
            this.fInvalidSelection = null;
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.fValidSelection);
            for (ISelectionChangedListener listener : this.fSelectionListeners) {
                listener.selectionChanged(event);
            }
            for (ISelectionChangedListener listener : this.fPostSelectionListeners) {
                listener.selectionChanged(event);
            }
        }
    }
}

