/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.extension;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.sf.feeling.decompiler.extension.DecompilerAdapter;
import org.sf.feeling.decompiler.extension.DecompilerAdapterInvocationHandler;
import org.sf.feeling.decompiler.extension.ElementAdapterSet;

public class DecompilerAdapterManager {
    public static final String ADAPTERS_EXTENSION_ID = "org.sf.feeling.decompiler.decompilerAdapters";
    protected static final Logger logger = Logger.getLogger(DecompilerAdapterManager.class.getName());
    private static final Map<Class<?>, Set<?>> ADAPTERS_MAP = new HashMap(){
        private static final long serialVersionUID = 534728316184090251L;

        @Override
        public Object get(Object key) {
            Object obj = super.get(key);
            if (obj == null) {
                obj = new ElementAdapterSet();
                this.put(key, obj);
            }
            return obj;
        }
    };

    static {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(ADAPTERS_EXTENSION_ID);
        if (extensionPoint != null) {
            IConfigurationElement[] elementArr;
            IConfigurationElement[] iConfigurationElementArray = elementArr = extensionPoint.getConfigurationElements();
            int n = elementArr.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] adaptersConfigArr;
                IConfigurationElement element = iConfigurationElementArray[n2];
                String adaptableClassName = element.getAttribute("class");
                Class<?> adaptableType = null;
                IConfigurationElement[] iConfigurationElementArray2 = adaptersConfigArr = element.getChildren("adapter");
                int n3 = adaptersConfigArr.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement adapterConfig = iConfigurationElementArray2[n4];
                    String adapterClassName = null;
                    Class<?> adapterType = null;
                    try {
                        DecompilerAdapter adapter = new DecompilerAdapter();
                        adapter.setId(adapterConfig.getAttribute("id"));
                        adapter.setSingleton(!"false".equals(adapterConfig.getAttribute("singleton")));
                        if (adapterConfig.getAttribute("class") != null && !adapterConfig.getAttribute("class").equals("")) {
                            adapter.setAdapterInstance(adapterConfig.createExecutableExtension("class"));
                            if (!adapter.isSingleton()) {
                                adapter.setAdapterConfig(adapterConfig);
                            }
                        } else if (adapterConfig.getAttribute("factory") != null && !adapterConfig.getAttribute("factory").equals("")) {
                            adapter.setFactory((IAdapterFactory)adapterConfig.createExecutableExtension("factory"));
                        }
                        if (adaptableType == null) {
                            adaptableType = DecompilerAdapterManager.classForName(adaptableClassName, adapter.getAdapterInstance(), adapter.getFactory());
                        }
                        adapter.setAdaptableType(adaptableType);
                        adapterClassName = adapterConfig.getAttribute("type");
                        adapterType = DecompilerAdapterManager.classForName(adapterClassName, adapter.getAdapterInstance(), adapter.getFactory());
                        adapter.setAdapterType(adapterType);
                        if (adapterConfig.getAttribute("priority") != null && !adapterConfig.getAttribute("priority").equals("")) {
                            try {
                                adapter.setPriority(Integer.parseInt(adapterConfig.getAttribute("priority")));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (adapterConfig.getAttribute("overwrite") != null && !adapterConfig.getAttribute("overwrite").equals("")) {
                            adapter.setOverwrite(adapterConfig.getAttribute("overwrite").split(";"));
                        }
                        adapter.setIncludeWorkbenchContribute("true".equals(adapterConfig.getAttribute("includeWorkbenchContribute")));
                        IConfigurationElement[] enablements = adapterConfig.getChildren("enablement");
                        if (enablements != null && enablements.length > 0) {
                            adapter.setExpression(ExpressionConverter.getDefault().perform(enablements[0]));
                        }
                        DecompilerAdapterManager.registerAdapter(adaptableType, adapter);
                    }
                    catch (ClassNotFoundException ce) {
                        if (adaptableType == null) {
                            System.out.println(MessageFormat.format("Adaptable Type class '{0}' not found!", adaptableClassName));
                            logger.log(Level.SEVERE, ce.getMessage(), ce);
                        } else {
                            System.out.println(MessageFormat.format("Adapter Type class '{0}' not found!", adapterClassName));
                            logger.log(Level.SEVERE, ce.getMessage(), ce);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Register adapter error!");
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Class<?> classForName(String className, Object adapterInstance, IAdapterFactory adapterFacotry) throws ClassNotFoundException {
        block9: {
            clazz = null;
            if (adapterInstance != null) {
                try {
                    clazz = adapterInstance.getClass().getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException var4_4) {
                    // empty catch block
                }
            }
            if (clazz == null && adapterFacotry != null) {
                try {
                    clazz = adapterFacotry.getClass().getClassLoader().loadClass(className);
                    break block9;
                }
                catch (ClassNotFoundException ex) {
                    adapterClassArr = adapterFacotry.getAdapterList();
                    if (adapterClassArr == null) break block9;
                    var9_7 = adapterClassArr;
                    var8_8 = adapterClassArr.length;
                    var7_9 = 0;
                    ** while (var7_9 < var8_8)
                }
lbl-1000:
                // 1 sources

                {
                    adapterClass = var9_7[var7_9];
                    if (className.equals(adapterClass.getName())) {
                        clazz = adapterClass;
                        break;
                    }
                    ++var7_9;
                    continue;
                }
            }
        }
        if (clazz == null) {
            clazz = Class.forName(className);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAdapter(Class adaptableType, DecompilerAdapter adapter) {
        Map<Class<?>, Set<?>> map = ADAPTERS_MAP;
        synchronized (map) {
            Set<?> adapterSet = ADAPTERS_MAP.get(adaptableType);
            adapterSet.add(adapter);
        }
    }

    public static Object getAdapter(Object adaptableObject, Class adapterType) {
        List adapterObjects = DecompilerAdapterManager.getAdapterList(adaptableObject, adapterType);
        if (adapterObjects == null || adapterObjects.size() == 0) {
            return null;
        }
        if (adapterObjects.size() == 1) {
            return adapterObjects.get(0);
        }
        return Proxy.newProxyInstance(adapterType.getClassLoader(), new Class[]{adapterType}, (InvocationHandler)new DecompilerAdapterInvocationHandler(adapterObjects));
    }

    public static <T> List<T> getAdapterList(Object adaptableObject, Class<T> adapterType) {
        Set<DecompilerAdapter> adapters = DecompilerAdapterManager.getAdaptersInternal(adaptableObject);
        if (adapters == null) {
            return null;
        }
        ArrayList<Object> adapterObjects = new ArrayList<Object>(adapters.size());
        for (DecompilerAdapter adapter : adapters) {
            Object obj;
            if (adapter.getExpression() != null) {
                EvaluationContext context = new EvaluationContext(null, adaptableObject);
                context.setAllowPluginActivation(true);
                try {
                    if (adapter.getExpression().evaluate((IEvaluationContext)context) != EvaluationResult.TRUE) {
                        continue;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            if ((obj = adapter.getAdater(adaptableObject)) == null || !adapterType.isAssignableFrom(obj.getClass())) continue;
            adapterObjects.add(obj);
        }
        return adapterObjects;
    }

    private static Set<DecompilerAdapter> getAdaptersInternal(Object adaptableObject) {
        Set<Class<?>> keys = ADAPTERS_MAP.keySet();
        ElementAdapterSet adapters = null;
        for (Class<?> clazz : keys) {
            if (!clazz.isAssignableFrom(adaptableObject.getClass())) continue;
            if (adapters == null) {
                adapters = new ElementAdapterSet();
            }
            Set<?> set = ADAPTERS_MAP.get(clazz);
            for (Object obj : set) {
                adapters.add((DecompilerAdapter)obj);
            }
        }
        if (adapters != null) {
            adapters.removeOverwrittenAdapters();
        }
        return adapters;
    }
}

