/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.util.IOUtils;

public class FileUtil {
    public static void writeToFile(File file, String string) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            String encoding = null;
            try {
                encoding = JavaDecompilerPlugin.getDefault().getExportEncoding();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (encoding == null || encoding.trim().length() == 0) {
                encoding = StandardCharsets.UTF_8.name();
            }
            Throwable throwable = null;
            Object var4_7 = null;
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));){
                out.print(string);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToBinarayFile(File file, InputStream source, boolean close) {
        block19: {
            BufferedInputStream bis = null;
            try {
                bis = new BufferedInputStream(source);
                if (!file.exists()) {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                }
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedOutputStream fouts = new BufferedOutputStream(new FileOutputStream(file));){
                    byte[] b = new byte[16384];
                    int i = 0;
                    while ((i = bis.read(b)) != -1) {
                        fouts.write(b, 0, i);
                    }
                    fouts.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (close) {
                    bis.close();
                }
            }
            catch (IOException e) {
                Logger.getLogger(FileUtil.class.getName()).log(Level.WARNING, "Write binaray file failed.", e);
                if (!close) break block19;
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException f) {
                    Logger.getLogger(FileUtil.class.getName()).log(Level.WARNING, "Close input stream failed.", f);
                }
            }
        }
    }

    public static boolean copyFile(String src, String des) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(src);){
                FileUtil.writeToBinarayFile(new File(des), fis, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Logger.getLogger(FileUtil.class.getName()).log(Level.WARNING, "Copy file failed.", e);
        }
        return false;
    }

    public static boolean copyDirectory(File srcDirectory, File desDirectory) {
        if (srcDirectory == null || desDirectory == null) {
            return false;
        }
        return FileUtil.copyDirectory(srcDirectory.getAbsolutePath(), desDirectory.getAbsolutePath(), null);
    }

    public static boolean copyDirectory(String srcDirectory, String desDirectory) {
        return FileUtil.copyDirectory(srcDirectory, desDirectory, null);
    }

    public static boolean copyDirectory(String srcDirectory, String desDirectory, FileFilter filter) {
        try {
            File des = new File(desDirectory);
            if (!des.exists()) {
                des.mkdirs();
            }
            File src = new File(srcDirectory);
            File[] allFile = src.listFiles();
            int totalNum = allFile.length;
            String srcName = "";
            String desName = "";
            int currentFile = 0;
            currentFile = 0;
            while (currentFile < totalNum) {
                if (!allFile[currentFile].isDirectory()) {
                    srcName = allFile[currentFile].toString();
                    desName = String.valueOf(desDirectory) + File.separator + allFile[currentFile].getName();
                    if (filter == null || filter.accept(new File(srcName))) {
                        FileUtil.copyFile(srcName, desName);
                    }
                } else if (!FileUtil.copyDirectory(allFile[currentFile].getPath().toString(), String.valueOf(desDirectory) + File.separator + allFile[currentFile].getName().toString(), filter)) {
                    Logger.getLogger(FileUtil.class.getName()).log(Level.WARNING, "Copy sub directory " + srcDirectory + "failed.");
                }
                ++currentFile;
            }
            return true;
        }
        catch (Exception e) {
            Logger.getLogger(FileUtil.class.getName()).log(Level.WARNING, "Copy directory " + srcDirectory + "failed.", e);
            return false;
        }
    }

    public static void copyDirectoryToDirectory(File srcDir, File destDir) throws IOException {
        FileUtil.copyDirectoryToDirectory(srcDir, destDir, null);
    }

    public static void copyDirectoryToDirectory(File srcDir, File destDir, FileFilter filter) throws IOException {
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (srcDir.exists() && !srcDir.isDirectory()) {
            throw new IllegalArgumentException("Source '" + destDir + "' is not a directory");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + destDir + "' is not a directory");
        }
        FileUtil.copyDirectory(srcDir.getAbsolutePath(), new File(destDir, srcDir.getName()).getAbsolutePath(), filter);
    }

    public static long sizeOfDirectory(File directory) {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        long size = 0L;
        File[] files = directory.listFiles();
        if (files == null) {
            return 0L;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            size = file.isDirectory() ? (size += FileUtil.sizeOfDirectory(file)) : (size += file.length());
            ++i;
        }
        return size;
    }

    public static void deleteDirectory(IProgressMonitor monitor, File directory, File base, int step) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtil.cleanDirectory(monitor, directory, base, step);
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    public static void deleteDirectory(IProgressMonitor monitor, File directory, int step) throws IOException {
        FileUtil.deleteDirectory(monitor, directory, directory, step);
    }

    public static void cleanDirectory(IProgressMonitor monitor, File directory, File base, int step) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        IOException exception = null;
        boolean isPackage = false;
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (!isPackage && file.isFile()) {
                isPackage = true;
            }
            try {
                FileUtil.forceDelete(monitor, file, base, step);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
            ++i;
        }
        if (isPackage && monitor != null) {
            monitor.worked(step);
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void forceDelete(IProgressMonitor monitor, File file, File base, int step) throws IOException {
        if (file.isDirectory()) {
            FileUtil.deleteDirectory(monitor, file, base, step);
        } else {
            if (monitor != null) {
                String taskName = file.getAbsolutePath().substring(base.getAbsolutePath().length() + new Long(System.currentTimeMillis()).toString().length() + 2);
                monitor.subTask(taskName);
            }
            if (!file.exists()) {
                throw new FileNotFoundException("File does not exist: " + file);
            }
            if (!file.delete()) {
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
    }

    public static void recursiveZip(IProgressMonitor monitor, ZipOutputStream zos, File file, String path, FileFilter filter, int step) throws FileNotFoundException, IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles(filter);
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    FileUtil.recursiveZip(monitor, zos, files[i], String.valueOf(path.length() > 0 ? String.valueOf(path) + "/" : path) + files[i].getName(), filter, step);
                    ++i;
                }
            }
            if (monitor != null) {
                monitor.worked(step);
            }
        }
        if (file.isFile()) {
            if (monitor != null) {
                monitor.subTask(path);
            }
            byte[] bt = new byte[4096];
            ZipEntry ze = new ZipEntry(path);
            ze.setSize(file.length());
            zos.putNextEntry(ze);
            Throwable throwable = null;
            Object var9_11 = null;
            try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));){
                int i = 0;
                while ((i = fis.read(bt)) != -1) {
                    zos.write(bt, 0, i);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static void zipFile(File file, String zipFile) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));){
            ZipEntry ze = null;
            byte[] buf = new byte[4096];
            int readLen = 0;
            ze = new ZipEntry(file.getName());
            ze.setSize(file.length());
            ze.setTime(file.lastModified());
            zos.putNextEntry(ze);
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                while ((readLen = ((InputStream)is).read(buf)) != -1) {
                    zos.write(buf, 0, readLen);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static void filterZipFile(String filePath, Filter filter) throws Exception {
        if (FileUtil.isZipFile(filePath) && filter != null) {
            File tmpFile;
            File file = new File(filePath);
            Throwable throwable = null;
            Object var5_5 = null;
            try (ZipFile zipFile = new ZipFile(file);){
                Throwable throwable2 = null;
                Object var8_10 = null;
                try (ZipInputStream zis = new ZipInputStream(new FileInputStream(file));){
                    ZipEntry entry = null;
                    InputStream input = null;
                    tmpFile = new File(file + ".tmp");
                    Throwable throwable3 = null;
                    Object var13_18 = null;
                    try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tmpFile));){
                        zos.setLevel(1);
                        while ((entry = zis.getNextEntry()) != null) {
                            if (!filter.accept(entry.getName())) continue;
                            input = zipFile.getInputStream(entry);
                            ZipEntry ze = new ZipEntry(entry.getName());
                            ze.setSize(entry.getSize());
                            ze.setTime(entry.getTime());
                            zos.putNextEntry(ze);
                            IOUtils.copy(zis, zos);
                            input.close();
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
            file.delete();
            tmpFile.renameTo(file);
        }
    }

    public static void zipDir(File dir, String classPackage, String zipFile) throws Exception {
        File[] files = null;
        if (new File(dir, classPackage).exists()) {
            files = new File(dir, classPackage).listFiles();
        } else if (dir.exists()) {
            files = dir.listFiles();
        }
        if (files != null) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));){
                ZipEntry ze = null;
                byte[] buf = new byte[4096];
                int readLen = 0;
                int i = 0;
                while (i < files.length) {
                    File file = files[i];
                    if (!file.isDirectory()) {
                        ze = new ZipEntry(String.valueOf(classPackage.length() > 0 ? String.valueOf(classPackage) + "/" : "") + file.getName());
                        ze.setSize(file.length());
                        ze.setTime(file.lastModified());
                        zos.putNextEntry(ze);
                        Throwable throwable2 = null;
                        Object var13_16 = null;
                        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                            while ((readLen = ((InputStream)is).read(buf)) != -1) {
                                zos.write(buf, 0, readLen);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZipFile(String path) {
        if (path == null) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                ZipFile zipFile = new ZipFile(path);
                if (zipFile == null) return true;
                zipFile.close();
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getContent(File file) {
        return FileUtil.getContent(file, Charset.defaultCharset().name());
    }

    /*
     * Loose catch block
     */
    public static String getContent(File file, String enconding) {
        if (file == null || !file.exists()) {
            return null;
        }
        long fileLenLong = file.length();
        if (fileLenLong > Integer.MAX_VALUE) {
            throw new RuntimeException("File too large: " + file);
        }
        int fileLen = (int)fileLenLong;
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try {
                String string;
                ByteArrayOutputStream out;
                BufferedInputStream is;
                block21: {
                    block20: {
                        int r;
                        is = new BufferedInputStream(new FileInputStream(file));
                        out = new ByteArrayOutputStream(fileLen);
                        byte[] tmp = new byte[4096];
                        while ((r = ((InputStream)is).read(tmp)) != -1) {
                            out.write(tmp, 0, r);
                        }
                        byte[] bytes = out.toByteArray();
                        String content = new String(bytes, enconding);
                        string = content.trim();
                        if (out == null) break block20;
                        out.close();
                    }
                    if (is == null) break block21;
                    ((InputStream)is).close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (out != null) {
                                out.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (is != null) {
                                ((InputStream)is).close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeToFile(File file, String string, String encoding) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));){
                out.print(string);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void deltree(File root) {
        if (root == null || !root.exists()) {
            return;
        }
        if (root.isFile()) {
            root.delete();
            return;
        }
        File[] children = root.listFiles();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                FileUtil.deltree(children[i]);
                ++i;
            }
        }
        root.delete();
    }

    public static interface Filter {
        public boolean accept(String var1);
    }
}

