/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    public static String md5Hash(File file) {
        if (file != null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (FileInputStream fis = new FileInputStream(file);){
                    return HashUtils.hexDigestOfStream(fis, MessageDigest.getInstance("MD5"));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static String sha1Hash(File file) {
        if (file != null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (FileInputStream fis = new FileInputStream(file);){
                    return HashUtils.hexDigestOfStream(fis, MessageDigest.getInstance("SHA-1"));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static String md5Hash(String string) {
        if (string == null) {
            return null;
        }
        byte[] content = string.getBytes(StandardCharsets.UTF_8);
        if (content != null) {
            try {
                return HashUtils.hexDigestOfStream(new ByteArrayInputStream(content), MessageDigest.getInstance("MD5"));
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static byte[] sha1Digest(File file) {
        String md5 = HashUtils.sha1Hash(file);
        if (md5 != null) {
            return md5.getBytes();
        }
        return null;
    }

    private static String hexDigestOfStream(InputStream in, MessageDigest digest) throws IOException {
        DigestInputStream din = new DigestInputStream(in, digest);
        byte[] buffer = new byte[32768];
        while (din.read(buffer) >= 0) {
        }
        return new BigInteger(1, digest.digest()).toString(16);
    }
}

